unit FDefs;
{+doc
+NOMBRE: FDEFS
+CREACION: 18.3.1992
+AUTOR: Ruben Chaer.
+REVISION:
+AUTOR: rch.
+REGISTRO:
+TIPO: Unidad Pascal.
+PROPOSITO: Definicin del lgebra de funciones reales.
+PROYECTO: ARTEF1. (RCh)
+DESCRIPCION:
-doc}


interface
uses
	SysUtils;

type
	archivo= file;

	Tfreal = class
		constructor Create;
		procedure Free; virtual;
		function fval(x:real):real;virtual; abstract;
		function devx(x:real):real;virtual; abstract;
		procedure Save(var f:archivo);virtual;
		constructor Load(var f:archivo);
	end;

	LVR = array[0..10000] of real;
	LVRPtr = ^LVR;

	Tftabla = class(Tfreal)
		tabla:LVRPtr;
		dx:real;
		N,NMaxMas1:integer;
		x0,xN:real;
		constructor Create(NumeroMaximoDeElementos:integer);
		procedure SetXN(sx0,sxN:real;sN:integer);
		procedure Free;virtual;
		procedure Save(var f:Archivo);virtual;
		constructor Load(var f:Archivo);
		function fval(x:real):real;virtual;
		function devx(x:real):real;virtual;
		function get(k:integer):real;
		procedure put(k:integer; NuevoValor:real);
	end;

	Tparabola = class(Tfreal)     { a x2 + bx + c }
		a,b,c:real;
		constructor Create(sa,sb,sc:real);
		function fval(x:real):real;virtual;
		function devx(x:real):real;virtual;
		procedure Save(var f:archivo);virtual;
		constructor Load(var f:archivo);
		procedure Raices(
			var x1,x2:real;
			var tipo:integer );
			{ 	si tipo = 1 , hay dos raices reales distintas x1 y x2.
				si tipo = 0 , hay una raiz real doble    x1 = x2 = raiz.
				si tipo = -1, hay dos raices complejas conjugadas
									x1 = parte real.
									y1 = parte imaginaria. (>0).
			}
	end;

	TRaizCuadrada = Class(Tfreal) { sqr(x) }
		function fval(x:real):real;virtual;
		function devx(x:real):real;virtual;
	end;


	Tf_Compuesta = Class(Tfreal)
		p_ff, p_fx: Tfreal;
		constructor Create( ff,fx: Tfreal );
		procedure Free; virtual;

		function fval(x:real):real;virtual;
			{ fval = ff(fx(x)) }
		function devx(x:real):real;virtual;

		procedure Save(var f:archivo);virtual;
		constructor Load(var f:archivo);
	end;



{ signo, retorna -1, 0 o 1 segn el valor de x }
function signo(x:real):integer;

implementation


function signo(x:real):integer;
begin
	if x> 0 then signo:= 1
	else if x < 0 then signo := -1
		else signo:=0
end;

{mtodos de freal}

procedure error(NumeroDeError:integer);
begin
	writeln('=============================');
	writeln('error: {FDEFS}, ',NumeroDeError);
	halt(1);
end;
procedure abstract;
begin
	error(0)
end;

constructor Tfreal.Create;
begin
	inherited Create;
end;

procedure Tfreal.Free;
begin
	inherited Free;
end;


constructor Tfreal.Load(var f:archivo);
begin
end;

procedure Tfreal.Save(var f:archivo);
begin
end;

{mtodos de ftabla}

constructor Tftabla.Create(NumeroMaximoDeElementos:integer);
begin
	inherited Create;
	getMem(tabla,NumeroMaximoDeElementos*SizeOf(real));
	N:=0;
	NMaxMas1:=NumeroMaximoDeElementos;
end;

procedure Tftabla.SetXN(sx0,sxN:real;sN:integer);
begin
	if sN>=NMaxMas1 then Error(2);
	x0:=sx0;
	xN:=sxN;
	N:=sN;
	dX:=(xN-x0)/N;
end;

procedure Tftabla.Free;
begin
	FreeMem(tabla,NMaxMas1*SizeOf(real));
	N:=0;
	inherited Free;
end;

function Tftabla.fval(x:real):real;
var
	k:integer;
	y1,y0:real;
begin
	k:=trunc((x-x0) /dx);
	if (k<0) or (k>=N) then fval:=0
	else
	begin
		y1:=tabla^[k+1];
		y0:=tabla^[k];
		fval:=(y1-y0)*(x/dx-k)+y0;
	end
end;

function Tftabla.get(k:integer):real;
begin
	{$IFOPT R+}
	if (k<0)or(k>N) then
		raise Exception.Create('Tftabla.get, k fuera de rango');
	{$ENDIF}
	get:=tabla^[k];
end;

procedure Tftabla.put(k:integer;NuevoValor:real);
begin
	{$IFOPT R+}
	if (k<0)or(K>N) then
			raise Exception.Create('Tftabla.put, k fuera de rango');
	{$ENDIF}
	tabla^[k]:=NuevoValor;
end;


function Tftabla.devx(x:real):real;
begin
	devx:=(fval(x+dx)-fval(x-dx))/(2*dx);
end;

procedure Tftabla.Save(var f:archivo);
begin
	inherited save(f);
	BlockWrite(f,NMaxMas1,SizeOf(Integer));
	BlockWrite(f,N,SizeOf(integer));
	BlockWrite(f,dx,SizeOf(real));
	BlockWrite(f,x0,SizeOf(real));
	BlockWrite(f,xN,SIzeOf(real));
	BlockWrite(f,tabla^,(N+1)*SizeOf(real));
end;

constructor Tftabla.Load(var f:archivo);
begin
	inherited load(f);
	BlockRead(f, NMaxMas1,SizeOf(Integer));
	GetMem(tabla,NMaxMas1*SizeOf(real));
	BlockRead(f, N,SizeOf(integer));
	BlockRead(f, dx,SizeOf(real));
	BlockRead(f, x0,SizeOf(real));
	BlockRead(f, xN,SIzeOf(real));
	BlockRead(f, tabla^,(N+1)*SizeOf(real));
end;


{ Mtodos de PARABOLA }

constructor Tparabola.Create(sa,sb,sc:real);
begin
	inherited Create;
	a:=sa;b:=sb;c:=sc;
end;


function Tparabola.fval(x:real):real;
begin
	fval:=(a*x+b)*x+c
end;

function Tparabola.devx(x:real):real;
begin
	devx:=2*a*x+b
end;

procedure Tparabola.Save(var f:archivo);
begin
	inherited save(f);
	BlockWrite(f, a,SizeOf(a));
	BlockWrite(f, b,SizeOf(b));
	BlockWrite(f, c,SizeOf(c));
end;

constructor Tparabola.Load(var f:archivo);
begin
	inherited Load(f);
	BlockRead( f, a,SizeOf(a));
	BlockRead( f, b,SizeOf(b));
	BlockRead( f, c,SizeOf(c));
end;


procedure Tparabola.Raices(
			var x1,x2:real;
			var tipo:integer );
			{
				si tipo = 1 , hay dos raices reales distintas x1 y x2.
				si tipo = 0 , hay una raiz real doble    x1 = x2 = raiz.
				si tipo = -1, hay dos raices complejas conjugadas
									x1 = parte real.
									y1 = parte imaginaria. (>0).
				si tipo = 2, una raiz simple ( a = 0 ), x1 = x2 = raiz
				si tipo = -2, NO EXISTE SOLUCION ( a = b = 0 ).
			}

var
	delta:real;

begin
	if a= 0 then
	begin
		if b = 0 then tipo := -2
		else
		begin
			tipo := 2;
			x1:=-c/b;
			x2:=x1
		end;
		exit
	end;

	delta:= sqr(b) -4*a*c;
	if delta > 0 then
	begin
		tipo:=1;
		delta:=sqrt(delta);
		x1:= (-b+delta)/(2*a);
		x2:= (-b-delta)/(2*a);
	end
	else if delta = 0 then
	begin
		tipo:=0;
		x1:=- b/(2*a);
		x2:=x1
	end
	else { delta < 0 }
	begin
		tipo:= -1;
		delta:= sqrt(-delta);
		x1:= - b/(2*a);
		x2:= delta / (2*a)
	end;
end;




{ mtodos de RaizCuadrada }

function TRaizCuadrada.fval(x:real):real;
begin
	fval:=sqrt(x)
end;

function TRaizCuadrada.devx(x:real):real;
begin
	devx:=0.5/sqrt(x);
end;


{ mtodos de funcin compuesta }

constructor Tf_Compuesta.Create( ff,fx: Tfreal );
begin
	p_ff:=ff;
	p_fx:=fx;
end;

procedure Tf_Compuesta.Free;
begin
	p_fx.Free;
	p_ff.Free;
	inherited Free;
end;

function Tf_Compuesta.fval(x:real):real;
var
	y:real;
begin
	y:=p_fx.fval(x);
	fval:=p_ff.fval(y)
end;


function Tf_Compuesta.devx(x:real):real;
var
	y:real;
begin
	y:=p_fx.fval(x);
	devx:=p_ff.devx(y)* p_fx.devx(x)
end;

procedure Tf_Compuesta.Save(var f:archivo);
begin
	inherited save(f);
	p_ff.save(f);
	p_fx.save(f);
end;

constructor Tf_Compuesta.Load(var f:archivo);
begin
	inherited load(f);
	p_ff.load(f);
	p_fx.load(f);
end;



end.