{+doc
+NOMBRE: Hibrido2
+CREACION: 10.7.95
+AUTORES:   gcp, rch
+REGISTRO:
+TIPO: programa Pascal.
+PROPOSITO:
	USADO POR hibrid2.-

+PROYECTO: autonoma

+REVISION:SIGUIENTE VERSION DE HIBRID0.PAS PARA LAS NUEVAS
FUENTES DE SOL.
+AUTOR:
+DESCRIPCION:
-doc}


{$IFDEF WIN32}
		  {$IFDEF FPK}
					 {$DEFINE WIN32FPK}
		  {$ELSE}
					 {$DEFINE WIN32DELPHI}
		  {$ENDIF}
{$ENDIF}

program hibrido2;


uses
{$IFDEF WIN32DELPHI}
  Windows,
  Dialogs,
  Forms,
  uTraxpForm in 'uTraxpForm.pas' {Form1},
{$ENDIF}
  SysUtils,
  NucleoT,
  task2,
  VGlbs02,
  Params,
  ulistas,
  Ancestor,
  Horrores,
  xMatDefs,
  Actores,
  Dire02,
  Evals02,
  Aeros,
  ActBat04,
  FntVnts,
  FDSol,
  PlotHist,
  Lexemas,
  demht,
  OfeDem02,
  TabP2d,
  FDefs,
  bases,
  ActBat02,
  fdias02,
  Ocurrenx,
  AutoEsca,
  FDSol03,
  ActPan04,
  uSeresVivos,
  {$I xTraxp},
  uescenario;





var
	DiasPermitidosDeDeficit,
	VentanaDeDeficit,
	VentanaDeExcesos: integer;

	NombreDelAerogenerador: string;
	ArchivoDeDatosDeViento: string;
	FactorDeViento: NReal; {*******esta a 1 en vrbls.pas *******}



var
	PerfilCDC: TPerfilCDC;
	EstacionalCDC: TEstacionalesCDC;

	Bat_CT:NReal;
	Bat_TN:NReal;
	Bat_ID:NReal;
	Bat_IR:NReal;
	Bat_VN:NReal;
	Bat_rc:NReal; { rendimiento de carga }
	Bat_x1:NReal;
	Bat_y1:NReal;
	Bat_x2:NReal;
	Bat_y2:NReal;
	Paneles_Numero:integer;
	Paneles_PotenciaPicoPorPanel:NReal;
	Paneles_InclinacionDePaneles:NReal;



	ImpFecha: boolean;
	ConsumoDiario,
	PC_Diurno,
	CapacidadDeBateria,
	PPCB: NReal;
	NumeroDePanelesDe48W:NReal;
	Latitud,
	Longitud: NReal;

	DiasDeDeficitResultante: NReal;

	Quantum: NReal;

	xF: FDSol03.TFDeSolDat; {******tenia AnilloRuidoso}
	xpanel: TPanel;

	xfv: TFuenteDeViento;
	xag: TAeroGenerador;


	Demanda: TDemHT;
	bateria: ActBat04.TBateriaHD;
	e1, e2 :Evals02.TEvaluador;
	confianza: NReal;
	contador:integer;
	txt:string;
	fbat: text;


	auto:boolean;

procedure GraficarCapBat(var alp); far;
{
var
	c: char;}
begin
{   ????rch.marzo2004 este bolazo ac????
	while keypressed do c:= readkey;
	if c = 'S' then Halt(1);
	}
	write(fbat,
		Escenario.tictac.anio:4,#9,
		ord(Escenario.tictac.mes)+1:2,#9,
		Escenario.tictac.diadelmes:2,#9,
		Escenario.tictac.Hora:2);
	writeln(fbat, trunc(bateria.Co):6);
	TrazoXY(0, Escenario.tictac.Hora, bateria.Co);
end;

procedure ImprimirFecha(var alp); far;
begin
	ImpFecha:= true;
end;


procedure LeerEscenario( var f: text );
var
	k, m:integer;
	kmes: T_Mes;

begin
	readln(f);
	readln(f,  Latitud, Longitud);
	readln(f);

	readln(f, ArchivoDeDatosDeViento);
	readln(f);
	readln(f, FactorDeViento );
	readln(f);
	readln(f, NombreDelAerogenerador);
	readln(f);

	for k:=0 to 23 do readln( f, m, PerfilCDC[k] );
	readln(f);

	for kmes:=enero to diciembre do readln( f, m, EstacionalCDC[kmes] );
	readln(f);

	readln(f, m, CapacidadDeBateria);
	readln(f, m, Bat_CT);
	readln(f, m, Bat_TN);
	readln(f, m, Bat_ID);
	readln(f, m, Bat_IR);
	readln(f, m, Bat_VN);
	readln(f, m, PPCB);
	readln(f, m, Bat_rc); { rendimiento de carga }
	readln(f, m, Bat_x1);
	readln(f, m, Bat_y1);
	readln(f, m, Bat_x2);
	readln(f, m, Bat_y2);

	readln(f);
	readln(f, Paneles_Numero);
	readln(f);
	readln(f, Paneles_PotenciaPicoPorPanel);
	readln(f);
	readln(f, Paneles_InclinacionDePaneles);
	readln(f);
	readln(f, escenario.PeriodosTotales);
	inc(escenario.PeriodosTotales);
	readln(f);
	readln(f, DiasPermitidosDeDeficit);
	VentanaDeDeficit := 2 * DiasPermitidosDeDeficit;
	VentanaDeExcesos := VentanaDeDeficit;

	NumeroDePanelesDe48W:= Paneles_Numero*Paneles_PotenciaPicoPorPanel/48;
	auto:= false;
end;



procedure ALInicio;
var
	rescod: integer;
	k:integer;
	tmp:string;
	f: text;
	ArchiEscn: string;

label FinPrint;

begin

{????rch.marzo.2004
	while keypressed do if readkey='l' then;
}

	if ParamCount= 0 then
		ArchiEscn:= 'esc_neg05.txt'
	else
		ArchiEscn:= ParamStr(1);

	assign(f, ArchiEscn );
	{$I-}
	reset(f);
	{$I+}
	if ioresult <> 0 then
		error('No pude leer el archivo de escenario: '+ArchiEscn );

	LeerEscenario(f);
	close(f);


	assign(fbat, 'CapBat.log');
	rewrite(fbat);

	escenario.FijarLatido( Lat_Hora );


	RandSeed:=31;
	contador:=0;

	Escenario.PeriodosTotales:=50;

	xF:= FDSol03.TFDeSolDat.Create(Escenario, 'fdsol03_sistema_prn.txt');

	{ antes xF.init(Latitud, Longitud );}

	 Escenario.tictac.FijarInstante(
		xF.PrimerAnio,
		T_Mes(xF.PrimerMes-1),
		xF.PrimerDia,
		0, 0, 0 );

	xF.CadaDia;
	{hasta aca es lo sacado de prueba.sim}
	xpanel:= TPanel.Create(               {******** verificar 0.36}
			Escenario,
			NumeroDePanelesDe48W * 0.36, { rea en m2 del panel }
			xF, { Fuente de energa solar }
			Paneles_InclinacionDePaneles);  { ngulo de colocacin del panel }

	Quantum := 0;
	Demanda := TDemHT.Create(
		Escenario,
		@PerfilCDC,
		@EstacionalCDC, 8);
	Demanda.AcumQ(Quantum);

	Bateria:= ActBat04.TBateriaHD.Create(
			Escenario,
			CapacidadDeBateria, {Ah}
			Bat_TN,  {TN}
			Bat_CT, {CT}
			Bat_IR,  {ImaxR}    {en hibrido.pas estaba /10}
			Bat_ID,   {ImaxD}
			Bat_VN,  {VN}
			PPCB,
			Bat_rc,
			bat_x1, bat_x2, bat_y1, bat_y2 );




	xfv:= TFuenteDeViento.Create( FactorDeViento, ArchivoDeDatosDeViento );
	xag:= TAeroGenerador.Create(
		Escenario,
		NombreDelAerogenerador, xfv, 1); { prioridad }


	Quantum:=Quantum/24;
	e1:= Evals02.TEvaluador.Create( 8, 8, Deficit, Quantum * VentanaDeDeficit, VentanaDeDeficit);
	e2:= Evals02.TEvaluador.Create( 1, 4, Exceso, 20*Quantum * VentanaDeExcesos, VentanaDeExcesos);

	Escenario.TicTac.CadaDia.AgregarProcTarea(ImprimirFecha, VACIA);
	Escenario.TicTac.CadaHora.AgregarProcTarea(Gestion, VACIA);
	Escenario.TicTac.CadaDia.AgregarProcTarea(CadaPeriodoDeEvaluacion, VACIA);

	gridY:=10;
	gridX:=12;
	Traxp_tInicial:=0;
	Traxp_Tfinal:= 24;
{$IFDEF WIN32DELPHI}
//	InicieGr(;
{$ELSE}
	InicieGr;
{$ENDIF}
	gridY:=10;
	gridX:=12;
	Traxp_tInicial:=0;
	Traxp_Tfinal:= 24;
	Subplot(2,2);

	borreCanal(1,0);
	definaColor(0,rojo);
	definaY(0,0,bateria.CN/10);
	definaX(0,0, 24/GridX);
	titulo(' Estado de carga del banco de baterias ');
	xlabel(' 2h/DIV');
	ylabel(' de 0 a 100% ');
	grid;

	Escenario.TicTac.CadaHora.AgregarProcTarea(GraficarCapBat, VACIA);
	definaY(1,0,0.1);
	borrecanal(1,0);

FinPrint:

end;

procedure AlFinal; far;
var
	fout: text;
	c: char;
	st:string;
begin
	close(fbat);

	ActiveCanal(1);
	BorreCanal(1,0);
	PlotTOcurrencias(1, Bateria.Ciclado,'Ciclado','de 0 a CN*PM');
	(****
	if not Auto then
	begin
		while keypressed do c:= readkey;
		while not keypressed do;
		c:= readkey;
		if UpCase(c) = 'P' then
		begin
			assign(fout, 'lpt1');
			rewrite(fout);
		{
			HardCopy(fout);
			}
			close(fout);
		end;
	end;
	***)

//	TermineGr;

	assign(fout,'solar.sal');
	rewrite(fout);
	writeln(fout,'Capacidad de la bateria [Ah]:',CapacidadDeBateria:6:2);
	writeln(fout,'Maxima profundidad de descarga permitida [p.u]:',PPCB:6:2);
	writeln(fout,'Numero de paneles de 48W [u]:',NumeroDePanelesDe48W:6:2);
	writeln(fout,'Latitud []:',Latitud:6:2);
	writeln(fout,'Longitud []:',Longitud:6:2);
	writeln(fout,'Anos simulados [u]:', Escenario.PeriodosTotales-1:3);
	writeln(fout,'Profundidad de descarga x1 [p.u]:',bat_x1:6:2);
	writeln(fout,'Profundidad de descarga x2 [p.u]:',bat_x2:6:2);
	writeln(fout,'Ciclos a la profundidad de descarga x1 [u]:',bat_y1:6:2);
	writeln(fout,'Ciclos a la profundidad de descarga x2 [u]:',bat_y2:6:2);

	writeln(fout,'Deficit 10% : ',e1.histo.xArea(0.1)/Quantum:8:2,' [dias]');
	writeln(fout,'Deficit Valor Medio: ',e1.histo.ValorMedio/Quantum:8:2,' [dias]');
	writeln(fout,'Deficit 90% : ',e1.histo.xArea(0.9)/Quantum:8:2,' [dias]');
	writeln(fout,'Exceso 10% : ',e2.histo.xArea(0.1)/Quantum:8:2,' [dias]');
	writeln(fout,'Exceso Valor Medio: ',e2.histo.ValorMedio/Quantum:8:2,' [dias]');
	writeln(fout,'Exceso 90% : ',e2.histo.xArea(0.9)/Quantum:8:2,' [dias]');
	writeln(fout,'Degradacin anual de la bateria: ',
				bateria.DegradacionAnual: 5:4,' [p.u.]');
	writeln(fout,'Anos que dura la bateria [u]:',0.2/(bateria.DegradacionAnual):6:2);
	writeln(fout,'');
	writeln(fout,'Histograma de ciclado de la bateria [AH,peso]');
	bateria.Ciclado.ExportarQuattro(fout);
	close(fout);
end;

procedure Pesca; far;
begin
	DiasDeDeficitResultante := e1.GetValor/Quantum;
	if NumeroDePeriodo+1 < Escenario.PeriodosTotales then
	begin
		activeCanal(0);
		BorreCanal(0,0);
		borde;
		grid;
		linea0;
		desligue(0);
	end;

	e1.evaluar;
	e2.evaluar;

	Desligue(2);
	BorreCanal(2,0);
	borde;
	grid;

	Desligue(3);
	BorreCanal(3,0);
	borde;
	grid;

	ActiveCanal(3);

{ dibujar histograma de deficit }
	inc(contador);
	str(contador:6,Txt);
	PlotHistograma(2, e1.histo,'Deficit anual','[1 DiaDeDeficit/DIV]; anos:'+txt);
	PlotHistograma(3, e2.histo,'Exceso anual','[20 DiaDeExceso/DIV]; anos:'+txt);
end;




procedure Principal;
begin
	ImpFecha:= False;
	Proc_Arrancar:=AlInicio;
	Proc_Pescar:=Pesca;
	Proc_Finalizar:=Alfinal;
	try
		Simular;
	except
		 on E: Exception do
			writeln(E.Message, E.HelpContext);
	end;
	writeln('Fin....');
	readln;
end;

{ Inicializa la aplicacin, crea la FORM que tendr la pantalla
grfica y conecta el procedimiento "Principal" definido en el
cuerpo del programa para que sea arrancado por la aplicacin
luego de creada. }
begin
{$IFDEF WIN32DELPHI}
  Application.Initialize;
  Application.CreateForm(TForm1, Form1);
  Form1.procPrincipal:= Principal;
  Application.Run;
{$ELSE}
        Principal;
{$ENDIF}
end.


