unit Ocurrenx;
{
+NOMBRE: Ocurrenx.pas
+CREACION: 12.2.1992
+AUTOR: Ruben Chaer.
+REVISION: 8.3.1992
+AUTOR: rch.
+REGISTRO:
+TIPO: Unidad Pascal.
+PROPOSITO: Registrador de ocurrencias de una variable NReal.
+PROYECTO: ARTEF1. (RCh)
+DESCRIPCION:
}
interface

uses
	classes,	xMatDefs;

const
	c_sepQUATTRO: char =','; { Separador para ExportarQUATTRO }
	c_sepEXCEL: char =#9; { Separador para ExportarEXCEL }
	c_sepTXT: char =','; { Separador para ExportarTXT }



type
	t_cuenta = cardinal;
	p_cuenta = ^t_cuenta;
	p_La_Cuenta= ^T_La_Cuenta;
	T_LA_Cuenta = array[1..10000] of T_Cuenta;

	TOcurrencias = class
		mayores,	{llevar la cuenta de las ocurrencias
						mayores o iguales que sx2.}
		menores,	{cuenta de las ocurrencias menores que sx1}
		Total    {total de ocurrencias notificadas al objeto}
		:t_cuenta;

		x1,	{Origen del intervalo discretizado (sx1)}
		dx, 	{Ancho del intervalo (sx2-sx1) }
		ddx 	{Ancho de la discretizacin. ( dx /NPDiv )}
		:NReal;

		NPDiv: integer;
		v	{Vector con las cuentas en cada franja}
		:p_La_Cuenta;

		constructor  Create( sx1,sx2:NReal; NPDiv:integer);
		{ Inicializa el objeto. Debe cumplirse sx2 > sx1}

		procedure ExportarQUATTRO(var arch: text); virtual;
		procedure ExportarEXCEL(var arch: text); virtual;

		procedure Ocurrio(x:NReal);
		{ Notificacin de una ocurrencia. Con este procedimiento,
		le notificamos la ocurrencia de (x) al objeto. Segun donde
		caiga (x), se incrementaran los contadores }

		procedure Free;
		{ Libera la memoria pedida }

		function res_peso(k:integer):NReal;
		{ Devuelve la cuenta en v(k)/Total.
		k : 1..NPDiv
		v(1), conteiene la cantidad de ocurrencia de x en el
		intervalo sx1 <= x <sx1+ddx }

		procedure Print; virtual;

		function ValorMedio:NReal;

		procedure Maximo(
			var PesoMaximo:NReal;
			var PosicionDelMaximo: integer);

		constructor Load(var arch: TStream);
		procedure Store(var arch: TStream);
	end;


implementation



constructor TOcurrencias.Create(sx1,sx2:NReal; NPDiv:integer);
var
	pi:p_cuenta;
	k:integer;
begin
	x1:=sx1; dx:=sx2-sx1; ddx:=dx /NPDiv;

	Self.NPDiv:=NPDiv;

	getMem( v,NPDiv*SizeOf(t_cuenta));
	for k:= 1 to NPDiv do
	begin
		v^[k]:= 0;
	end;
	Total:=0;
	mayores:=0;
	menores:=0;
end;

constructor TOcurrencias.Load(var arch: TStream);
begin
	arch.read(mayores,sizeOf(mayores));
	arch.read(menores,sizeOf(menores));
	arch.read(Total,sizeOf(total));
	arch.read(x1,sizeOf(x1));
	arch.read(dx,sizeOf(dx));
	arch.read(ddx,sizeOf(ddx));
	arch.read( NPDiv, sizeOf(NPdiv ));
	getMem( v,NPDiv*SizeOf(t_cuenta));
	arch.read(v^[1], NPDiv*sizeOf( T_Cuenta ));
end;

procedure TOcurrencias.Store(var arch: TStream);
begin
	arch.write(mayores,sizeOf(mayores));
	arch.write(menores,sizeOf(menores));
	arch.write(Total,sizeOf(total));
	arch.write(x1,sizeOf(NReal));
	arch.write(dx,sizeOf(NReal));
	arch.write(ddx,sizeOf(NReal));
	arch.write( NPDiv, sizeOf(NPdiv ));
	getMem( v,NPDiv*SizeOf(t_cuenta));
	arch.write(v^[1], NPDiv*sizeOf( T_Cuenta ));
end;

procedure TOcurrencias.Print;
var
	k:integer;
	x: NReal;
begin
	writeln('TOcurrencias.print...............');
	writeln(' Mayores: ', mayores);
	writeln(' Menores: ', menores);
	writeln(' Total: ', total );
	writeln(' x1: ', x1);
	writeln(' dx: ', dx );
	writeln(' ddx: ',ddx);
	writeln(' NPDiv: ', NPDiv );
	writeln('-----');
	for k:= 1 to NPDiv do
	begin
		x:= x1+(k-0.5)*ddx;
		writeln(x:12:4, c_SepTXT, res_peso(k):10:6);
	end;
	writeln('.......');
end;

procedure TOcurrencias.ExportarQUATTRO(var arch: text);
var
	k: integer;
	x: NReal;
begin
	x:= x1-ddx/2;
	for k:=	0 to NPDiv+1 do
	begin
		writeln(arch, x:12:5,c_sepQUATTRO,res_peso(k):12:5);
		x:=x+ddx;
	end;
end;



procedure TOcurrencias.ExportarEXCEL(var arch: text);
var
	k: integer;
	x: NReal;
begin
	x:= x1-ddx/2;
	for k:=	0 to NPDiv+1 do
	begin
		writeln(arch, x:12:5,c_sepEXCEL,res_peso(k):12:5);
		x:=x+ddx;
	end;
end;


procedure TOcurrencias.Ocurrio(x:NReal);
var
	ti:p_cuenta;
begin
	inc(total);
	if x < x1 then inc(menores)
	else
	begin
		x:=x-x1;
		if x >= dx then
			inc(mayores)
		else
			inc(v^[trunc(x/ddx)+1]);
	end
end;

function TOcurrencias.res_peso(k:integer):NReal;
var
	temp:NReal;
begin
	if k=0 then res_peso:=menores/Total
	else
		if k= NPDIV+1 then res_peso:= mayores/Total
		else
		begin
			temp:=v^[k];
			res_peso:=temp/total;
		end;
end;

procedure TOcurrencias.Free;
begin
	FreeMem( v,NPDiv*SizeOf(t_cuenta));
	inherited Free;
end;


function TOcurrencias.ValorMedio:NReal;
var
	k:integer;
	m, x:NReal;
begin
	x:= (x1-ddx);
	m:=menores/total;
	for k:= 1 to NPDiv+1 do
	begin
		x:= x+ddx;
		m:=m+res_peso(k)*x;
	end;
	x:= x+ddx;
	m:= m+mayores/total;
	valorMedio:= m;
end;


procedure TOcurrencias.Maximo(
		var PesoMaximo:NReal;
		var PosicionDelMaximo: integer);
var
	k, j:integer;
	m:NReal;
begin
	if total > 0 then
	begin
		m:=menores; j:= 0;
		for k:= 1 to NPDiv do
			if v^[k] >m then
			begin
				m:= v^[k];
				j:=k;
			end;
		if mayores >m then m:= mayores;
		j:= NPDiv+1;
		PesoMaximo:= m/total;
		PosicionDelMaximo:= j
	end
	else
	begin
		PesoMaximo:=0;
		PosicionDelMaximo:= 0;
	end;
end;


end.