unit uSeresVivos;

interface

uses
	Ancestor;

type
	TSerVivo = class (TBase )

		{ Procedimientos latentes
		sobreescribir aquellos que tengan sentido.
		 }
		escn: TBase; // el escenario
		procedure CadaSegundo; virtual;
		procedure CadaMinuto;  virtual;
		procedure CadaHora;virtual;
		procedure CadaDia;virtual;
		procedure CadaSemana; virtual;
		procedure CadaMes;virtual;
		procedure CambioEstacion; virtual;
		procedure CadaAnio; virtual;
		procedure CambioHorario; virtual;

		constructor Create( escenario: TBase );

	end;


implementation
uses
	NucleoT, uescenario;



(***** Por defecto  el Actor se elimina de la lista de despacho de los
diferentes eventos. Con esto logramos que solamente quede anotado para
recibir los eventos que realmente maneje el actor aumentando as la
velocidad de la simulacin *****)
procedure TSerVivo.CadaSegundo;
begin
	TEscenario(escn).tictac.CadaSegundo.quitarActor( self );
end;

procedure TSerVivo.CadaMinuto;
begin
	TEscenario(escn).tictac.CadaMinuto.quitarActor(self);
end;

procedure TSerVivo.CadaHora;
begin
	TEscenario(escn).tictac.CadaHora.quitarActor(self);
end;

procedure TSerVivo.CadaDia;
begin
	TEscenario(escn).tictac.CadaDia.quitarActor(self);
end;


procedure TSerVivo.CadaSemana;
begin
	TEscenario(escn).tictac.CadaSemana.quitarActor(self);
end;

procedure TSerVivo.CadaMes;
begin
	TEscenario(escn).tictac.CadaMes.quitarActor( Self );
end;


procedure TSerVivo.CambioEstacion;
begin
	TEscenario(escn).tictac.CambioEstacion.quitarActor( Self );
end;

procedure TSerVivo.CadaAnio;
begin
	TEscenario(escn).tictac.CadaAnio.quitarActor( Self );
end;


procedure TSerVivo.CambioHorario;
begin
	TEscenario(escn).tictac.CambioHorario.quitarActor( Self );
end;


constructor TSerVivo.Create( escenario: TBase );
begin
	inherited Create;
	// lo agregamoa a todos los despachadores de eventos
	// automticamente ser eliminado de aquellos eventos que
	// el no maneje.
	escn:= escenario;

	TEscenario(escn).tictac.CadaSegundo.agregarActor( self );
	TEscenario(escn).tictac.CadaMinuto.agregarActor(self);
	TEscenario(escn).tictac.CadaHora.agregarActor(self);
	TEscenario(escn).tictac.CadaDia.agregarActor(self);
	TEscenario(escn).tictac.CadaSemana.agregarActor(self);
	TEscenario(escn).tictac.CadaMes.agregarActor( Self );
	TEscenario(escn).tictac.CambioEstacion.agregarActor( Self );
	TEscenario(escn).tictac.CadaAnio.agregarActor( Self );
	TEscenario(escn).tictac.CambioHorario.agregarActor( Self );

end;

end.
