unit uescenario;

interface
uses
	Ancestor, ulistas, nucleot;

type
	TEscenario= class( TBase )
		seres: TLista;
		tictac: TNucleoT;
		PasoDeTiempo: double;
		PeriodosTotales:integer;
		constructor Create;
		procedure Free;
		procedure FijarLatido( lat: T_Latido );
	end;

implementation





constructor TEscenario.Create;
begin
	inherited Create;
	seres:= TLista.Create;
	tictac:= TNucleoT.Create( 2004, Enero, 1, 0, 0, 0 );
	PasoDeTiempo:= -1;
	PeriodosTotales:= -1;

end;

procedure TEscenario.Free;
begin
	seres.Free;
	tictac.Free;
	inherited Free;
end;


procedure TEscenario.FijarLatido( lat: T_Latido );
begin
	tictac.Latido:= lat;
	case  lat of
		Lat_SinInicializar: PasoDeTiempo:= 0;
		Lat_Segundo: PasoDeTiempo:= 1;
		Lat_Minuto: PasoDeTiempo:= 60;
		Lat_Hora: PasoDeTiempo:= 60*60;
		Lat_Dia: PasoDeTiempo:= 60*60*24;
		Lat_Mes: PasoDeTiempo:= 60*60*365/12; //ojo ver que hacemos con las duraciones
		Lat_Anio: PasoDeTiempo:= 60*60*365; //ojo ver que hacemos con los bisiestos
	end;
end;

end.
