unit uEditarFichaGTer_OnOffPorPosteV2;

{$IFDEF FPC}
  {$MODE Delphi}
{$ENDIF}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, uBaseEditoresFichas,
  uGTer_OnOffPorPosteV2, uCosaConNombre, uFichasLPD, StdCtrls, Grids, utilidades, uFechas,
  ExtCtrls, uconstantesSimSEE, uBaseEditoresFichasGeneradores,
  usalasdejuego,
  uSalasDeJuegoParaEditor,
  xMatDefs, uverdoc, uOpcionesSimSEEEdit, uvisordetabla
  {$IFDEF COMBUSTIBLES}
  ,uCombustible
  {$ENDIF}
  ,uUtilFormulario
  ;

resourcestring
  rsPotenciaMinima = 'Potencia mínima[MW]';
  rsPotenciaMaxima = 'Potencia maxima[MW]';
  rsCoeficienteDisponibilidadFortuita = 'Coeficiente de disponibildad fortuita[p.u.]';
  rsTiempoDeReparacionH = 'Tiempo de reparación[horas]';

type

{ TEditarFichaGTer_OnOffPorPosteV2 }

TEditarFichaGTer_OnOffPorPosteV2 = class(TBaseEditoresFichasGeneradores)
    EFIni: TEdit;
    IntFicha: TStringGrid;
    LFIni: TLabel;
    BGuardar: TButton;
    BCancelarFicha: TButton;
    CBPeriodicidad: TCheckBox;
    PPeriodicidad: TPanel;
    LFinPeriodo: TLabel;
    LIniPeriodo: TLabel;
    LLargoPeriodo: TLabel;
    EFFinPeriodo: TEdit;
    EFIniPeriodo: TEdit;
    ScrollBox1: TScrollBox;
    sgPeriodicidad: TStringGrid;
    ELargoPeriodo: TEdit;
    CBLargoPeriodo: TComboBox;
    CBRestrEMax: TCheckBox;
    ERestrEMax: TEdit;
    BAyuda: TButton;
    LIndicePreciosPorCombustible: TLabel;
    LBornePreciosPorCombustible: TLabel;
    CBFuenteIndicePreciosPorCombustible: TComboBox;
    CBBorneIndicePreciosCombustible: TComboBox;
    procedure FormCreate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure EditEnter(Sender: TObject);
    procedure BCancelarClick(Sender: TObject);
    procedure sgGetEditText(Sender: TObject; ACol, ARow: Integer; var Value: String);
    procedure BGuardarClick(Sender: TObject); override;
    procedure CBPeriodicidadClick(Sender: TObject);
    procedure CBRestrEMaxClick(Sender: TObject);
    procedure BAyudaClick(Sender: TObject);
    procedure CBFuenteIndicePreciosPorCombustibleChange(Sender: TObject);
    procedure dump_Combustibles( var hayCambios, hayErrores : boolean  );

    protected
      function validarFormulario() : boolean; override;
    private
      Generador : TGTer_OnOffPorPosteV2;
      tblCombustibles : TTabla;
      disponibleCombustible : array[1..3] of boolean;
      rendimientoPN : array[1..3] of NReal;
      rendimientoMT : array[1..3] of NReal;
      combustible : array[1..3] of TCombustible;


      // llena al tabla a partir de los datos
      procedure populate_Combustibles;
    public
      Constructor Create(AOwner : TComponent; cosaConNombre : TCosaConNombre ; ficha: TFichaLPD; sala : TSalaDeJuego ); override;
    end;

var
  EditarFichaGTer_OnOffPorPosteV2: TEditarFichaGTer_OnOffPorPosteV2;

implementation

uses SimSEEEditMain, uBaseAltasEditores;

{$IFNDEF FPC}
  {$R *.dfm}
{$ELSE}
  {$R *.lfm}
{$ENDIF}

Constructor TEditarFichaGTer_OnOffPorPosteV2.Create(AOwner : TComponent; cosaConNombre : TCosaConNombre ; ficha : TFichaLPD; sala : TSalaDeJuego );
var
  fichaAux : TFichaGTer_OnOffPorPosteV2;
  i : Integer;
begin
  inherited Create(AOwner, cosaConNombre, ficha, sala);
  Generador := cosaConNombre as TGTer_OnOffPorPosteV2;
  guardado := true;
  inherited llenarCamposPeriodicidad(CBLargoPeriodo, ELargoPeriodo, EFIniPeriodo, EFFinPeriodo, sgPeriodicidad, CBPeriodicidad, ficha, PPeriodicidad);
  inherited inicializarCBFuente(CBFuenteIndicePreciosPorCombustible, CBBorneIndicePreciosCombustible, true);

  if (ficha <> NIL) then
  begin
    fichaAux := ficha as TFichaGTer_OnOffPorPosteV2;
    self.EFIni.Text := FSimSEEEdit.fechaIniToString(fichaAux.fecha);
    self.IntFicha.cells[1, 0] := FloatToStr(fichaAux.PMin);
    self.IntFicha.cells[1, 1] := FloatToStr(fichaAux.PMax);
    self.IntFicha.cells[1, 2] := FloatToStr(fichaAux.disp);
    self.IntFicha.cells[1, 3] := FloatToStr(fichaAux.tRepHoras);

    for i:= 1 to 3 do
    begin
      disponibleCombustible[i] := fichaAux.disponibleCombustible[i];
      rendimientoPN[i] := fichaAux.rendimientoPN[i];
      rendimientoMT[i] := fichaAux.rendimientoMT[i];
      combustible[i] := fichaAux.combustible[i];
    end;

    inherited initCBRestriccion(fichaAux.HayRestriccionEmaxPasoDeTiempo, CBRestrEMax,
                                fichaAux.EmaxPasoDeTiempo, ERestrEMax);
    inherited setCBFuente( CBFuenteIndicePreciosPorCombustible, CBBorneIndicePreciosCombustible,
                           fichaAux.indicePreciosPorCombustible, fichaAux.bornePreciosPorCombustible);
  end
  else
  begin
    self.EFIni.Text := '';
    for i := 0 to self.IntFicha.RowCount - 1 do
      self.IntFicha.cells[1, i] := '';
    inherited initCBRestriccion(false, CBRestrEMax, 0, ERestrEMax);

    for i:= 1 to 3 do
    begin
      disponibleCombustible[i] := False;
      rendimientoPN[i] := 0;
      rendimientoMT[i] := 0;
      combustible[i] := Nil;
    end;

  end;

  tblCombustibles := TTabla.Create(scrollBox1, 'tblCombustibles', 4, 0, 0);
  populate_Combustibles;
end;

procedure TEditarFichaGTer_OnOffPorPosteV2.populate_Combustibles;
var
  i: integer;
  ed: TEdit;
  cb: TComboBox;
begin

  tblCombustibles.ClearRedim(4, 4); //filas, columnas

  //Creo la fila de titulos
  tblCombustibles.wrTexto('', 0, 0, 'Combustible disponible:');
  tblCombustibles.wrTexto('', 1, 0, 'Rendimiento PN:');
  tblCombustibles.wrTexto('', 2, 0, 'Rendimiento MT:');
  tblCombustibles.wrTexto('', 3, 0, 'Combustible:');

  //tblCombustibles.SetBgColorFila( 0, clGray);
  //tblCombustibles.SetFontColorFila(0, clWhite );

  //Completo la tabla con los edits etc...
  for i := 1 to 3 do  //Para cada columna , la 0 tiene titulos
  begin
    tblCombustibles.wrCheckBox('chckbxDisponible_'+IntToStr(i),0,i, disponibleCombustible[i], 'Combustible '+IntToStr(i));
    tblCombustibles.wrEdit('edRendPN_'+IntToStr(i),1,i, FloatToStr(rendimientoPN[i]),6,'');
    tblCombustibles.wrEdit('edRendMT_'+IntToStr(i),2,i, FloatToStr(rendimientoMT[i]),6,'');
    tblCombustibles.wrComboBox('CBCombustible_'+IntToStr(i),3,i,165);

    cb := tblCombustibles.FindObj(3,i,'CBCombustible_'+IntToStr(i));
    inicializarCBCombustible(cb, True);

    setCBCombustible(cb, combustible[i]);
  end;

  tblCombustibles.reposicionar;
  tblCombustibles.Visible:= true;

end;

function TEditarFichaGTer_OnOffPorPosteV2.validarFormulario() : boolean;
var
  hayCambios, hayErrores: boolean;
begin
  try
    hayCambios:= false;
    hayErrores:= false;
    dump_Combustibles( hayCambios, hayErrores );

    inherited validarFormulario;
    result := not hayErrores and
              validarEditFecha(EFIni) and
              inherited validarPeriodicidad(CBPeriodicidad, CBLargoPeriodo, ELargoPeriodo, EFIniPeriodo, EFFinPeriodo, sgPeriodicidad) and
              inherited validarTablaNReals_(IntFicha) and
              inherited validarRestriccion(CBRestrEMax, ERestrEMax, 1, MaxNReal) and
              inherited validarCBFuente(CBFuenteIndicePreciosPorCombustible, CBBorneIndicePreciosCombustible);
  except
    result:= false;
  end;
end;

procedure TEditarFichaGTer_OnOffPorPosteV2.FormCreate(Sender: TObject);
begin
  utilidades.AgregarFormatoFecha(LFIni);

  self.IntFicha.cells[0, 0] := rsPotenciaMinima;
  self.IntFicha.cells[0, 1] := rsPotenciaMaxima;
  self.IntFicha.cells[0, 2] := rsCoeficienteDisponibilidadFortuita;
  self.IntFicha.cells[0, 3] := rsTiempoDeReparacionH;

  utilidades.AutoSizeCol(IntFicha, 0);
  utilidades.AutosizeTable(self, IntFicha, maxAnchoTablaEnorme, maxAlturaTablaMediana, TSimSEEEditOptions.getInstance.deshabilitarScrollHorizontalEnListados);
end;

procedure TEditarFichaGTer_OnOffPorPosteV2.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  inherited FormCloseQuery(Sender, CanClose);
end;

procedure TEditarFichaGTer_OnOffPorPosteV2.EditEnter(Sender: TObject);
begin
  inherited EditEnter(Sender);
end;

procedure TEditarFichaGTer_OnOffPorPosteV2.BCancelarClick(
  Sender: TObject);
begin
  inherited BCancelarClick(Sender);
end;

procedure TEditarFichaGTer_OnOffPorPosteV2.sgGetEditText(Sender: TObject;
  ACol, ARow: Integer; var Value: String);
begin
  inherited sgGetEditText(Sender, ACol, ARow, Value);
end;

procedure TEditarFichaGTer_OnOffPorPosteV2.BGuardarClick(
  Sender: TObject);
var
  periodicidad : TPeriodicidad;
  restrEmax: NReal;
begin
  if validarFormulario then
  begin
    if not CBPeriodicidad.Checked then
      periodicidad := NIL
    else
      periodicidad := inherited darPeriodicidad(CBLargoPeriodo, ELargoPeriodo, EFIniPeriodo, EFFinPeriodo, sgPeriodicidad);

    restrEMax:= inherited rest(CBRestrEMax, ERestrEMax, MaxNReal);

    ficha := TFichaGTer_OnOffPorPosteV2.Create( FSimSEEEdit.StringToFecha(EFIni.Text), periodicidad,
                                              StrToFloat(self.IntFicha.cells[1, 0]),
		                              StrToFloat(self.IntFicha.cells[1, 1]),
                                              valorCBFuente(CBFuenteIndicePreciosPorCombustible),
                                              valorCBString(CBBorneIndicePreciosCombustible),
                                              StrToFloat(self.IntFicha.cells[1, 2]),
                                              StrToFloat(self.IntFicha.Cells[1, 3]),
                                              CBRestrEMax.Checked, restrEmax,
                                              disponibleCombustible,
                                              rendimientoPN,
                                              rendimientoMT,
                                              combustible);
    ModalResult := mrOk;
  end
end;

procedure TEditarFichaGTer_OnOffPorPosteV2.CBPeriodicidadClick(
  Sender: TObject);
begin
  inherited switchPanelPeriodicidad(CBPeriodicidad, PPeriodicidad)
end;

procedure TEditarFichaGTer_OnOffPorPosteV2.CBFuenteIndicePreciosPorCombustibleChange(
  Sender: TObject);
begin
  inherited cbFuenteChange(CBFuenteIndicePreciosPorCombustible, CBBorneIndicePreciosCombustible);
end;

procedure TEditarFichaGTer_OnOffPorPosteV2.CBRestrEMaxClick(Sender: TObject);
begin
  inherited CBRestrClick(CBRestrEMax, ERestrEMax);
end;

procedure TEditarFichaGTer_OnOffPorPosteV2.BAyudaClick(Sender: TObject);
begin
  verdoc( TGTer_OnOffPorPosteV2)
end;

procedure TEditarFichaGTer_OnOffPorPosteV2.dump_Combustibles( var hayCambios, hayErrores : boolean  );
var
  i:   integer;
  cb: TComboBox;

begin
      if hayErrores then exit;
      if hayCambios then
        guardado := false;

      for i := 1 to 3 do  //Para cada columna , la 0 tiene titulos
      begin
        dump_boolean(tblCombustibles, disponibleCombustible[i], 'chckbxDisponible_'+IntToStr(i), 0, i, hayCambios, hayErrores );
        dump_float(tblCombustibles, rendimientoPN[i], 'edRendPN_'+IntToStr(i), 1, i, hayCambios, hayErrores );
        dump_float(tblCombustibles, rendimientoMT[i], 'edRendMT_'+IntToStr(i), 2, i, hayCambios, hayErrores );

        cb := tblCombustibles.FindObj(3,i,'CBCombustible_'+IntToStr(i));
        combustible[i] := valorCBCombustible(cb);
      end;
end;

end.
