unit uEditarFichaGTer_combinadoV2;
{$IFDEF FPC}
  {$MODE Delphi}
{$ENDIF}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, uBaseEditoresFichas,
  ugter_combinadoV2, uCosaConNombre, uFichasLPD, StdCtrls, Grids, utilidades, uFechas,
  ExtCtrls, uconstantesSimSEE, uBaseEditoresFichasGeneradores,
  usalasdejuego,
  uSalasDeJuegoParaEditor,
  xMatDefs, uverdoc, uFuentesAleatorias, uOpcionesSimSEEEdit
  {$IFDEF COMBUSTIBLES}
  ,uCombustible
  {$ENDIF}
  ,uUtilFormulario, uvisordetabla;

resourcestring
  rsPotenciaMinima = 'Potencia mínima[MW]';
  rsPotenciaMaxima = 'Potencia maxima[MW]';
  rsCoeficienteDisponibilidadFortuita = 'Coeficiente de disponibildad fortuita[p.u.]';
  rsTiempoDeReparacionH = 'Tiempo de reparación[horas]';

type

  { TEditarFichaGTer_combinadoV2 }

  TEditarFichaGTer_combinadoV2 = class(TBaseEditoresFichasGeneradores)
    EPotTVdivTG: TEdit;
    EFIni: TEdit;
    IntFichaTV: TStringGrid;
    IntFichaTG: TStringGrid;
    IntFichaCC: TStringGrid;
    LTGdivTG: TLabel;
    LFactorPotenciaCC: TLabel;
    LabelCC: TLabel;
    LabelTV: TLabel;
    LabelTG: TLabel;
    LFIni: TLabel;
    BGuardar: TButton;
    BCancelarFicha: TButton;
    CBPeriodicidad: TCheckBox;
    PPeriodicidad: TPanel;
    LFinPeriodo: TLabel;
    LIniPeriodo: TLabel;
    LLargoPeriodo: TLabel;
    EFFinPeriodo: TEdit;
    EFIniPeriodo: TEdit;
    ScrollBox1: TScrollBox;
    sgPeriodicidad: TStringGrid;
    ELargoPeriodo: TEdit;
    CBLargoPeriodo: TComboBox;
    CBRestrEMax: TCheckBox;
    ERestrEMax: TEdit;
    BAyuda: TButton;
    LIndicePreciosPorCombustible: TLabel;
    LBornePreciosPorCombustible: TLabel;
    CBFuenteIndicePreciosPorCombustible: TComboBox;
    CBBorneIndicePreciosCombustible: TComboBox;
    procedure FormCreate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: boolean);
    procedure EditEnter(Sender: TObject);
    procedure BCancelarClick(Sender: TObject);
    procedure sgChequearCambios(Sender: TObject);
    procedure sgGetEditText(Sender: TObject; ACol, ARow: integer;
      var Value: string);
    procedure BGuardarClick(Sender: TObject); override;
    procedure CBPeriodicidadClick(Sender: TObject);
    procedure CBRestrEMaxClick(Sender: TObject);
    procedure BAyudaClick(Sender: TObject);
    procedure CBFuenteIndicePreciosPorCombustibleChange(Sender: TObject);
    procedure dump_Combustibles( var hayCambios, hayErrores : boolean  );
  protected
    function validarFormulario(): boolean; override;
  private
    Generador: TGTer_combinadoV2;
    tblCombustibles : TTabla;
    disponibleCombustible : array[1..3] of boolean;
    rendimientoPN : array[1..3] of NReal;
    rendimientoMT : array[1..3] of NReal;
    combustible : array[1..3] of TCombustible;

    // llena al tabla a partir de los datos
    procedure populate_Combustibles;

  public
    constructor Create(AOwner: TComponent; cosaConNombre: TCosaConNombre;
      ficha: TFichaLPD; sala: TSalaDeJuego); override;
  end;

var
  EditarFichaGTer_combinado: TEditarFichaGTer_combinadoV2;

implementation

uses SimSEEEditMain, uBaseAltasEditores;

{$IFNDEF FPC}
  {$R *.dfm}
{$ELSE}
  {$R *.lfm}
{$ENDIF}

constructor TEditarFichaGTer_combinadoV2.Create(AOwner: TComponent;
  cosaConNombre: TCosaConNombre; ficha: TFichaLPD; sala: TSalaDeJuego);
var
  fichaAux: TFichaGTer_combinadoV2;
  i: integer;
begin
  inherited Create(AOwner, cosaConNombre, ficha, sala);
  Generador := cosaConNombre as TGTer_combinadoV2;
  guardado := True;
  inherited llenarCamposPeriodicidad(CBLargoPeriodo, ELargoPeriodo,
    EFIniPeriodo, EFFinPeriodo, sgPeriodicidad, CBPeriodicidad, ficha, PPeriodicidad);
  inherited inicializarCBFuente(CBFuenteIndicePreciosPorCombustible,
    CBBorneIndicePreciosCombustible, True);

  if (ficha <> nil) then
  begin
    fichaAux := ficha as TFichaGTer_combinadoV2;
    self.EFIni.Text := FSimSEEEdit.fechaIniToString(fichaAux.fecha);

    //Cargo la tabla de TG con los valores de la ficha
    self.IntFichaTG.cells[1, 0] := FloatToStr(fichaAux.PMin_TG);
    self.IntFichaTG.cells[1, 1] := FloatToStr(fichaAux.PMax_TG);
    self.IntFichaTG.cells[1, 2] := FloatToStr(fichaAux.disp_TG);
    self.IntFichaTG.cells[1, 3] := FloatToStr(fichaAux.tRepHoras_TG);

    //Cargo la tabla de TV con los valores de la ficha
    self.IntFichaTV.cells[1, 0] := FloatToStr(fichaAux.disp_TV);
    self.IntFichaTV.cells[1, 1] := FloatToStr(fichaAux.tRepHoras_TV);

    //Cargo la tabla de CC con los valores de la ficha
    self.IntFichaCC.cells[1, 0] := FloatToStr(fichaAux.PMin_CC);
    self.IntFichaCC.cells[1, 1] := FloatToStr(fichaAux.PMax_CC);

    EPotTVdivTG.Text:= FloatToStr(fichaAux.factorPotenciaTVdivTG);

    for i:= 1 to 3 do
    begin
      disponibleCombustible[i] := fichaAux.disponibleCombustible[i];
      rendimientoPN[i] := fichaAux.rendimientoPN[i];
      rendimientoMT[i] := fichaAux.rendimientoMT[i];
      combustible[i] := fichaAux.combustible[i];
    end;

    inherited initCBRestriccion(fichaAux.HayRestriccionEmaxPasoDeTiempo, CBRestrEMax,
      fichaAux.EmaxPasoDeTiempo, ERestrEMax);
    inherited setCBFuente(CBFuenteIndicePreciosPorCombustible,
      CBBorneIndicePreciosCombustible, fichaAux.indicePreciosPorCombustible,
      fichaAux.bornePreciosPorCombustible);
  end
  else
  begin
    self.EFIni.Text := '';
    for i := 0 to self.IntFichaTG.RowCount - 1 do
      self.IntFichaTG.cells[1, i] := '';
    for i := 0 to self.IntFichaCC.RowCount - 1 do
      self.IntFichaCC.cells[1, i] := '';

    for i:= 1 to 3 do
    begin
      disponibleCombustible[i] := False;
      rendimientoPN[i] := 0;
      rendimientoMT[i] := 0;
      combustible[i] := Nil;
    end;

    inherited initCBRestriccion(False, CBRestrEMax, 0, ERestrEMax);
  end;

  tblCombustibles := TTabla.Create(scrollBox1, 'tblCombustibles', 4, 0, 0);
  populate_Combustibles;
end;


procedure TEditarFichaGTer_combinadoV2.populate_Combustibles;
var
  i: integer;
  ed: TEdit;
  cb: TComboBox;
begin

  tblCombustibles.ClearRedim(4, 4); //filas, columnas

  //Creo la fila de titulos
  tblCombustibles.wrTexto('', 0, 0, 'Combustible disponible:');
  tblCombustibles.wrTexto('', 1, 0, 'Consumo esp. PN:');
  tblCombustibles.wrTexto('', 2, 0, 'Consumo esp. MT:');
  tblCombustibles.wrTexto('', 3, 0, 'Combustible:');

  //tblCombustibles.SetBgColorFila( 0, clGray);
  //tblCombustibles.SetFontColorFila(0, clWhite );

  //Completo la tabla con los edits etc...
  for i := 1 to 3 do  //Para cada columna , la 0 tiene titulos
  begin
    tblCombustibles.wrCheckBox('chckbxDisponible_'+IntToStr(i),0,i, disponibleCombustible[i], 'Combustible '+IntToStr(i));
    tblCombustibles.wrEdit('edRendPN_'+IntToStr(i),1,i, FloatToStr(rendimientoPN[i]),6,'');
    tblCombustibles.wrEdit('edRendMT_'+IntToStr(i),2,i, FloatToStr(rendimientoMT[i]),6,'');
    tblCombustibles.wrComboBox('CBCombustible_'+IntToStr(i),3,i,165);

    cb := tblCombustibles.FindObj(3,i,'CBCombustible_'+IntToStr(i));
    inicializarCBCombustible(cb, True);
    setCBCombustible(cb, combustible[i]);
  end;

  tblCombustibles.reposicionar;
  tblCombustibles.Visible:= true;
end;


function TEditarFichaGTer_combinadoV2.validarFormulario(): boolean;
var
  hayCambios, hayErrores: boolean;
begin
  try
    hayCambios:= false;
    hayErrores:= false;
    dump_Combustibles( hayCambios, hayErrores );

    inherited validarFormulario;
    Result := not hayErrores and
              validarEditFecha(EFIni) and inherited validarPeriodicidad(
              CBPeriodicidad, CBLargoPeriodo, ELargoPeriodo, EFIniPeriodo, EFFinPeriodo,
              sgPeriodicidad) and inherited validarTablaNReals_(IntFichaTG) and
              inherited validarTablaNReals_(IntFichaCC) and
              inherited validarRestriccion(CBRestrEMax, ERestrEMax, 1, MaxNReal) and
              inherited validarCBFuente(CBFuenteIndicePreciosPorCombustible,
              CBBorneIndicePreciosCombustible) and
              validarEditFloat(EPotTVdivTG, 0, 100000);

  except
    result:= false;
  end;
end;

procedure TEditarFichaGTer_combinadoV2.FormCreate(Sender: TObject);
begin
  utilidades.AgregarFormatoFecha(LFIni);

  //Inicializo etiquetas de las grillas
  self.IntFichaTG.cells[0, 0] := rsPotenciaMinima;
  self.IntFichaTG.cells[0, 1] := rsPotenciaMaxima;
  self.IntFichaTG.cells[0, 2] := rsCoeficienteDisponibilidadFortuita;
  self.IntFichaTG.cells[0, 3] := rsTiempoDeReparacionH;

  self.IntFichaTV.cells[0, 0] := rsCoeficienteDisponibilidadFortuita;
  self.IntFichaTV.cells[0, 1] := rsTiempoDeReparacionH;

  self.IntFichaCC.cells[0, 0] := rsPotenciaMinima;
  self.IntFichaCC.cells[0, 1] := rsPotenciaMaxima;

  utilidades.AutoSizeCol(IntFichaTG, 0);
  utilidades.AutosizeTable(self, IntFichaTG, maxAnchoTablaEnorme,
    maxAlturaTablaMediana, TSimSEEEditOptions.getInstance.
    deshabilitarScrollHorizontalEnListados);

  utilidades.AutoSizeCol(IntFichaTV, 0);
  utilidades.AutosizeTable(self, IntFichaTV, maxAnchoTablaEnorme,
    maxAlturaTablaMediana, TSimSEEEditOptions.getInstance.
    deshabilitarScrollHorizontalEnListados);

  utilidades.AutoSizeCol(IntFichaCC, 0);
  utilidades.AutosizeTable(self, IntFichaCC, maxAnchoTablaEnorme,
    maxAlturaTablaMediana, TSimSEEEditOptions.getInstance.
    deshabilitarScrollHorizontalEnListados);
end;

procedure TEditarFichaGTer_combinadoV2.FormCloseQuery(Sender: TObject;
  var CanClose: boolean);
begin
  inherited FormCloseQuery(Sender, CanClose);
end;

procedure TEditarFichaGTer_combinadoV2.EditEnter(Sender: TObject);
begin
  inherited EditEnter(Sender);
end;

procedure TEditarFichaGTer_combinadoV2.BCancelarClick(Sender: TObject);
begin
  inherited BCancelarClick(Sender);
end;

procedure TEditarFichaGTer_combinadoV2.sgChequearCambios(Sender: TObject);
begin

end;

procedure TEditarFichaGTer_combinadoV2.sgGetEditText(Sender: TObject;
  ACol, ARow: integer; var Value: string);
begin
  inherited sgGetEditText(Sender, ACol, ARow, Value);
end;

procedure TEditarFichaGTer_combinadoV2.BGuardarClick(Sender: TObject);
var
  periodicidad: TPeriodicidad;
  restrEmax: NReal;
begin
  if validarFormulario then
  begin
    if not CBPeriodicidad.Checked then
      periodicidad := nil
    else
      periodicidad := inherited darPeriodicidad(CBLargoPeriodo,
        ELargoPeriodo, EFIniPeriodo, EFFinPeriodo, sgPeriodicidad);

    restrEMax := inherited rest(CBRestrEMax, ERestrEMax, MaxNReal);

    ficha := TFichaGTer_combinadoV2.Create(
      FSimSEEEdit.StringToFecha(EFIni.Text), periodicidad,

      //Valores de TG
      StrToFloat(self.IntFichaTG.cells[1, 0]),
      StrToFloat(self.IntFichaTG.cells[1, 1]),
      StrToFloat(self.IntFichaTG.cells[1, 2]),
      StrToFloat(self.IntFichaTG.Cells[1, 3]),

      //Valores de TV
      StrToFloat(self.IntFichaTV.cells[1, 0]),
      StrToFloat(self.IntFichaTV.Cells[1, 1]),

      //Valores de CC
      StrToFloat(self.IntFichaCC.cells[1, 0]),
      StrToFloat(self.IntFichaCC.cells[1, 1]),

      StrToFloat(EPotTVdivTG.Text),
      valorCBFuente(CBFuenteIndicePreciosPorCombustible), valorCBString(
      CBBorneIndicePreciosCombustible),
      CBRestrEMax.Checked, restrEmax,
      disponibleCombustible,
      rendimientoPN,
      rendimientoMT,
      combustible);
    ModalResult := mrOk;
  end;
end;

procedure TEditarFichaGTer_combinadoV2.CBPeriodicidadClick(Sender: TObject);
begin
  inherited switchPanelPeriodicidad(CBPeriodicidad, PPeriodicidad);
end;

procedure TEditarFichaGTer_combinadoV2.CBFuenteIndicePreciosPorCombustibleChange(
  Sender: TObject);
begin
  inherited cbFuenteChange(CBFuenteIndicePreciosPorCombustible,
    CBBorneIndicePreciosCombustible);
end;

procedure TEditarFichaGTer_combinadoV2.CBRestrEMaxClick(Sender: TObject);
begin
  inherited CBRestrClick(CBRestrEMax, ERestrEMax);
end;

procedure TEditarFichaGTer_combinadoV2.BAyudaClick(Sender: TObject);
begin
  verdoc( TGTer_combinadoV2);
end;

procedure TEditarFichaGTer_combinadoV2.dump_Combustibles( var hayCambios, hayErrores : boolean  );
var
  i:   integer;
  cb: TComboBox;

begin
      if hayErrores then exit;
      if hayCambios then
        guardado := false;

      for i := 1 to 3 do  //Para cada columna , la 0 tiene titulos
      begin
        dump_boolean(tblCombustibles, disponibleCombustible[i], 'chckbxDisponible_'+IntToStr(i), 0, i, hayCambios, hayErrores );
        dump_float(tblCombustibles, rendimientoPN[i], 'edRendPN_'+IntToStr(i), 1, i, hayCambios, hayErrores );
        dump_float(tblCombustibles, rendimientoMT[i], 'edRendMT_'+IntToStr(i), 2, i, hayCambios, hayErrores );

        cb := tblCombustibles.FindObj(3,i,'CBCombustible_'+IntToStr(i));
        combustible[i] := valorCBCombustible(cb);
      end;
end;

end.

