//====Modificado metodos: CreateDataColumnList y CreateDataConversionList===
//====Micho@29/5==mvarela@adme.com.uy=======================================
unit ugter_onoffporpasoV2;

{$IFDEF FPC}
  {$MODE Delphi}
{$ENDIF}

interface

uses
  SysUtils, Classes, xmatdefs, uGTer, unodos,
  uglobs,
  umipsimplex,
  usimplex,
  ufichasLPD,
  ufechas,
  uConversions,
  ucosa,
  {$IFDEF COMBUSTIBLES}
  uCombustible,
  {$ENDIF}
  uconstantesSimSEE, uFuentesAleatorias, Math;

resourcestring
  rsGeneradorTermicoEncyApXPasoTiempoV2 =
    'Generador térmico con encendido y apagado por paso de tiempo V2';

type

  { TFichaGTer_OnOffPorPasoV2 }

  TFichaGTer_OnOffPorPasoV2 = class(TFichaLPD)
  protected
    













  public
     
    PMin, PMax: NReal; // [MW] Potencias Mínima y Máxima Por maquina
    indicePreciosPorCombustible: TFuenteAleatoria;
    bornePreciosPorCombustible: string;
    disp: NReal; // disponibilidad (fortuita)
    tRepHoras: NReal;
    HayRestriccionEmaxPasoDeTiempo: boolean; // indica si se aplica la restricción
    EmaxPasoDeTiempo: NReal; // Energía maxima generable en un paso de tiempo
    disponibleCombustible: array[1..3] of boolean;
    rendimientoPN:         array[1..3] of NReal;
    rendimientoMT:         array[1..3] of NReal;
    combustible:           array[1..3] of TCombustible;
    

    nroBornePreciosPorCombustible: integer;

    constructor Create(fecha: TFecha; periodicidad: TPeriodicidad;
      PMin, PMax: NReal;
      indicePreciosPorCombustible: TFuenteAleatoria;
      bornePreciosPorCombustible: string;
      disp: NReal; tRepHoras: NReal;
      HayRestriccionEmaxPasoDeTiempo: boolean;
      EmaxPasoDeTiempo: NReal;
      disponibleCombustible: array of boolean;
      rendimientoPN: array of NReal;
      rendimientoMT: array of NReal;
      combustible: array of TCombustible); overload;

    constructor Create(fecha: TFecha; periodicidad: TPeriodicidad;
      PMin, PMax: NReal;
      indicePreciosPorCombustible: TFuenteAleatoria;
      bornePreciosPorCombustible: string;
      disp: NReal; tRepHoras: NReal;
      HayRestriccionEmaxPasoDeTiempo: boolean;
      EmaxPasoDeTiempo: NReal); overload;

    constructor Create_ReadFromText(f: TArchiTexto); override;
    procedure WriteToText(f: TArchiTexto); override;
    procedure generarLineaResumen(var archi: TextFile); override;
    function infoAd_: string; override;
    procedure Free; override;
    class function CreateDataColumnList(xClaseDeCosa:TClaseDeCosa; xVersion: Integer=-2): TDataColumnListOfCosa; override;
    class function CreateDataConversionList: TListDataConversion; override;

  published
    














  end;

  //TGTer_OnOffPorPaso es una potencia minima y maxima constante en todos los postes
  //y un costo variable cv [USD/MWh] tambien igual en todos los postes
  //y un costo variable cv_min "hasta el minimo" igual al costo de produccion en USD/MWh cuando
  //la central esta generado en el minimo.

  { TGTer_OnOffPorPasoV2 }

  TGTer_OnOffPorPasoV2 = class(TGTer)
  public
    pa: TFichaGTer_OnOffPorPasoV2;

    NMaquinasDespachadas: integer;
    // cantidad de máquinas despachadas ( variable de Acople )
    costosPorPoste: TDAofNReal;

    c0: NReal;//Costo en USD/h por máquina por estar operando en el mínimo técnico
    cv: NReal; //USD/MWh usado para la optimización del paso.
    cvPN: array[1..3] of NReal;
    cvMT: array[1..3] of NReal;

    PMin: NReal; //MW, mínimo
    PxMax: NReal; // MW, cota sup de P-Pmin

    // resultado de los sorteos de disponibilidad y del mantenimiento programado
    NMaquinasDisponibles: integer;
    PMaxDisponible: NReal;

    //Cuanta potencia despacho en cada hora el generador en promedio
    potMedia_despachada: NReal;

    constructor Create(nombre: string; nacimiento, muerte: TFecha;
      lpdUnidades, lpd: TFichasLPD; nodo: TNodo); override;

    constructor Create_ReadFromText(f: TArchiTexto); override;
    procedure WriteToText(f: TArchiTexto); override;
    procedure PrepararMemoria(globs: TGlobs); override;
    procedure RegistrarParametrosDinamicos; override;

    function PotenciaFirme: NReal; override;
    function InfoAd_: string; override;
    class function DescClase: string; override;

    procedure SorteosDelPaso(sortear: boolean); override;
    procedure PrepararPaso_ps; override;
    procedure Sim_Paso_Fin; override;

    procedure opt_nvers(var ivar, ivae, ires: integer); override;
    procedure opt_cargue(s: TSimplex); override;
    procedure opt_fijarRestriccionesDeCaja(s: TSimplex); override;
    procedure opt_leerSolucion(s: TSimplex); override;
{$IFDEF SPXCONLOG}
    procedure spx_NombrarVariables(s: TSimplex); override;
{$ENDIF}
    function getNombreVar(ivar: integer; var nombre: string): boolean; override;
    function getNombreRes(ires: integer; var nombre: string): boolean; override;

    procedure Free; override;

    procedure PubliVars; override;
    procedure dump_Variables(var f: TextFile; charIndentacion: char); override;

    class function TipoFichaLPD: TClaseDeFichaLPD; override;
    class function CreateDataColumnList(xClaseDeCosa:TClaseDeCosa; xVersion: Integer=-2): TDataColumnListOfCosa; override;
    procedure AfterInstantiation; override;
  end;

procedure AlInicio;
procedure AlFinal;

implementation

//-----------------------------------
// Métodos de TFichaGTer_OnOffPorPaso
//===================================
constructor TFichaGTer_OnOffPorPasoV2.Create(fecha: TFecha;
  periodicidad: TPeriodicidad;
  PMin, PMax: NReal;
  indicePreciosPorCombustible:
  TFuenteAleatoria;
  bornePreciosPorCombustible: string;
  disp: NReal;
  tRepHoras: NReal;
  HayRestriccionEmaxPasoDeTiempo: boolean;
  EmaxPasoDeTiempo: NReal;
  disponibleCombustible: array of boolean;
  rendimientoPN: array of NReal;
  rendimientoMT: array of NReal;
  combustible: array of TCombustible);
begin
  inherited Create(fecha, periodicidad);
  self.PMin := PMin;
  self.PMax := PMax;
  self.indicePreciosPorCombustible := indicePreciosPorCombustible;
  self.bornePreciosPorCombustible := bornePreciosPorCombustible;
  self.disp := disp;
  self.tRepHoras := tRepHoras;
  self.HayRestriccionEmaxPasoDeTiempo := HayRestriccionEmaxPasoDeTiempo;
  self.EmaxPasoDeTiempo := EmaxPasoDeTiempo;
  self.disponibleCombustible := disponibleCombustible;
  self.rendimientoPN := rendimientoPN;
  self.rendimientoMT := rendimientoMT;
  self.combustible := combustible;
end;

constructor TFichaGTer_OnOffPorPasoV2.Create(fecha: TFecha;
  periodicidad: TPeriodicidad;
  PMin, PMax: NReal;
  indicePreciosPorCombustible:
  TFuenteAleatoria;
  bornePreciosPorCombustible: string;
  disp: NReal;
  tRepHoras: NReal;
  HayRestriccionEmaxPasoDeTiempo: boolean;
  EmaxPasoDeTiempo: NReal);
begin
  inherited Create(fecha, periodicidad);
  self.PMin := PMin;
  self.PMax := PMax;
  self.indicePreciosPorCombustible := indicePreciosPorCombustible;
  self.bornePreciosPorCombustible := bornePreciosPorCombustible;
  self.disp := disp;
  self.tRepHoras := tRepHoras;
  self.HayRestriccionEmaxPasoDeTiempo := HayRestriccionEmaxPasoDeTiempo;
  self.EmaxPasoDeTiempo := EmaxPasoDeTiempo;
end;

constructor TFichaGTer_OnOffPorPasoV2.Create_ReadFromText(f: TArchiTexto);
var
  i: integer;
begin
  inherited Create_ReadFromText(f);
  f.IniciarLecturaRetrasada;
  f.rd('PMin', PMin);
  f.rd('PMax', PMax);
  f.rdReferencia('indicePreciosPorCombustible',
    TCosa(indicePreciosPorCombustible), Self);
  f.rd('bornePreciosPorCombustible', bornePreciosPorCombustible);
  f.rd('disp', disp);
  f.rd('tRepHoras', tRepHoras);
  f.rd('HayRestriccionEmaxPasoDeTiempo', HayRestriccionEmaxPasoDeTiempo);
  f.rd('EmaxPasoDeTiempo', EmaxPasoDeTiempo);

  for i := 1 to 3 do
  begin
    f.rd('disponibleCombustible' + IntToStr(i), disponibleCombustible[i]);
    f.rd('rendimientoPN' + IntToStr(i), rendimientoPN[i]);
    f.rd('rendimientoMT' + IntToStr(i), rendimientoMT[i]);
    f.rdReferencia('combustible' + IntToStr(i), TCosa(combustible[i]), Self);
  end;

  f.EjecutarLectura;
end;

procedure TFichaGTer_OnOffPorPasoV2.WriteToText(f: TArchiTexto);
var
  i: integer;
begin
  inherited WriteToText(f);
  f.wr('PMin', PMin, uconstantesSimSEE.CF_PRECISION, uconstantesSimSEE.CF_DECIMALES);
  f.wr('PMax', PMax, uconstantesSimSEE.CF_PRECISION, uconstantesSimSEE.CF_DECIMALES);
  f.wrReferencia('indicePreciosPorCombustible', indicePreciosPorCombustible);
  f.wr('bornePreciosPorCombustible', bornePreciosPorCombustible);
  f.wr('disp', disp, uconstantesSimSEE.CF_PRECISION, uconstantesSimSEE.CF_DECIMALESPU);
  f.wr('tRepHoras', tRepHoras, uconstantesSimSEE.CF_PRECISION,
    uconstantesSimSEE.CF_DECIMALES);
  f.wr('HayRestriccionEmaxPasoDeTiempo', HayRestriccionEmaxPasoDeTiempo);
  f.wr('EmaxPasoDeTiempo', EmaxPasoDeTiempo);

  for i := 1 to 3 do
  begin
    f.wr('disponibleCombustible' + IntToStr(i), disponibleCombustible[i]);
    f.wr('rendimientoPN' + IntToStr(i), rendimientoPN[i]);
    f.wr('rendimientoMT' + IntToStr(i), rendimientoMT[i]);
    f.wrReferencia('combustible' + IntToStr(i), combustible[i]);
  end;
end;

procedure TFichaGTer_OnOffPorPasoV2.generarLineaResumen(var archi: TextFile);
begin
  Write(archi, FloatToStrF(PMin, formatoReales, 8, 1), #9,
    //PMín
    FloatToStrF(PMax, formatoReales, 8, 1), #9,
    //PMáx
    //FloatToStrF(cv_min, formatoReales, 8, 2), #9,                                           //CV_Mín
    //FloatToStrF(((cv_min * PMin + cv * (PMax - PMin)) / PMax), formatoReales, 8, 2), #9,    //CV_Medio
    //FloatToStrF(cv, formatoReales, 8, 2), #9,                                               //CV_Incremental
    FloatToStrF(disp, formatoReales, 8, 2), #9,
    //FDisp
    '-', #9,
    //Costo Arranque
    '-', #9,
    //Costo Parada
    '-', #9,
    //mínNPasosOn
    '-', #9,
    //mínNPasosOff
    '-', #9,
    //desiciónPasosOnPorCiclo
    '-', #9,
    //desiciónPasosOffPorCiclo
    '-', #9,
    //costoPorCicloOn
    '-', #9);
  //costoPorCicloOff
end;

function TFichaGTer_OnOffPorPasoV2.infoAd_: string;
begin
  Result := 'PMín= ' + FloatToStrF(PMin, ffGeneral, 10, 1) + ' MW, ' +
    'PMáx= ' + FloatToStrF(PMax, ffGeneral, 10, 1) + ' MW, ' +
    'fDisp= ' + FloatToStrF(disp, ffGeneral, 10, 2) + ' p.u., ' +
    'tRep= ' + FloatToStrF(tRepHoras, ffGeneral, 10, 1) + 'h';
end;

procedure TFichaGTer_OnOffPorPasoV2.Free;
begin
  inherited Free;
end;

class function TFichaGTer_OnOffPorPasoV2.CreateDataColumnList(
  xClaseDeCosa: TClaseDeCosa; xVersion: Integer): TDataColumnListOfCosa;
begin
  































end;

class function TFichaGTer_OnOffPorPasoV2.CreateDataConversionList: TListDataConversion;
begin
  Result:=inherited CreateDataConversionList;
  Result.Add(uConversions.VERSION_MIGRACION_PERSISTENCIA,
    ['disponibleCombustible1', 'disponibleCombustible2' , 'disponibleCombustible3'],
    ['disponibleCombustible'], Result.ConversionPrimitivesToOneDynArray());

  Result.Add(uConversions.VERSION_MIGRACION_PERSISTENCIA,
    ['rendimientoPN1', 'rendimientoPN2' , 'rendimientoPN3'],
    ['rendimientoPN'], Result.ConversionPrimitivesToOneDynArray());

  Result.Add(uConversions.VERSION_MIGRACION_PERSISTENCIA,
    ['rendimientoMT1', 'rendimientoMT2' , 'rendimientoMT3'],
    ['rendimientoMT'], Result.ConversionPrimitivesToOneDynArray());

  Result.Add(uConversions.VERSION_MIGRACION_PERSISTENCIA,
    ['combustible1', 'combustible2' , 'combustible3'],
    ['combustible'], Result.ConversionPrimitivesToOneDynArray());
end;

//------------------------------
// Métodos de TGTer_OnOffPorPaso
//==============================
procedure TGTer_OnOffPorPasoV2.dump_Variables(var f: TextFile; charIndentacion: char);
begin
  inherited dump_Variables(f, charIndentacion);
  writeln(f, charIndentacion, 'c0[USD/MWh]= ', FloatToStrF(c0, ffFixed, 10, 3));
  writeln(f, charIndentacion, 'cv[USD/MWh]= ', FloatToStrF(cv, ffFixed, 10, 3));

  writeln(f, charIndentacion, 'PMin[MW]= ', FloatToStrF(PMin, ffFixed, 10, 3));
  writeln(f, charIndentacion, 'PMAx[MW]= ', FloatToStrF(pa.PMax, ffFixed, 10, 3));
  writeln(f, charIndentacion, 'PxMax[MW]= ', FloatToStrF(PxMax, ffFixed, 10, 3));
  writeln(f, charIndentacion, 'PMaxDisponible[MW]= ',
    FloatToStrF(PMaxDisponible, ffFixed, 10, 3));

  writeln(f, charIndentacion, 'NMaquinasDisponibles= ', NMaquinasDisponibles);

  writeln(f, charIndentacion, 'HayRestrEMaxPasoDeTiempo= ',
    pa.hayRestriccionEmaxPasoDeTiempo);
  writeln(f, charIndentacion, 'EMaxPasoDeTiempo[MW/h]= ',
    FloatToStrF(pa.EmaxPasoDeTiempo, ffFixed, 10, 3));

  writeln(f);
end;

class function TGTer_OnOffPorPasoV2.TipoFichaLPD: TClaseDeFichaLPD;
begin
  Result := TFichaGTer_OnOffPorPasoV2;
end;

class function TGTer_OnOffPorPasoV2.CreateDataColumnList(
  xClaseDeCosa: TClaseDeCosa; xVersion: Integer): TDataColumnListOfCosa;
begin
  


end;

procedure TGTer_OnOffPorPasoV2.AfterInstantiation;
begin
  inherited AfterInstantiation;
  pa := nil;
  nodo := nil;
end;

constructor TGTer_OnOffPorPasoV2.Create(nombre: string;
  nacimiento, muerte: TFecha; lpdUnidades, lpd: TFichasLPD; nodo: TNodo);
begin
  inherited Create(nombre, nacimiento, muerte, lpdUnidades, lpd, nodo);
end;

constructor TGTer_OnOffPorPasoV2.Create_ReadFromText(f: TArchiTexto);
begin
  inherited Create_ReadFromText(f);
  pa := nil;
  nodo := nil;
end;

procedure TGTer_OnOffPorPasoV2.PrepararMemoria(globs: TGlobs);
begin
  inherited prepararMemoria(globs);
  setlength(costosPorPoste, globs.NPostes);
  NMaquinasDespachadas := 0;
end;

procedure TGTer_OnOffPorPasoV2.RegistrarParametrosDinamicos;
var
  i: integer;
  ficha: TFichaGTer_OnOffPorPasoV2;
begin
  inherited registrarParametrosDinamicos;
  lpd.expandirFichas(globs);
  lpd.RegistrarFichasAActualizar(Self, globs.ActualizadorLPD, @pA, nil);
  for i := 0 to lpd.Count - 1 do
  begin
    ficha := TFichaGTer_OnOffPorPasoV2(lpd[i]);
    if ficha.indicePreciosPorCombustible <> nil then
      ficha.nroBornePreciosPorCombustible :=
        ficha.indicePreciosPorCombustible.IdBorne(ficha.bornePreciosPorCombustible);
  end;
end;

function TGTer_OnOffPorPasoV2.PotenciaFirme: NReal;
begin
  Result := (paUnidades.nUnidades[0]) * pa.PMax * pa.disp;
end;

function TGTer_OnOffPorPasoV2.InfoAd_: string;
begin
  Result := '';
end;

class function TGTer_OnOffPorPasoV2.DescClase: string;
begin
  Result := rsGeneradorTermicoEncyApXPasoTiempoV2;
end;

procedure TGTer_OnOffPorPasoV2.SorteosDelPaso(sortear: boolean);
begin
  if globs.ObligarDisponibilidad_1_ then
  begin
    NMaquinasDisponibles := paUnidades.nUnidades[0];
    PMaxDisponible := pa.PMax * NMaquinasDisponibles;
  end
  else
  if sortear then
  begin
    ActualizarProbabilidadesReparacionYRotura(pa.disp, pa.tRepHoras);
    NMaquinasDisponibles := Sorteos_RepRotUnidades;
    PMaxDisponible := pa.PMax * NMaquinasDisponibles;
  end
  else
  begin
    NMaquinasDisponibles := paUnidades.nUnidades[0];
    PMaxDisponible := pa.PMax * pa.disp * NMaquinasDisponibles;
  end;
end;

procedure TGTer_OnOffPorPasoV2.PrepararPaso_ps;
var
  i: integer;
begin
  PMin := pa.PMIn;
  PxMax := pa.PMax - pa.PMin;

  for i := 1 to 3 do
  begin

    if pa.combustible[i] <> nil then
    begin
      cvMT[i] := (pa.combustible[i].pa.precio *
        pa.combustible[i].pa.PCS) / (pa.rendimientoMT[i] *
        pa.combustible[i].pa.PCI);

      cvPN[i] := (pa.combustible[i].pa.precio *
        pa.combustible[i].pa.PCS) / (pa.rendimientoMT[i] *
        pa.combustible[i].pa.PCI);
    end
    else
    begin
      cvMT[i] := Math.MaxDouble;
      cvPN[i] := Math.MaxDouble;
    end;
  end;

  c0 := Min(Min(cvMT[1], cvMT[1]), cvMT[3]);
  cv := Min(Min(cvPN[1], cvPN[1]), cvPN[3]);

end;

procedure TGTer_OnOffPorPasoV2.Sim_Paso_Fin;
var
  iposte: integer;
begin
  if NMaquinasDisponibles > 0 then
  begin
    for iposte := 0 to high(P) do
      potMedia_despachada := potMedia_despachada + P[iposte] * globs.durpos[iposte];
    potMedia_despachada := potMedia_despachada * globs.invHorasDelPaso;
  end
  else
  begin
    potMedia_despachada := 0;
  end;
end;

procedure TGTer_OnOffPorPasoV2.WriteToText(f: TArchiTexto);
begin
  inherited WriteToText(f);
end;

procedure TGTer_OnOffPorPasoV2.opt_nvers(var ivar, ivae, ires: integer);
begin
  if NMaquinasDisponibles = 0 then
    exit; // si no hay máquinas no juego
  Self.ivar := ivar;
  ivar := ivar + globs.NPostes + 1;
  Self.ivae := ivae;
  ivae := ivae + 1;
  Self.ires := ires;
  ires := ires + globs.NPostes;
  if pA.HayRestriccionEmaxPasoDeTiempo then
    Inc(ires);
end;

procedure TGTer_OnOffPorPasoV2.opt_cargue(s: TSimplex);
var
  inodores: integer;
  iposte: integer;
  jres: integer;
begin
  if NMaquinasDisponibles = 0 then
    exit; // si no hay máquinas no juego

{$IFDEF SPXCONLOG}
  spx_NombrarVariables(s);
{$ENDIF}

  inodores := nodo.ires;

  // aporte a las restricciones del nodo
  for iposte := 0 to globs.NPostes - 1 do
  begin
    s.pon_e(inodores + iposte, ivar + iposte, 1); // coeficiente de la B[iposte]
    s.pon_e(inodores + iposte, ivar + globs.NPostes, Pmin); // coef A
  end;
  // restricciones adicionales impuestas por la variable de Acople
  jres := ires;
  for iposte := 0 to globs.NPostes - 1 do
  begin
    s.pon_e(jres, ivar + iposte, -1); // coef B[iposte]
    s.pon_e(jres, ivar + globs.NPostes, PxMax);
    Inc(jres);
  end;
  //Restriccion a la energía máxima generable en un paso
  if pA.HayRestriccionEmaxPasoDeTiempo then
  begin
    for iposte := 0 to globs.NPostes - 1 do
      s.pon_e(jres, ivar + iposte, -globs.durpos[iposte]);
    s.pon_e(jres, ivar + globs.NPostes, -pa.PMin * globs.HorasDelPaso);
    s.pon_e(jres, s.nc, pa.EmaxPasoDeTiempo);
  end;

  // aportes a la función de utilidad
  for iposte := 0 to globs.NPostes - 1 do
    s.pon_e(s.nf, ivar + iposte, -cv * globs.DurPos[iposte]);
  s.pon_e(s.nf, ivar + globs.NPostes, -c0 * globs.HorasDelPaso);
end;

procedure TGTer_OnOffPorPasoV2.opt_fijarRestriccionesDeCaja(s: TSimplex);
var
  iposte: integer;
  acoples: TListaAcoplesVEntera;
begin
  if NMaquinasDisponibles = 0 then
    exit;

  // Restricciones de caja de las B (Esto no es necesario pues las restricciones adicionales
  // obligan que estas se cumplan. Por eso le pongo el 1.1 para dejarle la caja un poco floja
  for iposte := 0 to globs.NPostes - 1 do
    s.cota_sup_set(ivar + iposte, PxMax * NMaquinasDisponibles * 1.1);
  setLength(acoples, globs.NPostes);
  for iposte := 0 to globs.NPostes - 1 do
  begin
    acoples[iposte].ivar := ivar + iposte;
    acoples[iposte].ires := ires + iposte;
  end;
  // Restricciones de caja de las A y las declaramos enteras
  TMIPSimplex(s).set_EnteraConAcoples(ivae, ivar + globs.NPostes,
    NMaquinasDisponibles, acoples);
end;

procedure TGTer_OnOffPorPasoV2.opt_leerSolucion(s: TSimplex);
var
  iposte: integer;
  EnergiaPorEncimaDelMinimo: NReal;
  m: NReal;

begin
  CostoDirectoDelPaso := 0;

  if NMaquinasDisponibles = 0 then
  begin
    vclear(P);
    vclear(costosPorPoste);
    NMaquinasDespachadas := 0;
    exit;
  end;

  NMaquinasDespachadas := trunc(s.xval(ivar + globs.NPostes) + 0.2);

  EnergiaPorEncimaDelMinimo := 0;
  for iposte := 0 to globs.NPostes - 1 do
  begin
    m := s.xval(ivar + iposte);
    EnergiaPorEncimaDelMinimo := EnergiaPorEncimaDelMinimo + m * globs.DurPos[iposte];
    P[iposte] := m + NMaquinasDespachadas * Pmin;

    if NMaquinasDespachadas > 0 then
      costosPorPoste[iposte] :=
        ((P[iposte] - PMin * NMaquinasDespachadas) * cv + NMaquinasDespachadas * c0) *
        globs.durpos[iposte]
    else
      costosPorPoste[iposte] := 0;
  end;
  CostoDirectoDelPaso := EnergiaPorEncimaDelMinimo * cv + NMaquinasDespachadas *
    c0 * globs.HorasDelPaso;
end;


{$IFDEF SPXCONLOG}
procedure TGTer_OnOffPorPasoV2.spx_NombrarVariables(s: TSimplex);
var
  iposte: integer;
begin
  if NMaquinasDisponibles = 0 then
    exit; // si no hay máquinas no juego
  for iposte := 0 to globs.NPostes - 1 do
  begin
    s.set_NombreVar(ivar + iposte, Nombre + '_P[MW]' + IntToStr(iposte + 1));
    s.set_NombreRest(ires + iposte, Nombre + '_res-A' + IntToStr(iposte + 1));
  end;
  s.set_NombreVar(ivar + globs.NPostes, Nombre + '_A');
  if pA.HayRestriccionEmaxPasoDeTiempo then
    s.set_NombreRest(ires + globs.NPostes, Nombre + '_res-EMax');
end;

{$ENDIF}

function TGTer_OnOffPorPasoV2.getNombreVar(ivar: integer;
  var nombre: string): boolean;
begin
  if NMaquinasDisponibles = 0 then // si no hay máquinas no juego
    Result := False
  else
  if (ivar >= self.ivar) and (ivar < self.ivar + globs.NPostes) then
  begin
    nombre := self.Nombre + '_P[MW]' + IntToStr(ivar - self.ivar + 1);
    Result := True;
  end
  else if (ivar = self.ivar + globs.NPostes) then
  begin
    nombre := self.Nombre + '_A[MW]';
    Result := True;
  end
  else
    Result := False;
end;

function TGTer_OnOffPorPasoV2.getNombreRes(ires: integer;
  var nombre: string): boolean;
begin
  if NMaquinasDisponibles = 0 then // si no hay máquinas no juego
    Result := False
  else
  if (ires >= self.ires) and (ires < self.ires + globs.NPostes) then
  begin
    nombre := self.nombre + '_res-A' + IntToStr(ires - self.ires + 1);
    Result := True;
  end
  else if pa.HayRestriccionEmaxPasoDeTiempo and (ires = self.ires + globs.NPostes) then
  begin
    nombre := self.nombre + '_res-EMax';
    Result := True;
  end
  else
    Result := False;
end;

procedure TGTer_OnOffPorPasoV2.PubliVars;
begin
  inherited PubliVars;
  PublicarVariableVR('Costo', '[USD]', 6, 1, costosPorPoste, True, False);
  declararVarsPSimResPorDefectoIntercalandoPostes(['P', 'Costo'], globs.NPostes);
  PublicarVariableNI('NMaqsDespachadas', '-', NMaquinasDespachadas, True);
  PublicarVariableNR('c0', '[USD/h]', 6, 1, c0, False);
  PublicarVariableNI('NMaqsDisponibles', '-', NMaquinasDisponibles, False);

  PublicarVariableNR('PMaxDisponible', '[MW]', 6, 1, PMaxDisponible, False);
  PublicarVariableNR('PMediaDespachada', '[MW]', 6, 1, potMedia_despachada, False);
end;

procedure TGTer_OnOffPorPasoV2.Free;
begin
  setlength(costosPorPoste, 0);
  inherited Free;
end;

procedure AlInicio;
begin
  registrarClaseDeCosa(TGTer_OnOffPorPasoV2.ClassName, TGTer_OnOffPorPasoV2);
  registrarClaseDeCosa(TFichaGTer_OnOffPorPasoV2.ClassName, TFichaGTer_OnOffPorPasoV2);
end;

procedure AlFinal;
begin
end;

end.
