unit uGNLBOG;

interface

uses Math, Classes, xMatDefs;

type
  TGNLBOG = class


    //    constructor Create;


  public
    procedure BOG_poste(var BOG_T, BOG_GSS, BOG_RG, BOG_RC, BOG_RL,
      BOG_GRL, BOG_Vent, BSO: NReal;
      SendOut_poste, X_V, K_BOG, K_GSS, K_RG, K_RC, K_RL: NReal;
      Relicuado: boolean; horas_poste: NReal);
  end;

implementation

{
constructor Create;
begin

end;
 }
procedure TGNLBOG.BOG_poste(
  var BOG_T, BOG_GSS, BOG_RG, BOG_RC, BOG_RL, BOG_GRL, BOG_Vent, BSO: NReal;
  SendOut_poste, X_V, K_BOG, K_GSS, K_RG, K_RC, K_RL: NReal; Relicuado: boolean;
  horas_poste: NReal);

  {
    X_V: Volumen restante de GNL en el tanque en m3, tomado como GN, recordar que 1m3 GNL = 611,84m3 GN
     SendOut: Volumen de combustible que se emite

    BOG-RG:  volumen de BOG en m3 de GN que se utiliza para regasificación
    BOG-GRL:  volumen de BOG en m3 de GN que se emplea para dar energía a la planta de relicuefacción
    BOG-RC:  volumen de BOG en m3 de GN que se recondensa
    BOG-RL:  volumen de BOG en m3 de GN que se relicua
    BOG-VEN:  volumen de BOG en m3 de GN que se quema en la antorcha, y por tanto se desperdicia
    BSO:  volumen de GN regasifacado en m3 que se toma dar regasificar en el caso de que el BOG sea insuficiente


    K_BOG: Porcentaje de volumen del tanque que se evapora en BOG por hora
    K_GSS: Volumen de GN en m3 por hora requerido por la planta para operar, incluso si no esta emitiendo gas
    K_RG: Porcentaje de GN que se debe utilizar para regasificar una unidad de GNL
    K_RC: Porcentaje de BOG que se puede recondensar cuando la planta emite gas una unidad de GN
    K_RL: Ratio de BOG que se puede relicuar sobre BOG que se utiliza en el proceso de relicuado (relicuado + utilizado para dar energía al proceso)

    Relicuado: Constante binaria que indica si la planta es capaz de relicuar gas
  }

var
  BOG_Res: NReal;
  K_BOG_poste, K_GSS_poste, K_RG_poste, K_RC_poste, K_RL_poste: NReal;

begin

  K_BOG_poste := K_BOG * horas_poste;
  K_GSS_poste := K_GSS * horas_poste;
  //    K_RG_poste := K_RG * horas_poste;
  //    K_RC_poste := K_RC * horas_poste;
  //    K_RL_poste := K_RL * horas_poste;
  K_RG_poste := K_RG;
  K_RC_poste := K_RC;
  K_RL_poste := K_RL;

  BOG_T := K_BOG_poste * X_V;
  BOG_GSS := min(K_GSS_poste, BOG_T);
  BOG_RG := min(BOG_T - BOG_GSS, SendOut_poste * K_RG_poste);
  BSO := SendOut_poste * K_RG_poste - BOG_RG;
  BOG_RC := min(BOG_T - BOG_GSS - BOG_RG, SendOut_poste * K_RC_poste);
  BOG_Res := BOG_T - BOG_GSS - BOG_RG - BOG_RC;

  if Relicuado then
  begin
    BOG_GRL := BOG_Res / (1 + K_RL_poste);
    BOG_RL := BOG_GRL * K_RL_poste;
  end
  else
  begin
    BOG_RL := 0;
    BOG_GRL := 0;
  end;

  BOG_Vent := BOG_Res - BOG_RL - BOG_GRL;

end;


end.
