unit uGNLContratoSuministro;

interface

uses uSuministroCombustible, uCosa;

type

  { TGNLContratoSuministro }

  (* Esta clase representará los contratos dentro de un suministro de combustible multicliente *)
  TGNLContratoSuministro = class(TCosa)

  public
    (**************************************************************************)
    (*               A T R I B U T O S   P E R S I S T E N T E S              *)
    (**************************************************************************)

    cliente: TSuministroCombustible;
    proveedor: TSuministroCombustible;

    (**************************************************************************)

    constructor Create(capa: integer; cli, prov: TSuministroCombustible);
     
    constructor Create_ReadFromText(f: TArchiTexto); override;
    procedure WriteToText(f: TArchiTexto); override;
    
    procedure Free; override;

    



  published
    



  end;

procedure AlInicio;
procedure AlFinal;

implementation

{ TGNLContratoSuministro }

constructor TGNLContratoSuministro.Create(capa: integer; cli, prov: TSuministroCombustible);
begin
  inherited Create( capa );
  cliente := cli;
  proveedor := prov;
end;


 
constructor TGNLContratoSuministro.Create_ReadFromText(f: TArchiTexto);
begin
  inherited Create_ReadFromText(f);
  f.IniciarLecturaRetrasada;
  f.rdReferencia('cliente', TCosa(cliente), self);
  f.rdReferencia('proveedor', TCosa(proveedor), self);
  //    f.rd('bornePreciosPorCombustible', bornePreciosPorCombustible);
  f.EjecutarLectura;
end;

procedure TGNLContratoSuministro.WriteToText(f: TArchiTexto);
begin
  inherited WriteToText(f);
  f.wrReferencia('cliente', cliente);
  f.wrReferencia('proveedor', proveedor);
  //  f.wr('bornePreciosPorCombustible', bornePreciosPorCombustible);
end;


procedure TGNLContratoSuministro.Free;
begin
  inherited Free;
end;










procedure AlInicio;
begin
  registrarClaseDeCosa(TGNLContratoSuministro.ClassName, TGNLContratoSuministro);
end;

procedure AlFinal;
begin
end;



end.
