unit uGNLListaContratoSuministro;

interface

uses Classes, UGNLContratoSuministro, UCosa;

type

  { TGNLListaContratoSuministro }

  TGNLListaContratoSuministro = class(TListaDeCosas)
  public
    constructor Create(capa: integer);
     
    constructor Create_ReadFromText(f: TArchiTexto); override;
    procedure WriteToText(f: TArchiTexto); override;
    
    function add(contrato: TGNLContratoSuministro): integer; overload;
    function ExisteContrato(unContrato: TGNLContratoSuministro): boolean;
    procedure Free; override;

    


  end;

procedure AlInicio;
procedure AlFinal;

implementation

const
  k_nombre = 'GNLListaContratoSuministro';

{ TGNLListaContratoSuministro }

function TGNLListaContratoSuministro.add(contrato: TGNLContratoSuministro): integer;
begin
  Result := lst.Add(contrato);
end;

constructor TGNLListaContratoSuministro.Create( capa: integer );
begin
  inherited Create(capa, k_nombre);
end;

 
constructor TGNLListaContratoSuministro.Create_ReadFromText(f: TArchiTexto);
begin
  f.aux_idCarpeta := k_nombre;
  inherited Create_ReadFromText(f);
end;

procedure TGNLListaContratoSuministro.WriteToText(f: TArchiTexto);
var
  i: integer;
begin
  // primero hacemos un barrido y eliminamos las fichas con referencia a nil
  // que pudiera habar por ERRORES en el editor. (causa por la que cambiamos a VER3)
  i := 0;
  while (i < lst.Count) do
    if TGNLContratoSuministro(lst[i]).cliente = nil then
      lst.Delete(i)
    else
      Inc(i);

  // ahora si llamamos a TListDeCosas.WriteToText
  inherited WriteToText(f);
end;


function TGNLListaContratoSuministro.ExisteContrato(
  unContrato: TGNLContratoSuministro): boolean;
var
  i: integer;
  contrato: TGNLContratoSuministro;
begin
  for i := 0 to lst.Count - 1 do
  begin
    contrato := TGNLContratoSuministro(lst.Items[i]);
    if (contrato.cliente = uncontrato.cliente) and
      (contrato.proveedor = unContrato.proveedor) then
      Exit(True);
  end;
  Result := False;
end;

procedure TGNLListaContratoSuministro.Free;
begin
  inherited Free;

end;









procedure AlInicio;
begin
  registrarClaseDeCosa(TGNLListaContratoSuministro.ClassName,
    TGNLListaContratoSuministro);
end;

procedure AlFinal;
begin
end;


end.
