unit uGNLManejadorCuentas;


interface

uses
  ucosaparticipedemercado,
  UCosaConNombre, uGNLCuentas, UGNLConceptos, UGNLItemCuenta;

const
  K_CuentaInvalida = '';
//Cuando no hay cuentas asociadas a los cargamentos devuelve la cuenta invalida

const
  k_CuentaInvalidaId = -1; //CuentaId inválida

const
  k_TotalCuentas = 2; //Total de cuentas posibles del sistema

//Conceptos
const
  k_Concep_QProp = 'QPropio_dt';

const
  k_Concep_QPres = 'QPrestamo_dt';

const
  k_Concep_Vol = 'Volumen';

const
  k_Concep_Alpha = 'Alpha';

const
  k_Concep_VEmb = 'V_Embarque';

const
  k_Concep_SaldoPres = 'Saldo_PedidoEnPrestamo';



type

  ///  TTipoSalida=(GNLCuentaEntrada,GNLCuentaSalida,GNLCuentaNeto,GNLCuentaSaldo,GNLCuentaObservaciones);

  //Singleton
  TGNLManejadorCuentas = class(TObject)

  private


    Items: array of TGNLItemCuentas;
    Conceptos: array of TGNLConceptos;
    class var _instance: TGNLManejadorCuentas;
    procedure Inicializar;
    //procedure set_Valor(Cuenta:TGNLCuentas;Concepto:TGNLConceptos;Valor:double);overload;
    function get_Cuenta(CuentaCod: string): TGNLCuentas;
    function get_Concepto(ConceptoCod: string): TGNLConceptos;
    procedure addItem(CuentaCod: string; ConceptoCod: string; Valor: double);
 {      function get_Valor(Cuenta:integer;Salida:TTipoSalida):double;overload;
 }

  public
    Cuentas: array[0..k_TotalCuentas - 1] of TGNLCuentas;

    constructor Init;
    class function Create: TGNLManejadorCuentas;
    procedure ImprimirCuentas(var Impresor: TCosaParticipeDeMercado);
    function get_CuentaId(CuentaCod: string): integer;
    function get_CuentaCodComplemento(CuentaCod: string): string;
    function get_CuentaAlphaTica(CuentaCod: string): double;
    function get_Item(CuentaCod: string; ConceptoCod: string): TGNLItemCuentas;
    procedure set_Valor(CuentaCod: string; ConceptoCod: string;
      Valor: double; Acumular: boolean);
    destructor Destroy;
  end;

implementation

{ TGNLManejadorCuentas }

destructor TGNLManejadorCuentas.Destroy;
begin
  _instance := nil;
  inherited;
end;

function TGNLManejadorCuentas.get_Concepto(ConceptoCod: string): TGNLConceptos;
var
  i: integer;
begin
  get_Concepto := nil;
  for I := Low(Conceptos) to High(Conceptos) do
    if Conceptos[i].Codigo = ConceptoCod then
    begin
      Result := Conceptos[i];
      exit;
    end;
end;

function TGNLManejadorCuentas.get_Cuenta(CuentaCod: string): TGNLCuentas;
var
  i: integer;
begin
  if CuentaCod = K_CuentaInvalida then
  begin
    Result := nil;
    exit;
  end;

  get_Cuenta := nil;
  for I := Low(Cuentas) to High(Cuentas) do
    if Cuentas[i].Codigo = CuentaCod then
    begin
      Result := Cuentas[i];
      exit;
    end;

end;


function TGNLManejadorCuentas.get_CuentaAlphaTica(CuentaCod: string): double;
var
  Cuenta: TGNLCuentas;
begin
  Cuenta := self.get_Cuenta(CuentaCod);
  if Cuenta <> nil then
    get_CuentaAlphaTica := cuenta.AlphaTICA
  else
    get_CuentaAlphaTica := 1;
end;

function TGNLManejadorCuentas.get_CuentaCodComplemento(CuentaCod: string): string;
var
  Cuenta: TGNLCuentas;
begin
  Cuenta := self.get_Cuenta(CuentaCod);
  if Cuenta <> nil then
    get_CuentaCodComplemento := cuenta.CuentaComplementoCod
  else
    get_CuentaCodComplemento := K_CuentaInvalida;
end;

function TGNLManejadorCuentas.get_CuentaId(CuentaCod: string): integer;
var
  Cuenta: TGNLCuentas;
begin
  Cuenta := self.get_Cuenta(CuentaCod);
  if Cuenta = nil then
    get_CuentaId := k_CuentaInvalidaId
  else
    get_CuentaId := Cuenta.Nro;
end;

function TGNLManejadorCuentas.get_Item(CuentaCod, ConceptoCod: string): TGNLItemCuentas;
var
  I: integer;
begin
  for I := Low(Items) to High(Items) do
  begin
    if (Items[i].Cuenta.Codigo = CuentaCod) and
      (Items[i].Concepto.Codigo = ConceptoCod) then
    begin
      get_Item := Items[i];
      exit;
    end;
  end;
  get_Item := nil;
end;

procedure TGNLManejadorCuentas.ImprimirCuentas(var Impresor: TCosaParticipeDeMercado);
var
  i: integer;
begin

  for I := Low(Items) to High(Items) do
    //Registra las variables que se van a imprimir
    //Tienen que estar todas creadas
    Impresor.PublicarVariableNR(Items[i].Cuenta.Codigo + '_' +
      Items[i].Concepto.Descripcion, '-', 7, 2, items[i].Total, True);
end;

procedure TGNLManejadorCuentas.Inicializar;
var
  i: integer;
begin
  // Inicializa las Cuentas
  //       Cuentas[0]:= TGNLCuentas.Create('UTE','UTE',0,'ANC',1);
  //       Cuentas[1]:= TGNLCuentas.Create('ANC','ANCAP',1,'UTE',1);
  Cuentas[0] := TGNLCuentas.Create('ARG', 'ARGENTINA', 2, 'URU', 1);
  Cuentas[1] := TGNLCuentas.Create('URU', 'Uruguay', 3, 'ARG', 1);

  //Inicializa los conceptos
  SetLength(Conceptos, 6);
  Conceptos[0] := TGNLConceptos.Create(k_Concep_QProp, 'QPropio_dt');
  Conceptos[1] := TGNLConceptos.Create(k_Concep_QPres, 'QPrestamo_dt');
  Conceptos[2] := TGNLConceptos.Create(k_Concep_Vol, 'Volumen');
  Conceptos[3] := TGNLConceptos.Create(k_Concep_SaldoPres, 'SaldoPrestamo');
  Conceptos[4] := TGNLConceptos.Create(k_Concep_Alpha, 'Alpha');
  Conceptos[5] := TGNLConceptos.Create(k_Concep_VEmb, 'V_Embarque');

  SetLength(Items, 0);
end;


procedure TGNLManejadorCuentas.set_Valor(CuentaCod, ConceptoCod: string;
  Valor: double; Acumular: boolean);
var
  Item: TGNLItemCuentas;
begin
  //buscar valor
  Item := self.get_Item(CuentaCod, ConceptoCod);

  if Item <> nil then  //si existe lo modifica
    if Acumular then //si acumula al valor anterior
      Item.Total := Item.Total + Valor
    else
      Item.Total := Valor
  else  //si no existe y los datos son coherentes lo agrega
  if (CuentaCod <> '') and (ConceptoCod <> '') then
    self.addItem(CuentaCod, ConceptoCod, Valor);
end;

procedure TGNLManejadorCuentas.addItem(CuentaCod, ConceptoCod: string; Valor: double);
begin
  SetLength(Items, length(Items) + 1); //Agrega un elemento a items
  items[High(items)] := TGNLItemCuentas.Create(
    self.get_Cuenta(cuentaCod), self.get_Concepto(ConceptoCod), Valor);
end;


class function TGNLManejadorCuentas.Create: TGNLManejadorCuentas;
begin
  if (_instance = nil) then
  begin
    _instance := TGNLManejadorCuentas.Init;
  end;

  Result := _instance;
end;

constructor TGNLManejadorCuentas.Init;
begin
   inherited Create;
   self.Inicializar;
end;


end.
