//====Modificado metodos: CreateDataColumnList y CreateDataConversionList===
//====Micho@25/5==mvarela@adme.com.uy=======================================
unit uGNLPlanta;

interface

uses
  Math, Classes, xMatDefs, uSimplex, uGlobs, uFechas, uEstados,
  uActores, uFichasLPD, uNodos,
  uGeneradores, UGNLListaContratoSuministro,
  UGNLSuministroMultiCliente,
  USuministroCombustible,
  uCosa,
  uFuentesAleatorias,
  uconstantesSimSEE, SysUtils, uConversions;

type

  { TGNLFichaPlanta }

  TGNLFichaPlanta = class(TGNLFichaSuministroMultiCliente)

  public

    (**************************************************************************)
    (*               A T R I B U T O S   P E R S I S T E N T E S              *)
    (**************************************************************************)

    costo_arranque, costo_parada: NReal; //Costo de Arranque y Parada
    vol_tanque: NReal; //Volumen del tanque

    (**************************************************************************)

    constructor Create(capa: integer; fecha: TFecha; periodicidad: TPeriodicidad; nombrecombustible: string; ListaContratos: TGNLListaContratoSuministro; pcosto_arranque, pcosto_parada, pvol_tanque: NReal; indicePreciosPorCombustible: TFuenteAleatoria; bornePreciosPorCombustible: string);

     
    constructor Create_ReadFromText(f: TArchiTexto); override;
    procedure WriteToText(f: TArchiTexto); override;
    

    function infoAd_: string; override;
    procedure Free; override;

    





  






  end;

  { TGNLPlanta }

  TGNLPlanta = class(TGNLSuministroMultiCliente)

  (*
  Esta clase representará posibles suministros de combustible para
  los generadores termicos
  *)
  public

    pa: TGNLFichaPlanta;
    vol_ini_tanque: NReal;
    encendidaAlInicio: boolean;
    //Variables de Estado
    X_MaquinaRegasificando, Xs_MaquinaRegasificando: boolean;
    constructor Create(capa: integer; nombre: string; nombreCombustible: string; nacimiento, muerte: TFecha; lpdUnidades, lpd: TFichasLPD; encendidaAlInicio: boolean); virtual;


     
      constructor Create_ReadFromText(f: TArchiTexto); override;
      procedure WriteToText(f: TArchiTexto); override;
    

    function get_ires_volumen: NInt; override;
    function get_precio_combustible: NReal; override;
    function get_combustible: TCombustibleSGE; override;

    class function TipoFichaLPD: TClaseDeFichaLPD; virtual; abstract;
    //      procedure sim_PrintResultados_Encab_PotFirme(var fsal: textfile; kencab: integer ); virtual;
    //      procedure sim_PrintResultados_PotFirme(var fsal: textfile); virtual;
    procedure Free; override;
    class function DescClase: string; override;


    procedure PrepararMemoria(globs: TGlobs); override;
    procedure RegistrarParametrosDinamicos; override;


    procedure SorteosDelPaso(sortear: boolean); override;
    procedure PrepararPaso_ps; override;

    procedure Sim_Cronica_Inicio; override;

    procedure opt_nvers(var ivar, ivae, ires: integer); override;

    procedure opt_cargue(s: TSimplex); override;

    procedure EvolucionarEstado; override;

    procedure opt_fijarRestriccionesDeCaja(s: TSimplex); override;

    procedure opt_leerSolucion(s: TSimplex); override;

    function getNombreVar(ivar: integer; var nombre: string): boolean; override;
    function getNombreRes(ires: integer; var nombre: string): boolean; override;

    procedure PosicionarseEnEstrellita; override;
    procedure optx_nvxs(var ixr, ixd, iauxr, iauxd: integer); override;

    // imprime tabla de delta costo futuro de la variable de estado..
    procedure opt_PrintResultados_Encab(var fsal: textfile); override;
    procedure opt_PrintResultados(var fsal: textfile); override;

    procedure optx_RegistrarVariablesDeEstado(adminEstados: TAdminEstados); override;

    //      procedure Sim_PrintResultados_Encab(var fsal: textfile; kencab: integer ); override;
    //      procedure Sim_PrintResultados(var fsal: textfile); override;

    procedure PubliVars; override;
    //          function varsPSimRes3PorDefecto: TStringList; override;


    procedure AfterInstantiation; override;

  end;

procedure AlInicio;
procedure AlFinal;
procedure TGNLPlanta_cambioFichaPD(Actor: TCosa);

implementation


//------------------------------
// Métodos de TGNLFichaPlanta
//==============================
constructor TGNLFichaPlanta.Create(capa: integer; fecha: TFecha; periodicidad: TPeriodicidad; nombrecombustible: string; ListaContratos: TGNLListaContratoSuministro; pcosto_arranque, pcosto_parada, pvol_tanque: NReal; indicePreciosPorCombustible: TFuenteAleatoria; bornePreciosPorCombustible: string);
begin
  inherited Create(capa, fecha, periodicidad, nombrecombustible,
    indicePreciosPorCombustible, bornePreciosPorCombustible, ListaContratos);
  costo_arranque := pcosto_arranque;
  costo_parada := pcosto_parada;
  vol_tanque := pvol_tanque;
end;

 
constructor TGNLFichaPlanta.Create_ReadFromText(f: TArchiTexto);
begin
  inherited Create_ReadFromText(f);
  f.IniciarLecturaRetrasada;
  f.rd('C_ARRANQUE', costo_arranque);
  f.rd('C_PARADA', costo_parada);
  f.rd('V_TANQUE', vol_tanque);
  f.EjecutarLectura;
end;
procedure TGNLFichaPlanta.WriteToText(f: TArchiTexto);
begin
  inherited WriteToText(f);
  f.wr('C_ARRANQUE', costo_arranque);
  f.wr('C_PARADA', costo_parada);
  f.wr('V_TANQUE', vol_tanque);
end;



function TGNLFichaPlanta.infoAd_: string;
begin
  Result := inherited  infoAd_;
  //result:= result + 'C_ARRANQUE= ' + IFloatToStrF(, ffGeneral, 10, 1) + 'dias' +
  //         'C_PARADA= ' + FloatToStrF(V_ToP, ffGeneral, 10, 1) + ' ' + combustible.Unidades + ', ' +
  //         'V_TANQUE= ' + FloatToStrF(P_ToP, ffGeneral, 10, 1) + ' USD/' + combustible.Unidades + ', ' +
  //         'P_ExtraToP= ' + FloatToStrF(P_ExtraToP, ffGeneral, 10, 2) + ' USD/' +combustible.Unidades+', ';

end;

procedure TGNLFichaPlanta.Free;
begin
  inherited Free;
end;





















//------------------------------
// Métodos de TGNLPlanta
//==============================

constructor TGNLPlanta.Create(capa: integer; nombre: string; nombreCombustible: string; nacimiento, muerte: TFecha; lpdUnidades, lpd: TFichasLPD; encendidaAlInicio: boolean);
begin
  inherited Create(capa, nombre, nombreCombustible, nacimiento, muerte, lpdUnidades, lpd);
  self.encendidaAlInicio := encendidaAlInicio;
end;


 
constructor TGNLPlanta.Create_ReadFromText(f: TArchiTexto);
begin
  inherited Create_ReadFromText(f);
  pa := nil;
end;

procedure TGNLPlanta.WriteToText(f: TArchiTexto);
begin
  inherited WriteToText(f);
end;



procedure TGNLPlanta.PrepararMemoria(globs: TGlobs);
begin
  inherited prepararMemoria(globs);
end;


function TGNLPlanta.get_ires_volumen: NInt;
begin
  Result := self.ires;
end;

function TGNLPlanta.get_precio_combustible: NReal;
begin
end;


function TGNLPlanta.get_combustible: TCombustibleSGE;
begin
  Result := self.combustible;
end;

procedure TGNLPlanta.RegistrarParametrosDinamicos;
var
  i: integer;
  ficha: TGNLFichaPlanta;
begin
  inherited registrarParametrosDinamicos;
  lpd.expandirFichas(globs);
  lpd.RegistrarFichasAActualizar(Self, globs.ActualizadorLPD, @pA, nil,
    TGNLPlanta_cambioFichaPD);
  for i := 0 to lpd.Count - 1 do
  begin
    ficha := TGNLFichaPlanta(lpd[i]);
    if ficha.indicePreciosPorCombustible <> nil then
      ficha.nroBornePreciosPorCombustible :=
        ficha.indicePreciosPorCombustible.IdBorne(ficha.bornePreciosPorCombustible);
  end;
end;

procedure TGNLPlanta.Free;
begin
  inherited Free;
end;

class function TGNLPlanta.DescClase: string;
begin
  Result := 'Planta de Regasificación de GNL';
end;



procedure TGNLPlanta.SorteosDelPaso(sortear: boolean);
begin
end;


procedure TGNLPlanta.PrepararPaso_ps;
begin

end;

procedure TGNLPlanta.opt_nvers(var ivar, ivae, ires: integer);
begin
end;

procedure TGNLPlanta.opt_cargue(s: TSimplex);
begin
end;

procedure TGNLPlanta.Sim_Cronica_Inicio;
begin
  inherited Sim_Cronica_Inicio;
end;

procedure TGNLPlanta.opt_fijarRestriccionesDeCaja(s: TSimplex);
begin

end;

procedure TGNLPlanta.opt_leerSolucion(s: TSimplex);
begin

end;

procedure TGNLPlanta.EvolucionarEstado;
begin

end;

function TGNLPlanta.getNombreVar(ivar: integer; var nombre: string): boolean;
begin
  Result := False;
end;

function TGNLPlanta.getNombreRes(ires: integer; var nombre: string): boolean;
begin
  Result := False;
end;

procedure TGNLPlanta.PubliVars;
begin
  inherited PubliVars;
end;

procedure TGNLPlanta.AfterInstantiation;
begin
  inherited AfterInstantiation;
  pa := nil;
end;

{
function TGNLPlanta.varsPSimRes3PorDefecto: TStringList;
begin
   result := nil;
end;
}

procedure TGNLPlanta.optx_nvxs(var ixr, ixd, iauxr, iauxd: integer);
begin
end;

procedure TGNLPlanta.PosicionarseEnEstrellita;
begin
end;

procedure TGNLPlanta.optx_RegistrarVariablesDeEstado(adminEstados: TAdminEstados);
begin
end;


procedure TGNLPlanta.opt_PrintResultados_Encab(var fsal: textfile);
begin
end;

procedure TGNLPlanta.opt_PrintResultados(var fsal: textfile);
begin
end;

{
procedure TGNLPlanta.Sim_PrintResultados_Encab(var fsal: textfile; kencab: integer );
begin

end;

procedure TGNLPlanta.Sim_PrintResultados(var fsal: textfile);
begin

end;
}

procedure TGNLPlanta_cambioFichaPD(Actor: TCosa);
begin
end;

procedure AlInicio;
begin
  registrarClaseDeCosa(TGNLPlanta.ClassName, TGNLPlanta);
  registrarClaseDeCosa(TGNLFichaPlanta.ClassName, TGNLFichaPlanta);
end;

procedure AlFinal;
begin
end;

end.
