//====Modificado metodos: CreateDataColumnList y CreateDataConversionList===
//====Micho@26/5==mvarela@adme.com.uy=======================================
unit uGNLSuministroCombustibleSimple;

interface

uses
  Math, xMatDefs, uSimplex, uGlobs, uFechas, uEstados, Classes,
  uActores, uFichasLPD, uNodos,
  uGeneradores,
  uSuministroCombustible,
  uCosa,
  uFuentesAleatorias,
  uconstantesSimSEE, SysUtils,
  uAgenda;

type

  { TFichaGNLSuministroCombustibleSimple }

  TFichaGNLSuministroCombustibleSimple = class(TFichaSuministroCombustible)
  public
    P_ExtraToP: NReal;
    // [U$] Precio por Unidad de Volumen de combustible consumido por encima del volumen comprometido por Take or Pay
    C_Max: NReal; // [unidad e Volumen/h] Caudal máximo del suministro
    limites_postizados: boolean;

    constructor Create(capa: integer; fecha: TFecha; periodicidad: TPeriodicidad;
      nombrecombustible: string; indicePreciosPorCombustible: TFuenteAleatoria;
      bornePreciosPorCombustible: string);
     
    constructor Create_ReadFromText(f: TArchiTexto); override;
    procedure WriteToText(f: TArchiTexto); override;
    

    function infoAd_: string; override;
    procedure Free; override;

  end;

type

  { TGNLSuministroCombustibleSimple }

  TGNLSuministroCombustibleSimple = class(TSuministroCombustible)

  (*
  Esta clase representará posibles suministros de combustible para
  los generadores termicos
  *)
  public

    pa: TFichaGNLSuministroCombustibleSimple;

    cvExtraToP: NReal;  //Costo Variable de lo consumido por sobre del ToP
    //Volumen que despacho de combustible por sobre el disponible.
    //En este caso aporto al paso un costo P_ExtraToP por cada unidad de combustible
    VConsumido_Extra_Top: NReal;

    costoExtraToP: NReal;
    indice_res_ETop, indice_var_ETop: integer;

    constructor Create(capa: integer; nombre: string; nombreCombustible: string;
      nacimiento, muerte: TFecha; lpdUnidades, lpd: TFichasLPD); virtual;

     
    constructor Create_ReadFromText(f: TArchiTexto); override;
    procedure WriteToText(f: TArchiTexto); override;
    

    function get_ires_volumen: NInt; override;
    function get_precio_combustible: NReal; override;
    function get_combustible: TCombustibleSGE; override;
    function restricciones_postizadas: boolean; override;
    class function TipoFichaLPD: TClaseDeFichaLPD; virtual; abstract;
    //      procedure sim_PrintResultados_Encab_PotFirme(var fsal: textfile; kencab: integer ); virtual;
    //      procedure sim_PrintResultados_PotFirme(var fsal: textfile); virtual;
    procedure Free; override;
    class function DescClase: string; override;


    procedure PrepararMemoria(globs: TGlobs); override;
    procedure RegistrarParametrosDinamicos; override;


    procedure SorteosDelPaso(sortear: boolean); override;
    procedure PrepararPaso_ps; override;

    procedure Sim_Cronica_Inicio; override;

    procedure opt_nvers(var ivar, ivae, ires: integer); override;

    procedure opt_cargue(s: TSimplex); override;

    procedure EvolucionarEstado; override;

    procedure opt_fijarRestriccionesDeCaja(s: TSimplex); override;

    procedure opt_leerSolucion(s: TSimplex); override;

    function getNombreVar(ivar: integer; var nombre: string): boolean; override;
    function getNombreRes(ires: integer; var nombre: string): boolean; override;

    procedure PosicionarseEnEstrellita; override;
    procedure optx_nvxs(var ixr, ixd, iauxr, iauxd: integer); override;

    // imprime tabla de delta costo futuro de la variable de estado..
    procedure opt_PrintResultados_Encab(var fsal: textfile); override;
    procedure opt_PrintResultados(var fsal: textfile); override;

    procedure optx_RegistrarVariablesDeEstado(adminEstados: TAdminEstados); override;

    //      procedure sim_PrintResultados_Encab(var fsal: textfile; kencab: integer ); override;
    //      procedure sim_PrintResultados(var fsal: textfile); override;

    procedure PubliVars; override;
    //          function varsPSimRes3PorDefecto: TStringList; override;


    procedure AfterInstantiation; override;
  end;

procedure AlInicio;
procedure AlFinal;
procedure TGNLSuministroCombustibleSimple_cambioFichaPD(Actor: TCosa);

implementation


//------------------------------
// Métodos de TFichaGNLSuministroCombustibleSimple
//==============================
constructor TFichaGNLSuministroCombustibleSimple.Create(capa: integer;
  fecha: TFecha; periodicidad: TPeriodicidad; nombrecombustible: string;
  indicePreciosPorCombustible: TFuenteAleatoria; bornePreciosPorCombustible: string);

begin
  inherited Create(capa, fecha, periodicidad, nombrecombustible,
    indicePreciosPorCombustible, bornePreciosPorCombustible);

end;

 
constructor TFichaGNLSuministroCombustibleSimple.Create_ReadFromText(f: TArchiTexto);
begin
  inherited Create_ReadFromText(f);
end;

procedure TFichaGNLSuministroCombustibleSimple.WriteToText(f: TArchiTexto);
begin
  inherited WriteToText(f);
end;




function TFichaGNLSuministroCombustibleSimple.infoAd_: string;
begin
  Result := inherited  infoAd_;
end;

procedure TFichaGNLSuministroCombustibleSimple.Free;
begin
  inherited Free;
end;

//------------------------------
// Métodos de TGNLSuministroCombustibleSimple
//==============================

constructor TGNLSuministroCombustibleSimple.Create(capa: integer;
  nombre: string; nombreCombustible: string; nacimiento, muerte: TFecha;
  lpdUnidades, lpd: TFichasLPD);
begin
  inherited Create(capa, nombre, nombreCombustible, nacimiento, muerte,
    lpdUnidades, lpd);
end;


 
constructor TGNLSuministroCombustibleSimple.Create_ReadFromText(f: TArchiTexto);
begin
  inherited Create_ReadFromText(f);
  pa := nil;
end;

procedure TGNLSuministroCombustibleSimple.WriteToText(f: TArchiTexto);
begin
  inherited WriteToText(f);
end;




procedure TGNLSuministroCombustibleSimple.PrepararMemoria(globs: TGlobs);
begin
  inherited prepararMemoria(globs);
end;

function TGNLSuministroCombustibleSimple.get_ires_volumen: NInt;
begin
  Result := self.ires;
end;

function TGNLSuministroCombustibleSimple.get_precio_combustible: NReal;
begin
  Result := pa.P_ExtraToP;
end;


function TGNLSuministroCombustibleSimple.get_combustible: TCombustibleSGE;
begin
  Result := self.combustible;
end;


procedure TGNLSuministroCombustibleSimple.RegistrarParametrosDinamicos;
var
  i: integer;
  ficha: TFichaGNLSuministroCombustibleSimple;
begin
  inherited registrarParametrosDinamicos;
  lpd.expandirFichas(globs);
  lpd.RegistrarFichasAActualizar(Self, globs.ActualizadorLPD, @pA, nil,
    TGNLSuministroCombustibleSimple_cambioFichaPD);
  for i := 0 to lpd.Count - 1 do
  begin
    ficha := TFichaGNLSuministroCombustibleSimple(lpd[i]);
    if ficha.indicePreciosPorCombustible <> nil then
      ficha.nroBornePreciosPorCombustible :=
        ficha.indicePreciosPorCombustible.IdBorne(ficha.bornePreciosPorCombustible);
  end;
end;


function TGNLSuministroCombustibleSimple.restricciones_postizadas: boolean;
begin
  Result := False;
end;

procedure TGNLSuministroCombustibleSimple.Free;
begin
  inherited Free;
end;

class function TGNLSuministroCombustibleSimple.DescClase: string;
begin
  Result := 'Suministro Simple con Precio fijo';
end;

procedure TGNLSuministroCombustibleSimple.SorteosDelPaso(sortear: boolean);
var
  fichaActiva: TFichaGNLSuministroCombustibleSimple;
begin
  fichaActiva := pa;
end;


procedure TGNLSuministroCombustibleSimple.PrepararPaso_ps;
begin

  self.VConsumido_Extra_Top := 0;

  if pa.indicePreciosPorCombustible <> nil then
  begin
    cvExtraToP := pa.indicePreciosPorCombustible.bornera[
      pa.nroBornePreciosPorCombustible];
  end
  else
  begin
    cvExtraToP := 0;
  end;

end;

procedure TGNLSuministroCombustibleSimple.opt_nvers(var ivar, ivae, ires: integer);
begin
  self.ivar := ivar; //CAntidad de variables (columnas)
  self.ires := ires;  //Cantidad de restricciones (filas)

  ivar := ivar + 1;
  ires := ires + 1;

  indice_var_ETop := self.ivar;
  indice_res_ETop := self.ires;
end;

procedure TGNLSuministroCombustibleSimple.opt_cargue(s: TSimplex);
var
  i: integer;

begin
{$IFDEF SPXCONLOG}
  spx_NombrarVariables(s);
{$ENDIF}

  s.pon_e(indice_res_ETop, indice_var_ETop, -1);
  //s.pon_e(ires + 1, ivar, -1);



  //VTop <= VDisponible
  //s.pon_e(ires + (globs.NPostes * 2) + 1, ivar + (globs.NPostes * 2) + 1, 1);

  //Aporte a la función de Costo
  s.pon_e(s.nf, indice_var_ETop, -cvExtraToP);
  //  s.pon_e( s.nf, indice_var_ETop + 1 , -cvToP);

  //Termino independiente (vale o o Vtop*Ptop)
  //  s.acum_e( s.nf, s.nc, -cfToP);

  //Cada uno de los generadores conectados debe ser responsable de cargar sus
  //columnas en la restricción de volumen  y en la función de costo objetivo
end;

procedure TGNLSuministroCombustibleSimple.Sim_Cronica_Inicio;
var
  f: integer;
  ficha: TFichaGNLSuministroCombustibleSimple;
begin
  inherited Sim_Cronica_Inicio;
  for  f := 0 to lpd.Count - 1 do
  begin
    ficha := TFichaGNLSuministroCombustibleSimple(lpd.f[f]);
  end;
end;

procedure TGNLSuministroCombustibleSimple.opt_fijarRestriccionesDeCaja(s: TSimplex);
var
  iposte: integer;
  i: integer;
begin
  //Restricción de caudal máximo por poste
  //s.cota_sup_set(ivar, pa.C_Max * globs.HorasDelPaso);
  s.FijarRestriccionIgualdad(ires);
end;

procedure TGNLSuministroCombustibleSimple.opt_leerSolucion(s: TSimplex);
var
  iposte: integer;
begin
  self.VConsumido_Extra_Top := s.xval(indice_var_ETop);
  CostoDirectoDelPaso := cvExtraToP * self.VConsumido_Extra_Top;
end;

procedure TGNLSuministroCombustibleSimple.EvolucionarEstado;
begin
end;

function TGNLSuministroCombustibleSimple.getNombreVar(ivar: integer;
  var nombre: string): boolean;
begin
  if (ivar = indice_var_ETop) then
  begin
    nombre := self.Nombre + '_V_Consumido[' + pa.combustible.Unidades + ']';
    Result := True;
  end
  else
    Result := False;
end;

function TGNLSuministroCombustibleSimple.getNombreRes(ires: integer;
  var nombre: string): boolean;
var
  iposte: integer;
begin
  if ires = indice_res_ETop then
  begin
    nombre := self.Nombre + '_Consumido_Total';
    Result := True;
  end
  else
    Result := False;
end;

procedure TGNLSuministroCombustibleSimple.PubliVars;
var
  unidades: string;
  ficha: TFichaGNLSuministroCombustibleSimple;
  i: NInt;
begin
  inherited PubliVars;

  unidades := self.combustible.Unidades;

  PublicarVariableNR('VConsumido', unidades, 6, 1, VConsumido_Extra_Top, True);
  PublicarVariableNR('CostoDirectoDelPaso', 'USD', 6, 1, costoDirectoDelPaso, True);

end;


procedure TGNLSuministroCombustibleSimple.AfterInstantiation;
begin
  inherited AfterInstantiation;
  pa := nil;
end;


procedure TGNLSuministroCombustibleSimple.optx_nvxs(var ixr, ixd, iauxr, iauxd: integer);
begin
end;

procedure TGNLSuministroCombustibleSimple.PosicionarseEnEstrellita;
begin
end;


procedure TGNLSuministroCombustibleSimple.optx_RegistrarVariablesDeEstado(
  adminEstados: TAdminEstados);
begin
end;


procedure TGNLSuministroCombustibleSimple.opt_PrintResultados_Encab(var fsal: textfile);
begin
end;

procedure TGNLSuministroCombustibleSimple.opt_PrintResultados(var fsal: textfile);
begin
end;

procedure TGNLSuministroCombustibleSimple_cambioFichaPD(Actor: TCosa);
begin
end;

procedure AlInicio;
begin
  registrarClaseDeCosa(TGNLSuministroCombustibleSimple.ClassName,
    TGNLSuministroCombustibleSimple);
  registrarClaseDeCosa(TFichaGNLSuministroCombustibleSimple.ClassName,
    TFichaGNLSuministroCombustibleSimple);
end;

procedure AlFinal;
begin
end;

end.
