//====Modificado metodos: CreateDataColumnList y CreateDataConversionList===
//====Micho@26/5==mvarela@adme.com.uy=======================================
unit uGNLSuministroMultiCliente;

interface

uses
  xMatDefs, uSimplex, uGlobs, uFechas, uEstados,
  uActores, uFichasLPD, UFuentesAleatorias,
  uSuministroCombustible,
  uCosa, uconstantesSimSEE, SysUtils, Classes, UGNLListaContratoSuministro;

type

  { TGNLFichaSuministroMultiCliente }

  TGNLFichaSuministroMultiCliente = class(TFichaSuministroCombustible)

  public
    (**************************************************************************)
    (*               A T R I B U T O S   P E R S I S T E N T E S              *)
    (**************************************************************************)

    Contratos: TGNLListaContratoSuministro;

    (**************************************************************************)

    //Lista de contratos entre proveedores y clientes

    constructor Create(capa: integer; fecha: TFecha; periodicidad: TPeriodicidad; nombrecombustible: string; indicePreciosPorCombustible: TFuenteAleatoria; bornePreciosPorCombustible: string; ListaContratos: TGNLListaContratoSuministro);
     
    constructor Create_ReadFromText(f: TArchiTexto); override;
    procedure WriteToText(f: TArchiTexto); override;
    
    function infoAd_: string; override;
    procedure Free; override;

    



  published
    


  end;


  { TGNLSuministroMultiCliente }

  TGNLSuministroMultiCliente = class(TSuministroCombustible)

  (*
  Esta clase representará posibles suministros de combustible para
  los generadores termicos
  *)

  public
    (**************************************************************************)
    (*               A T R I B U T O S   P E R S I S T E N T E S              *)
    (**************************************************************************)

    pa: TGNLFichaSuministroMultiCliente;

    (**************************************************************************)

    constructor Create(capa: integer; nombre: string; nombreCombustible: string; nacimiento, muerte: TFecha; lpdUnidades, lpd: TFichasLPD); virtual;


    function get_ires_volumen: NInt; virtual; abstract;
    function get_precio_combustible: NReal; virtual; abstract;
    function get_combustible: TCombustibleSGE; virtual; abstract;

     
    constructor Create_ReadFromText(f: TArchiTexto); override;
    procedure WriteToText(f: TArchiTexto); override;
    

    class function TipoFichaLPD: TClaseDeFichaLPD; virtual; abstract;
    //      procedure sim_PrintResultados_Encab_PotFirme(var fsal: textfile; kencab: integer ); virtual;
    //      procedure sim_PrintResultados_PotFirme(var fsal: textfile); virtual;
    procedure Free; override;
    class function DescClase: string; override;


    procedure PrepararMemoria(globs: TGlobs); override;
    procedure RegistrarParametrosDinamicos; override;



    procedure PubliVars; override;


    


  published
    



  end;


procedure AlInicio;
procedure AlFinal;
procedure TGNLSuministroMultiCliente_cambioFichaPD(Actor: TCosa);

implementation

uses Math, uNodos, uGeneradores, UGNLSumIntermedio;


//------------------------------
// Métodos de TFichaSuministroCombustible_TakeOrPay
//==============================
constructor TGNLFichaSuministroMultiCliente.Create(capa: integer; fecha: TFecha; periodicidad: TPeriodicidad; nombrecombustible: string; indicePreciosPorCombustible: TFuenteAleatoria; bornePreciosPorCombustible: string; ListaContratos: TGNLListaContratoSuministro);
begin
  inherited Create(capa, fecha, periodicidad, nombrecombustible,
    indicePreciosPorCombustible, bornePreciosPorCombustible);
  self.Contratos := ListaContratos;
end;

 
constructor TGNLFichaSuministroMultiCliente.Create_ReadFromText(f: TArchiTexto);
begin
  inherited Create_ReadFromText(f);
  contratos := TGNLListaContratoSuministro.Create_ReadFromText(f);
  //    f.IniciarLecturaRetrasada;
  //    f.rd( 'Contratos', TCosa(Contratos));
  //    f.rd('bornePreciosPorCombustible', bornePreciosPorCombustible);
  //    f.EjecutarLectura;

end;

procedure TGNLFichaSuministroMultiCliente.WriteToText(f: TArchiTexto);
begin
  inherited WriteToText(f);
  contratos.WriteToText(f);
  //  f.wrReferencia('Contratos', Contratos);
end;



function TGNLFichaSuministroMultiCliente.infoAd_: string;
begin
  Result := inherited  infoAd_;
  //  result:= 'T_ToP= ' + IntToStr(T_ToP) + 'dias' +
  //           'V_ToP= ' + FloatToStrF(V_ToP, ffGeneral, 10, 1) + ' ' + combustible.Unidades + ', ' +
  //           'P_ToP= ' + FloatToStrF(P_ToP, ffGeneral, 10, 1) + ' USD/' + combustible.Unidades + ', ' +
  //           'P_ExtraToP= ' + FloatToStrF(P_ExtraToP, ffGeneral, 10, 2) + ' USD/' +combustible.Unidades+', ';
end;

procedure TGNLFichaSuministroMultiCliente.Free;
begin
  inherited Free;
end;










//------------------------------
// Métodos de TSuministroCombustible_TakeOrPay
//==============================

constructor TGNLSuministroMultiCliente.Create(capa: integer; nombre: string; nombreCombustible: string; nacimiento, muerte: TFecha; lpdUnidades, lpd: TFichasLPD);
begin
  inherited Create(capa, nombre, nombreCombustible, nacimiento, muerte, lpdUnidades, lpd);
end;

 
constructor TGNLSuministroMultiCliente.Create_ReadFromText(f: TArchiTexto);
var
  nombreCombustible: string;
begin
  inherited Create_ReadFromText(f);
  f.IniciarLecturaRetrasada;
  f.rd('pa', TCosa(pa));
  f.EjecutarLectura;
end;

procedure TGNLSuministroMultiCliente.WriteToText(f: TArchiTexto);
begin
  inherited WriteToText(f);
  //f.wr('combustible', combustible.Nombre);
  f.wr('pa', pa);
end;


procedure TGNLSuministroMultiCliente.PrepararMemoria(globs: TGlobs);
begin
  inherited prepararMemoria(globs);
end;

procedure TGNLSuministroMultiCliente.RegistrarParametrosDinamicos;
begin
  inherited registrarParametrosDinamicos;
end;

procedure TGNLSuministroMultiCliente.Free;
begin
  inherited Free;
end;

class function TGNLSuministroMultiCliente.DescClase: string;
begin
  Result := 'GNL Suministro Combustible Multicliente';
end;


procedure TGNLSuministroMultiCliente.PubliVars;
begin
  inherited PubliVars;
end;









procedure TGNLSuministroMultiCliente_cambioFichaPD(Actor: TCosa);
begin
end;

procedure AlInicio;
begin
  registrarClaseDeCosa(TGNLSuministroMultiCliente.ClassName,
    TGNLSuministroMultiCliente);
  registrarClaseDeCosa(TGNLFichaSuministroMultiCliente.ClassName,
    TGNLFichaSuministroMultiCliente);
end;

procedure AlFinal;
begin
end;

end.
