unit uSuministroCombustible;

interface

uses
  uActores, uFichasLPD, xMatDefs, uFechas, uNodos,
  uGlobs, uGeneradores, uCosa,
  uFuentesAleatorias,
  uconstantesSimSEE, SysUtils,
  uGNLBOG;

type

  TCombustibleSGE = record
    Nombre: string;
    PCI: NReal;
    PCS: NReal;
    kConversion: NReal;
    Unidades: string;
  end;

const
  Combustibles: array[0..6] of TCombustibleSGE =
    (
    (Nombre: 'Gas Oil'; pci: 8620.3479; pcs: 9185.8233; kConversion: 0.000001163;
    Unidades: 'lt'),
    (Nombre: 'Fuel Oil'; pci: 9591.0087; pcs: 10093.7578; kConversion: 0.000001163;
    Unidades: 'lt'),
    (Nombre: 'Fuel Oil Motores'; pci: 9591.0087; pcs: 10093.7578;
    kConversion: 0.000001163; Unidades: 'lt'),
    (Nombre: 'Gas Natural [BTU]'; pci: 1; pcs: 1; kConversion: 0.2931;
    Unidades: 'MMBtu'),
    (Nombre: 'Gas Natural [m3]'; pci: 8400; pcs: 9300; kConversion: 0.000001163;
    Unidades: 'm3'),
    (Nombre: 'Gas N. de Prueba [m3]'; pci: 1; pcs: 1; kConversion: 1; Unidades: 'm3'),
    (Nombre: 'Carbón Mineral'; pci: 7000; pcs: 7000; kConversion: 0.000001163;
    Unidades: 'Kg')
    );


      {*
    (Nombre:'Gas Oil'; pci:1; pcs:1 ; kConversion:1; Unidades:'lt'),
    (Nombre:'Fuel Oil'; pci:1; pcs:1 ; kConversion:1; Unidades:'lt'),
    (Nombre:'Gas Natural [BTU]'; pci:1; pcs:1 ; kConversion:1; Unidades:'MMBtu'),
    (Nombre:'Gas Natural [m3]'; pci:1; pcs:1 ; kConversion:1; Unidades:'m3'),
    (Nombre:'Carbón Mineral'; pci:1; pcs:1 ; kConversion:1; Unidades:'Kg')
    *}

type

  { TFichaSuministroCombustible }

  TFichaSuministroCombustible = class(TFichaLPD)
  public
    indicePreciosPorCombustible: TFuenteAleatoria;
    //Para ajustar los precios de combustible en los períodos T_ToP
    bornePreciosPorCombustible: string;

    nroBornePreciosPorCombustible: integer;

    combustible: TCombustibleSGE;
    //Combustible a utilizar. Esto determina el PCI, las unidades y la constante de conversión
    limites_postizados: boolean;

    constructor Create(capa: integer; fecha: TFecha; periodicidad: TPeriodicidad;
      nombrecombustible: string; indicePreciosPorCombustible: TFuenteAleatoria;
  bornePreciosPorCombustible: string);
     
    constructor Create_ReadFromText(f: TArchiTexto); override;
    procedure WriteToText(f: TArchiTexto); override;
    
    procedure generarLineaResumen(var archi: TextFile); override;
    function infoAd_: string; override;
    procedure Free; override;

    



  published
  




  end;



type

  { TSuministroCombustible }

  TSuministroCombustible = class(TActor)
  (*
  Esta clase representará posibles suministros de combustible para
  los generadores termicos
  *)
  public

  (**************************************************************************)
  (*               A T R I B U T O S   P E R S I S T E N T E S              *)
  (**************************************************************************)

    nombreCombustible: string;
  (**************************************************************************)

    //Combustible a utilizar. Esto determina el PCI, las unidades y la constante de conversión
    combustible: TCombustibleSGE;

    BOG_Calc: TGNLBOG;

    constructor Create(capa: integer; nombre: string; nombreCombustible: string;
      nacimiento, muerte: TFecha; lpdUnidades, lpd: TFichasLPD); virtual;

    function get_VolCombustibleDisponible: NReal; virtual;
    function get_ires_volumen: NInt; virtual; abstract;
    function get_precio_combustible: NReal; virtual; abstract;
    function get_combustible: TCombustibleSGE; virtual; abstract;
    function restricciones_postizadas: boolean; virtual; abstract;

     
    constructor Create_ReadFromText(f: TArchiTexto); override;
    procedure WriteToText(f: TArchiTexto); override;
    

    class function TipoFichaLPD: TClaseDeFichaLPD; virtual; abstract;
    //      procedure sim_PrintResultados_Encab_PotFirme(var fsal: textfile; kencab: integer ); virtual;
    //      procedure sim_PrintResultados_PotFirme(var fsal: textfile); virtual;
    procedure Free; override;
    class function DescClase: string; override;


    procedure PrepararMemoria(globs: TGlobs); override;
    procedure RegistrarParametrosDinamicos; override;


    procedure PubliVars; override;

    



    procedure AfterInstantiation; override;

  published
   


  end;


procedure AlInicio;
procedure AlFinal;

function ObtenerCombustible(nombreCombustible: string): TCombustibleSGE;


implementation

function ObtenerCombustible(nombreCombustible: string): TCombustibleSGE;
var
  i: integer;
begin
  for i := 0 to high(Combustibles) do
  begin
    if (Combustibles[i].Nombre = nombreCombustible) then
      Result := Combustibles[i];
  end;
end;


//------------------------------
// Métodos de TFichaSuministroCombustible_TakeOrPay
//==============================
constructor TFichaSuministroCombustible.Create(capa: integer; fecha: TFecha;
  periodicidad: TPeriodicidad; nombrecombustible: string;
  indicePreciosPorCombustible: TFuenteAleatoria; bornePreciosPorCombustible: string);
var
  i: integer;

begin
  inherited Create(capa, fecha, periodicidad);
  self.combustible := obtenerCombustible(nombreCombustible);
  self.indicePreciosPorCombustible := indicePreciosPorCombustible;
  self.bornePreciosPorCombustible := bornePreciosPorCombustible;
end;



 
constructor TFichaSuministroCombustible.Create_ReadFromText(f: TArchiTexto);
var
  nombreCombustible: string;
begin
  inherited Create_ReadFromText(f);
  f.IniciarLecturaRetrasada;
  f.rdReferencia('indicePreciosPorCombustible',
    TCosa(indicePreciosPorCombustible), self);
  f.rd('bornePreciosPorCombustible', bornePreciosPorCombustible);
  f.EjecutarLectura;
end;


 
procedure TFichaSuministroCombustible.WriteToText(f: TArchiTexto);
begin
  inherited WriteToText(f);
  f.wrReferencia('indicePreciosPorCombustible', indicePreciosPorCombustible);
  f.wr('bornePreciosPorCombustible', bornePreciosPorCombustible);
end;


procedure TFichaSuministroCombustible.generarLineaResumen(var archi: TextFile);
begin
 (* write(archi, '-', #9,                                     //PMín
               FloatToStrF(PMax, formatoReales, 8, 1), #9,  //PMáx
               '-', #9,                                     //CV_Mín
               FloatToStrF(cv, formatoReales, 8, 2), #9,    //CV_Medio
               FloatToStrF(cv, formatoReales, 8, 2), #9,    //CV_Incremental
               FloatToStrF(disp, formatoReales, 8, 2), #9,  //FDisp
               '-', #9,                                     //Costo Arranque
               '-', #9,                                     //Costo Parada
               '-', #9,                                     //mínNPasosOn
               '-', #9,                                     //mínNPasosOff
               '-', #9,                                     //desiciónPasosOnPorCiclo
               '-', #9,                                     //desiciónPasosOffPorCiclo
               '-', #9,                                     //costoPorCicloOn
               '-', #9);                                    //costoPorCicloOff
               *)
end;

function TFichaSuministroCombustible.infoAd_: string;
begin
  inherited;
end;

procedure TFichaSuministroCombustible.Free;
begin
  inherited Free;
end;











constructor TSuministroCombustible.Create(capa: integer; nombre: string;
  nombreCombustible: string; nacimiento, muerte: TFecha; lpdUnidades, lpd: TFichasLPD);

begin
  inherited Create(capa, nombre, nacimiento, muerte, lpdUnidades);
  self.lpd := lpd;
  self.combustible := ObtenerCombustible(nombreCombustible);
end;

 
constructor TSuministroCombustible.Create_ReadFromText(f: TArchiTexto);
var
  nombreCombustible: string;
begin
  inherited Create_ReadFromText(f);
  f.IniciarLecturaRetrasada;
  f.rd('combustible', nombreCombustible);
  f.rd('lpd', TCosa(lpd));
  f.EjecutarLectura;
  self.combustible := ObtenerCombustible(nombreCombustible);
  lpd.Propietario := self;
end;


procedure TSuministroCombustible.PrepararMemoria(globs: TGlobs);
begin
  inherited prepararMemoria(globs);
end;

procedure TSuministroCombustible.RegistrarParametrosDinamicos;
begin
  inherited registrarParametrosDinamicos;
end;

 
procedure TSuministroCombustible.WriteToText(f: TArchiTexto);
begin
  inherited WriteToText(f);
  f.wr('combustible', combustible.Nombre);
  f.wr('lpd', lpd);
end;




procedure TSuministroCombustible.Free;
begin
  self.lpd.Free;
  inherited Free;
end;

function TSuministroCombustible.get_VolCombustibleDisponible: NReal;
begin
  Result := 9999999999;
end;

class function TSuministroCombustible.DescClase: string;
begin
  Result := 'Suministro Combustible';
end;


procedure TSuministroCombustible.PubliVars;
begin
  inherited PubliVars;
end;










procedure TSuministroCombustible.AfterInstantiation;
begin
  inherited AfterInstantiation;
  self.combustible := ObtenerCombustible(nombreCombustible);
end;

procedure AlInicio;
begin
  registrarClaseDeCosa(TSuministroCombustible.ClassName, TSuministroCombustible);
end;

procedure AlFinal;
begin
end;

end.
