unit uej_ayuda;

{$mode delphi}

interface

uses
  Classes, SysUtils,
  ucosa, ucosaconnombre, uConstantesSimSEE, usalasdejuego,
  uejecutor, ueditorsalacmd;


type
    { TEjecutor_ayuda }
  TEjecutor_ayuda = class(TEjecutorDeOrden)
    constructor Create;
    function ejecutar(editor: TRbtEditorSala_cmd; paramLst: TStrings): TStrings; override;
    function ayuda: TStrings; override;
    class procedure Registrarse( EjecutoresLst: TList ); override;
  end;



implementation

{ TEjecutor_ayuda }

constructor TEjecutor_ayuda.Create;
begin
  inherited Create( 'ayuda', 0, 1);
end;


function ListarComandos: TStringList;
var
  res: TStringList;
  s: string;
  k: integer;
  aRec: TEjecutorDeOrden;
begin
  res:= TStringList.Create;
  res.add('---- Lista de comandos --------');

  for k:= 0 to uejecutor.EjecutoresDeOrdenes.Count - 1 do
  begin
    aRec:= TEjecutorDeOrden(uejecutor.EjecutoresDeOrdenes[k] );
    res.Add( aRec.idOrden );
  end;
  res.add('-------------------------');
  res.add('.. para tener ayuda sobre un comando concreto: help comando ');
  result:= res;
end;



function AyudaComando( idOrden: string ): TStrings;
var
  res: TStringList;
  aRec: TEjecutorDeOrden;
begin
  aRec:= uejecutor.EjecutoresDeOrdenes.find( idOrden );
  if aRec = nil then
  begin
    res:= TStringList.Create;
    res.add('Comando desconocido: "'+ idOrden +'"');
    result:= res;
  end
  else
    result:= aRec.ayuda;
end;


function TEjecutor_ayuda.ejecutar(editor: TRbtEditorSala_cmd; paramLst: TStrings): TStrings;
begin
  if (paramLst.count = 0 ) then
    result:= ListarComandos
  else
    result:= AyudaComando( paramLst[0] );
end;

function TEjecutor_ayuda.ayuda: TStrings;
begin
  Result := inherited ayuda;
end;

class procedure TEjecutor_ayuda.Registrarse( EjecutoresLst: TList );
begin
  EjecutoresLst.Add( TEjecutor_ayuda.Create );
end;

initialization
  TEjecutor_ayuda.Registrarse( uejecutor.EjecutoresDeOrdenes );
end.

