unit uej_cargar;

{$mode delphi}

interface

uses
  Classes, SysUtils,
  ucosa, uConstantesSimSEE, usalasdejuego,
  uejecutor, ueditorsalacmd;


type
    { TEjecutor_cargar_sala }
  TEjecutor_cargar_sala = class(TEjecutorDeOrden)
    constructor Create;
    function ejecutar(editor: TRbtEditorSala_cmd; paramLst: TStrings): TStrings; override;
    function ayuda: TStrings; override;
    class procedure Registrarse( EjecutoresLst: TList ); override;
  end;



implementation

{ TEjecutor_Cargar_Sala }

constructor TEjecutor_cargar_sala.Create;
begin
  inherited Create( 'cargar_sala', 1, 1);
end;


function TEjecutor_cargar_sala.ejecutar(editor: TRbtEditorSala_cmd; paramLst: TStrings): TStrings;
var
  res: TStrings;
  f: TArchiTexto;
  archi: string;
  cnt_errores: integer;
  aSala: TSalaDeJuego;

begin
  Res := inherited ejecutar(editor, paramLst);

  cnt_errores:= 0;
  archi := paramLst[0];
  aSala:= nil;

  try
    chdir(extractFilePath(archi));
    f := TArchiTexto.CreateForRead(0, editor.CatalogoReferencias, archi, False);
    try
      f.rd('sala', TCosa( aSala));
    finally
      f.Free;
    end;

    if aSala = nil then
    begin
      inc( cnt_errores );
      werror(res, 'No fue posible cargar la sala del archivo: ' + archi);
    end;

    editor.SetSala( aSala );

    aSala.setDirCorrida(archi);
    if editor.resolverReferenciasContraSala(False) > 0 then
    begin
      inc( cnt_errores );
      werror(res, 'No se pudo resolver todas las asociaciones entre los actores' +
        ' de la sala, por lo que no se cargará. Puede ver la lista de ' +
        'referencias que no pudieron resolverse en el siguiente ' +
        'archivo: ' + getDir_Run + 'errRefs.txt');
    end;

    aSala.Prepararse_( editor.CatalogoReferencias);
    aSala.publicarTodasLasVariables;
    if cnt_errores = 0 then
       wrln(res, 'OK, sala abierta exitosamente.' )
    else
       wrln(res, 'ATENCIÓN, sala abierta con inconvenientes.' );
  finally
  end;
  result:= res;
end;

function TEjecutor_cargar_sala.ayuda: TStrings;
begin
  Result := inherited ayuda;
end;

class procedure TEjecutor_Cargar_Sala.Registrarse( EjecutoresLst: TList );
begin
  EjecutoresLst.Add( TEjecutor_cargar_sala.Create );
end;

initialization
  TEjecutor_cargar_sala.Registrarse( uejecutor.EjecutoresDeOrdenes );
end.

