unit uej_guardar;

{$mode delphi}

interface

uses
  Classes, SysUtils, uejecutor, ueditorsalacmd;


type
  { TEjecutor_guardar_sala
  Admite 0 o 1 parámetro con el archivo de la sala. Si no se pasa parámetro, se guarda
  sobreescribiendo el actual, si la Sala es nueva y no existe un archivo retorna un error.
  'Error: Debe especificar un nombre de archivo'.
  }

  TEjecutor_guardar_sala = class(TEjecutorDeOrden)
    constructor Create;
    function ejecutar( rbt: TRbtEditorSala_cmd; paramLst: TStrings): TStrings; override;
    function ayuda: TStrings; override;
    class procedure Registrarse(EjecutoresLst: TList); override;
  end;

implementation



{ TEjecutor_guardar_sala }

constructor TEjecutor_guardar_sala.Create;
begin
  inherited Create('guardar_sala', 0, 1);
end;

function TEjecutor_guardar_sala.ejecutar(rbt: TRbtEditorSala_cmd;
  paramLst: TStrings): TStrings;
var
  archi: string;

begin
  Result:=inherited ejecutar(rbt, paramLst);
  if paramLst.count > 0 then
    archi:= ParamLst[0]
  else
    archi:= '';
  rbt.Guardar( archi );
end;

function TEjecutor_guardar_sala.ayuda: TStrings;
begin
  Result:=inherited ayuda;
end;


class procedure TEjecutor_guardar_Sala.Registrarse( EjecutoresLst: TList );
begin
  EjecutoresLst.Add( TEjecutor_guardar_sala.Create );
end;


initialization
  TEjecutor_guardar_sala.Registrarse( uejecutor.EjecutoresDeOrdenes );

end.

