unit uej_ls;

{$mode delphi}

interface

uses
  Classes, SysUtils,
  ucosa, ucosaconnombre, uConstantesSimSEE, usalasdejuego,
  uejecutor, ueditorsalacmd;


type
    { TEjecutor_ls }
  TEjecutor_ls = class(TEjecutorDeOrden)
    constructor Create;
    function ejecutar(editor: TRbtEditorSala_cmd; paramLst: TStrings): TStrings; override;
    function ayuda: TStrings; override;
    class procedure Registrarse( EjecutoresLst: TList ); override;
  end;



implementation

{ TEjecutor_ls }

constructor TEjecutor_ls.Create;
begin
  inherited Create( 'ls', 0, 1);
end;


function ListDir( dir_str: string ): TStringList;
var
  res: TStringList;
  Info : TSearchRec;
  s: string;
begin
  res:= TStringList.Create;

  If FindFirst ( dir_str + '*', faAnyFile and faDirectory,Info)=0 then
  begin
    Repeat
        If ( info.Attr and faDirectory) = faDirectory then
          s:= 'dir: '
        else
          s:= '';
        s:= s+info.Name+'  ('+ IntToStr( info.Size ) +')';
      res.add( s );
    Until FindNext(info)<>0;
  end;
  FindClose(Info);
  result:= res;
end;

function TEjecutor_ls.ejecutar(editor: TRbtEditorSala_cmd; paramLst: TStrings): TStrings;
var
  res: TStrings;
  s: string;
  aRecLnk: TCosa_RecLnk;
  aCampoLnk: TCosa_CampoLnk;
  aCosaH: TCosa;
  k: integer;
  aSala: TSalaDeJuego;
begin
  if (paramLst.count > 0 ) then
  begin
    s:= paramLst[0];
    if pos( '/', s ) > 0 then
    begin
      result:= ListDir( s );
      exit;
    end;
  end;

  if editor.LasCosas = nil then
  begin
    aSala:= Editor.getSala;
    if aSala = nil then
    begin
      // ls ./
      s:= './';
      result:= ListDir( s );
      exit;
    end;
  end;


  if editor.LasCosas.Count = 0 then
    editor.LasCosas.add( Editor.getSala );
  editor.LaCosa := editor.LasCosas[ editor.LasCosas.Count - 1];

  aRecLnk := editor.LaCosa.rec_lnk;
  if aRecLnk = nil then
  begin
    wrln(res, 'LaCosa.rec_lnk = NIL !!!!! PROBLEMA');
  end;


  Res := inherited ejecutar(editor, paramLst);
  if paramLst.Count = 0 then
   s:= ''
  else
   s:= paramLst[0];

  if (s = '') then
  begin
    wrln(res, 'Explorando una instancia de:' + Editor.LaCosa.ClassName);
    if aRecLnk <> nil then
    begin
      for k := 0 to aRecLnk.Count - 1 do
      begin
        aCampoLnk := aRecLnk[k];
        wrln(res, IntToStr(k) + ': ' + aCampoLnk.CampoDef.nombreCampo +
          ' (' + aCampoLnk.CampoDef.ClassName + '), = ' + aCampoLnk.StrVal);
      end;
    end
    else
    begin
      // chequeamos si es una Lista de Cosas.
      if editor.LaCosa is TListaDeCosas then
        for k := 0 to TListaDeCosas( editor.LaCosa).Count - 1 do
        begin
          aCosaH := TCosa(TListaDeCosas( editor.LaCosa)[k]);
          if aCosaH is TCosaConNombre then
            wrln(res, IntToStr(k) + ' : ' + (aCosaH as TCosaConNombre).nombre +
              ' (' + aCosaH.ClassName + ')')
          else
            wrln(res, IntToStr(k) + ' : s/n (' + aCosaH.ClassName + ')');
        end;
    end;
  end
  else if (s = 'clases_registradas') then
  begin
    wrln(res, '');
    wrln(res, ListarRegistroDeClases );
  end;
  result:= res;
end;

function TEjecutor_ls.ayuda: TStrings;
begin
  Result := inherited ayuda;
end;

class procedure TEjecutor_ls.Registrarse( EjecutoresLst: TList );
begin
  EjecutoresLst.Add( TEjecutor_ls.Create );
end;

initialization
  TEjecutor_ls.Registrarse( uejecutor.EjecutoresDeOrdenes );
end.

