unit uEditarTDemandaDetallada;
{$MODE Delphi}

interface

uses
  {$IFDEF WINDOWS}
  Windows,
  {$ENDIF}
  Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, StdCtrls, ExtCtrls, Buttons,
  uBaseEditoresActores,
  uBaseEditoresCosasConNombre,
  uSalasDeJuego,
  uCosaConNombre,ucosanubeseable,ucosa,
  utilidades,
  uOpcionesSimSEEEdit,
  uverdoc,
  uConstantesSimSEE,
  xMatDefs,
  udemandadetallada,
  udatoshorariosdetallados,
  uCrearBinDatosHorarios,
  uopencalc,
  uopencalcexportimport,
  uDemandas;

type

  { TEditarTDemandaDetallada }

  TEditarTDemandaDetallada = class(TBaseEditoresActores)
    BAyuda: TButton;
    BCancelar: TButton;
    BCrear: TButton;
    BEditorDeUnidades: TButton;
    BGuardar: TButton;
    btNubesearArchi: TBitBtn;
    CBBorne: TComboBox;
    CBBorneIndicePreciosCombustible: TComboBox;
    CBFuente: TComboBox;
    CBFuenteIndicePreciosPorCombustible: TComboBox;
    CBNodo: TComboBox;
    cbSumarParaPostizar: TCheckBox;
    chkSumarFuentePotencia: TCheckBox;
    cbArchiRef: TComboBox;
    EditNombre: TEdit;
    EditTamTablaFalla: TEdit;
    eFactorReserva: TLabeledEdit;
    EFMuerte: TEdit;
    EFNac: TEdit;
    eTipoDemSpot: TEdit;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    GroupBox3: TGroupBox;
    iconos1: TImageList;
    Label1: TLabel;
    lblBorneFuenteCVF: TLabel;
    lblFuenteCVF: TLabel;
    LBorne: TLabel;
    LFMuerte: TLabel;
    LFNac: TLabel;
    LFuenteDeAportes: TLabel;
    LNarch: TLabel;
    LNEscalones: TLabel;
    LNodo: TLabel;
    LNombre: TLabel;
    Panel1: TPanel;
    OpenDialog1: TOpenDialog;
    Panel2: TPanel;
    Panel3: TPanel;
    Panel4: TPanel;
    sgFalla: TStringGrid;
    Splitter1: TSplitter;

    procedure btNubesearArchiClick(Sender: TObject);
    procedure cbArchiRefChange(Sender: TObject);
    procedure EditEnter(Sender: TObject);
    procedure EditExit(Sender: TObject);
    procedure CBNodoChange(Sender: TObject);
    procedure CBFuenteChange(Sender: TObject);
    procedure CBBorneChange(Sender: TObject);
    procedure EditTamTablaFallaExit(Sender: TObject);
    procedure CBFuenteIndicePreciosPorCombustibleChange(Sender: TObject);
    procedure CBBorneIndicePreciosCombustibleChange(Sender: TObject);
    procedure BCrearClick(Sender: TObject);
    procedure BEditorDeUnidadesClick(Sender: TObject);
    procedure BCancelarClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: boolean);
    procedure BGuardarClick(Sender: TObject); override;
    procedure BAyudaClick(Sender: TObject);
    procedure GroupBox3Click(Sender: TObject);
  public
    constructor Create(AOwner: TComponent; sala: TSalaDeJuego;
      tipoCosa: TClass; cosaConNombre: TCosaConNombre); override;
    function validarFormulario: boolean; override;
  end;

implementation

uses SimSEEEditMain;

  {$R *.lfm}

constructor TEditarTDemandaDetallada.Create(AOwner: TComponent;
  sala: TSalaDeJuego; tipoCosa: TClass; cosaConNombre: TCosaConNombre);
var
  actor: TDemandaDetallada;

  function indice(flg: Boolean) : integer;
  begin
    if flg then
       Result := 9
    else
       Result := 10;
  end;

begin
  inherited Create(AOwner, sala, tipoCosa, cosaConNombre);
  utilidades.AgregarFormatoFecha(LFNac);
  utilidades.AgregarFormatoFecha(LFMuerte);
  if TSimSEEEditOptions.getInstance.fechasAutomaticas then
    inherited ocultarFechas(LFNac, LFMuerte, EFNac, EFMuerte);
  inicializarCBNodos(CBNodo, False);
  inicializarCBArchiRef(cbArchiRef,true);
  inicializarCBFuente(CBFuente, CBBorne, True);
  inicializarCBFuente(CBFuenteIndicePreciosPorCombustible,
    CBBorneIndicePreciosCombustible, True);

  btNubesearArchi.Spacing:=1;
  btNubesearArchi.Width:= 120;
  btNubesearArchi.Height:= 30;
  btNubesearArchi.Visible:= true;

  {$IFNDEF NUBE}
  btNubesearArchi.Enabled := false;
  {$ENDIF}


  if cosaConNombre <> nil then
  begin
    actor := TDemandaDetallada(cosaConNombre);

    EditNombre.Text := actor.nombre;
    EFNac.Text := FSimSEEEdit.fechaIniToString(actor.nacimiento);
    EFMuerte.Text := FSimSEEEdit.fechaFinToString(actor.muerte);
    setCBNodo(CBNodo, actor.Nodo);
    chkSumarFuentePotencia.Checked := actor.SumarEnergiaHr;
    cbSumarParaPostizar.Checked:= actor.flg_SumarParaPostizado;
    eFactorReserva.Text:= FloatToStr( actor.fReserva );
    setCBFuente(CBFuente, CBBorne, actor.fuente, actor.nombreBorne);
    setTablaFalla(sgFalla, EditTamTablaFalla, actor.falla_profundidad,
      actor.falla_costo_0, nil );
    setCBFuente(CBFuenteIndicePreciosPorCombustible, CBBorneIndicePreciosCombustible,
      actor.icf_Fuente, actor.icf_NombreBorne);
    setCBArchiRef(cbArchiRef, actor.ArchiDatos);
    eTipoDemSpot.Text:=FloatToStr(actor.Prioridad_DemSpot);

    indice_icono_nubeseable := indice( actor.ArchiDatos.flg_nubeseable);
    iconos1.GetBitmap(indice_icono_nubeseable,btNubesearArchi.Glyph);  //indice=9    lock    //indice=10   unlock
    if indice_icono_nubeseable=9 then
    begin
      cbArchiRef.Enabled:= false;
      BCrear.Enabled:=false;
    end;
  end
  else
  begin
    cbSumarParaPostizar.checked:= true;
    eFactorReserva.Text:= FloatToStr( 0.0 );
    setTablaFalla(sgFalla, EditTamTablaFalla, ProfundidadEscalonesDeFallaPorDefecto,
      CostoEscalonesDeFallaPorDefecto, nil );
    OpenDialog1.InitialDir := getDir_DatosComunes;
    OpenDialog1.Filter := 'Archivos Binarios (*.bin)|*.bin|Todos los Archivos (*.*)|*.*';
    eTipoDemSpot.Text:= FloatToStr( 0.0 );
    iconos1.GetBitmap(10,btNubesearArchi.Glyph);

  end;
end;

function TEditarTDemandaDetallada.validarFormulario: boolean;
begin
  Result := inherited validarFormulario and inherited  validarNombre(EditNombre) and
    inherited validarEditFecha(EFNac) and inherited validarEditFecha(EFMuerte) and
    inherited validarCBNodo(CBNodo) and inherited validarCBFuente(CBFuente,
    CBBorne, 0) and inherited validarEditInt(EditTamTablaFalla, 0, MAXINT) and
    validarEditFloat( eFactorReserva ) and validarEditFloat( eTipoDemSpot ) and
    inherited validarTablaFalla(sgFalla) and inherited validarCBArchiRef(cbArchiRef)and
    inherited validarCBFuente(CBFuenteIndicePreciosPorCombustible,
    CBBorneIndicePreciosCombustible, 0);
end;


procedure TEditarTDemandaDetallada.BAyudaClick(Sender: TObject);
begin
  uverdoc.verdoc( tipoCosa);
end;

procedure TEditarTDemandaDetallada.GroupBox3Click(Sender: TObject);
begin

end;

procedure TEditarTDemandaDetallada.BCancelarClick(Sender: TObject);
begin
  inherited BCancelarClick(Sender);
end;

procedure TEditarTDemandaDetallada.BCrearClick(Sender: TObject);
var
  form: TCrearBinDatosHorarios;
  archi: string;
  archiref: TArchiRef_Nubeseable;
begin
  if valorCBArchiRef(cbArchiRef)<> nil then
     archi := valorCBArchiRef(cbArchiRef).ArchiRef.archi
  else
     archi :='';

  if not fileexists(archi) then
  begin
    form := TCrearBinDatosHorarios.Create(self, sala.globs.fechaIniOpt.AsDt,
      sala.globs.fechaFinOpt.AsDt);
  end
  else
  begin
    archiref:= TArchiRef_Nubeseable.Create(capa,0,0,false, TArchiRef_.Create(archi));
    form := TCrearBinDatosHorarios.Create_(self, archiref );
  end;

  if form.ShowModal = mrOk then
  begin
    archi:=form.darNombreArch ;
    archiref:= valorCBArchiRef(cbArchiRef);
    if archiref <> nil then
       valorCBArchiRef(cbArchiRef).ArchiRef.archi := archi
    else
       archiref:= agregarArchiRef(archi);
    inicializarCBArchiRef(cbArchiRef,true);
    setCBArchiRef(cbArchiRef,archiref);
  end;
  form.Free;

end;

procedure TEditarTDemandaDetallada.BEditorDeUnidadesClick(Sender: TObject);
begin
  inherited BEditorDeUnidadesClick(Sender);
end;


procedure TEditarTDemandaDetallada.BGuardarClick(Sender: TObject);
var
  actor: TDemandaDetallada;
  archiref: string;
begin
  if validarFormulario then
  begin
    archiref:= valorCBArchiRef(cbArchiRef).ArchiRef.archi;
    if cosaConNombre = nil then
    begin
       cosaConNombre := TDemandaDetallada.Create(
        capa, EditNombre.Text, FSimSEEEdit.StringToFecha(EFNac.Text),
        FSimSEEEdit.StringToFecha(EFMuerte.Text), lpdUnidades,
        valorCBNodo(CBNodo), getFallaProfundidad(sgFalla),
        getFallaCosto(sgFalla), archiref, valorCBFuente(CBFuente),
        valorCBString(CBBorne), chkSumarFuentePotencia.Checked,
        cbSumarParaPostizar.checked,
        valorCBFuente(CBFuenteIndicePreciosPorCombustible),
        valorCBString(CBBorneIndicePreciosCombustible),
        StrToFloat( eFactorReserva.Text ),
        StrToInt( eTipoDemSpot.Text ), nil, '');
      actor := TDemandaDetallada(cosaConNombre);
    end
    else
    begin
      actor := TDemandaDetallada(cosaConNombre);
      actor.nombre := EditNombre.Text;
      actor.nacimiento.PonerIgualA(EFNac.Text);
      actor.muerte.PonerIgualA(EFMuerte.Text);
      actor.lpdUnidades.Free;
      actor.lpdUnidades := lpdUnidades;
      actor.Nodo := valorCBNodo(CBNodo);
      actor.falla_profundidad := getFallaProfundidad(sgFalla);
      actor.falla_costo_0 := getFallaCosto(sgFalla);
      actor.ArchiDatos := valorCBArchiRef(cbArchiRef);
      actor.fuente := valorCBFuente(CBFuente);
      actor.nombreBorne := valorCBString(CBBorne);
      actor.SumarEnergiaHr := chkSumarFuentePotencia.Checked;
      actor.flg_SumarParaPostizado:= cbSumarParaPostizar.checked;
      actor.fReserva:= StrToFloat( eFactorReserva.Text );
      actor.icf_Fuente := valorCBFuente(CBFuenteIndicePreciosPorCombustible);
      actor.icf_NombreBorne := valorCBString(CBBorneIndicePreciosCombustible);
      actor.Prioridad_DemSpot:= StrToInt( eTipoDemSpot.Text );
    end;
    actor.lpdForzamientos := lpdForzamientos_;
    ModalResult := mrOk;
  end;
end;

procedure TEditarTDemandaDetallada.CBBorneChange(Sender: TObject);
begin
  inherited CBBorneChange(CBFuente, CBBorne);
end;

procedure TEditarTDemandaDetallada.CBBorneIndicePreciosCombustibleChange(
  Sender: TObject);
begin
  inherited CBBorneChange(CBFuenteIndicePreciosPorCombustible,
    CBBorneIndicePreciosCombustible);
end;

procedure TEditarTDemandaDetallada.CBFuenteChange(Sender: TObject);
begin
  inherited CBFuenteChange(Sender, CBBorne);
end;

procedure TEditarTDemandaDetallada.CBFuenteIndicePreciosPorCombustibleChange(
  Sender: TObject);
begin
  inherited CBFuenteChange(Sender, CBBorneIndicePreciosCombustible);
end;

procedure TEditarTDemandaDetallada.CBNodoChange(Sender: TObject);
begin
  inherited CBNodoChange(Sender, True);
end;

procedure TEditarTDemandaDetallada.EditEnter(Sender: TObject);
begin
  inherited EditEnter(Sender);
end;



procedure TEditarTDemandaDetallada.btNubesearArchiClick(Sender: TObject);
var
  nid_version, nid_data, buttonSelected: integer;
  nueva_version: Boolean;
  i:integer;
  archi: TArchiRef_;
begin
  //indice=9    lock
  //indice=10   unlock
  {archi := TArchiRef_.Create(ENarch.Text); }

  if indice_icono_nubeseable=9 then
  begin
     buttonSelected := messagedlg('Esta seguro que quiere desbloquear este actor',mtConfirmation, mbOKCancel, 0);

     if buttonSelected = mrOK then
     begin
     guardado := False;
     indice_icono_nubeseable:=10;
     if cosaEditable is TDemandaDetallada then
       if TDemandaDetallada(cosaEditable).ArchiDatos.flg_nubeseable then
          TDemandaDetallada(cosaEditable).ArchiDatos.flg_nubeseable:= false;
       //desplegar mensaje de advertencia de que se esta rompiendo el candado
     cbArchiRef.Enabled:= true;
     BCrear.Enabled:=true;
     cbArchiRef.Enabled:=true;
     end;
  end
  else
  begin
     buttonSelected := messagedlg('Esta seguro que quiere insertar este actor  a la Nube',mtConfirmation, mbOKCancel, 0);

     if buttonSelected = mrOK then
     begin
      guardado := False;
      nid_data := TDemandaDetallada(cosaEditable).ArchiDatos.nid;
      nueva_version := true;
      if nid_data=0 then
         nueva_version := false;

     nid_version:= TDemandaDetallada(cosaEditable).ArchiDatos.NubesearArchi
                   (nueva_version,nid_data,0,'');

     if nid_version <> -1 then
     begin
       setCBArchiRef(cbArchiRef, TDemandaDetallada(cosaEditable).ArchiDatos);
       indice_icono_nubeseable:=9;
       cbArchiRef.Enabled:= false;
       BCrear.Enabled:=false;
       cbArchiRef.Enabled:=false;
     end;

     end;
  end;
  iconos1.GetBitmap(indice_icono_nubeseable,btNubesearArchi.Glyph);


end;

procedure TEditarTDemandaDetallada.cbArchiRefChange(Sender: TObject);
begin
  inherited cbArchiRefChange(Sender, true);
end;

procedure TEditarTDemandaDetallada.EditExit(Sender: TObject);
begin
  inherited EditExit(Sender);
end;

procedure TEditarTDemandaDetallada.EditTamTablaFallaExit(Sender: TObject);
begin
  inherited EditTamTablaFallaExit(Sender, sgFalla, nil );
end;

procedure TEditarTDemandaDetallada.FormCloseQuery(Sender: TObject;
  var CanClose: boolean);
begin
  inherited FormCloseQuery(Sender, CanClose);
end;

end.
