unit uFormLogin;

{$mode delphi}

interface

uses
  Classes, SysUtils, FileUtil, Forms,
  Controls, Graphics,
  unubeseable,unotificar,urosx, uConstantesSimSEE,
  Dialogs, StdCtrls, ExtCtrls;

type

  { TFormLogin }

  TFormLogin = class(TForm)
    BtIngresar: TButton;
    btProbarGuardar: TButton;
    cb_recordar_clave_proxy: TCheckBox;
    cb_recordar_clave_simsee: TCheckBox;
    eClaveSimSEE: TEdit;
    eproxy_host: TEdit;
    eproxy_pass: TEdit;
    eproxy_puerto: TEdit;
    eproxy_user: TEdit;
    eUsuarioSimSEE: TEdit;
    GBingresar: TGroupBox;
    gb_ProxyParams: TGroupBox;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label7: TLabel;
    Label9: TLabel;
    memo_login: TMemo;
    panel_login: TPanel;
    panel_resultado_login: TPanel;
    procedure BtIngresarClick(Sender: TObject);
    procedure btProbarGuardarClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private

  public
    login_ok: boolean;
    procedure saveconfig;
    procedure LoadConfig;
  end;

var
  FormLogin: TFormLogin;

implementation

{$R *.lfm}

{ TFormLogin }

procedure TFormLogin.BtIngresarClick(Sender: TObject);
var
  usuario, clave: string;
  k: integer;

begin
  usuario:= trim( eUsuarioSimSEE.text );
  clave:= trim( eClaveSimSEE.text );
  saveconfig;
  if nubeAdmin.Login(usuario,clave) then
  begin
    login_ok:= true;
    panel_resultado_login.Caption:='Login correcto';
    panel_resultado_login.Color:= clLime;
    panel_resultado_login.BringToFront;
    panel_resultado_login.Show;
    Application.ProcessMessages;
    Sleep( 1000 );
    modalresult:= mrOk;
  end
  else
  begin
      panel_resultado_login.Caption:='Login incorrecto';
      panel_resultado_login.BringToFront;
      panel_resultado_login.Color:= clRed;
      panel_resultado_login.Show;
      for k:= 5 downto 1 do
      begin
        panel_resultado_login.Caption:='Login incorrecto. ('+IntToStr( k )+')';
        Application.ProcessMessages;
        Sleep( 1000 );
      end;
      panel_login.BringToFront;
      panel_login.Show;
      Application.ProcessMessages;
  end;
end;

procedure TFormLogin.btProbarGuardarClick(Sender: TObject);
var
  hora: string;
begin
  {$IFDEF PROXY_ENABLED_ROS}
  dbcon_rosx.proxy_host:= trim( eproxy_host.text );
  dbcon_rosx.proxy_port:= trim( eproxy_puerto.text );
  dbcon_rosx.proxy_user:= trim( eproxy_user.text );
  dbcon_rosx.proxy_pass:= trim( eproxy_pass.text );
  {$ENDIF}
  unotificar.esperando_inicio('... intentando conexión con servidor...');
  hora:= dbcon_rosx.sql_func( 'SELECT now() FROM nube_simsee LIMIT 1 ' );
  if hora <> '' then
  begin
    memo_login.Lines.add('Se ha conectado correctamente al servidor');
    memo_login.lines.add(' .. la hora del servidor es: '+hora );
    saveconfig;
  end
  else
  begin
    memo_login.Lines.add('FALLO INTENTO DE CONEXIÓN' );
  end;
  unotificar.esperando_fin;

end;

procedure TFormLogin.FormCreate(Sender: TObject);
begin
  LoadConfig;
  login_ok:=false;
  self.LoadConfig;
  GBingresar.visible:= true;
  memo_login.Visible:= true;
  {$IFDEF PROXY_ENABLED_ROS}
  gb_ProxyParams.visible:= true;
  {$ENDIF}
end;


procedure TFormLogin.saveconfig;
var
  fconfig: textfile;
begin
  assignfile( fconfig, getDir_Bin+'nube.cfg' );
  rewrite( fconfig );
  writeln( fconfig, 1); // versión del archivo
  writeln( fconfig, barullar( eUsuarioSimSEE.text ));
  if cb_recordar_clave_simsee.Checked then
   writeln( fconfig, barullar( eClaveSimSEE.text ))
  else
   writeln( fconfig, '' );
  {$IFDEF PROXY_ENABLED_ROS}
  writeln( fconfig, barullar(dbcon_rosx.proxy_host ));
  writeln( fconfig, barullar(dbcon_rosx.proxy_port ));
  writeln( fconfig, barullar(dbcon_rosx.proxy_user ));
  if cb_recordar_clave_proxy.Checked then
   writeln( fconfig, barullar(dbcon_rosx.proxy_pass ))
  else
   writeln( fconfig, '');
  {$ENDIF}

  if cb_recordar_clave_proxy.checked then
    writeln( fconfig, barullar( '1' ) )
  else
   writeln( fconfig, barullar( '0' ) );

  if cb_recordar_clave_simsee.checked then
    writeln( fconfig, barullar( '1' ) )
  else
   writeln( fconfig, barullar( '0' ) );

  closefile( fconfig );
end;


procedure TFormLogin.LoadConfig;
var
  fconfig: textfile;
  version: integer;
  pal: string;
  archi: string;

function getpal: string;
begin
  if not eof( fconfig ) then
  begin
    readln( fconfig, pal );
    result:= desbarullar( pal )
  end
  else
    result:= '';
end;

begin
  archi := getDir_Bin+'nube.cfg' ;
  if fileexists( archi ) then
  begin
    assignfile( fconfig, archi );
    reset( fconfig );
    readln( fconfig, version ); // versión del archivo
    eUsuarioSimSEE.text:= getpal;
    eClaveSimSEE.text:= getpal;
    eproxy_host.text:= getpal;
    eproxy_puerto.text:= getpal;
    eproxy_user.text:= getpal;
    eproxy_pass.text:= getpal;
    cb_recordar_clave_proxy.checked := getpal = '1';
    cb_recordar_clave_simsee.checked := getpal = '1';
    closefile( fconfig );
  end;
end;



end.

