unit uBaseEditoresFichasGeneradores;

{$MODE Delphi}
interface

uses
  {$IFDEF WINDOWS}
  Windows,
  {$ENDIF}
  Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, uBaseEditoresFichas, StdCtrls, xMatDefs;

type
  TBaseEditoresFichasGeneradores = class(TBaseEditoresFichas)
    procedure CBRestrClick(Sender: TObject; Edit: TEdit);
    procedure CBRestrClick_etiqueta(Sender: TObject; etiqueta: TLabel);
  private
    { Private declarations }
  protected
    function validarRestriccion(CB: TCheckBox; Edit: TEdit; min, max: NReal): boolean;
    procedure initCBRestriccion(hayRest: boolean; CB: TCheckBox;
      valor: NReal; Edit: TEdit);
    function rest(CB: TCheckBox; Edit: TEdit; valSiFalso: NReal): NReal;
  public
    { Public declarations }
  end;

var
  BaseEditoresFichasGeneradores: TBaseEditoresFichasGeneradores;

implementation

  {$R *.lfm}

function TBaseEditoresFichasGeneradores.validarRestriccion(CB: TCheckBox;
  Edit: TEdit; min, max: NReal): boolean;
begin
  if CB.Checked then
    Result := validarEditFloat(Edit, min, max)
  else
    Result := True;
end;

procedure TBaseEditoresFichasGeneradores.initCBRestriccion(hayRest: boolean;
  CB: TCheckBox; valor: NReal; Edit: TEdit);

var
  valr: NReal;
  rescod: integer;
begin
  CB.Checked := hayRest;
  if hayRest then
    Edit.Text := FloatToStr(valor)
  else
  begin
    val( edit.text, valr, rescod );
    if rescod <> 0 then
      Edit.Text := FloatToStr( valor );
  end;
  Edit.Enabled := CB.Checked;
  guardado := True;
end;

function TBaseEditoresFichasGeneradores.rest(CB: TCheckBox; Edit: TEdit;
  valSiFalso: NReal): NReal;
var
  rescod: integer;
  s: string;
  res: NReal;
begin
  if CB.Checked then
    Result := StrToFloat(Edit.Text)
  else
  begin
    s:= Edit.text;
    val( s, res, rescod );
    if rescod = 0 then
     result:= res
    else
     Result := valSiFalso;
  end;
end;

procedure TBaseEditoresFichasGeneradores.CBRestrClick(Sender: TObject; Edit: TEdit);
begin
  edit.Enabled := TCheckBox(Sender).Checked;
  guardado := False;
end;

procedure TBaseEditoresFichasGeneradores.CBRestrClick_etiqueta(Sender: TObject; etiqueta: TLabel);
begin
  etiqueta.Enabled := TCheckBox(Sender).Checked;
  guardado := False;
end;


end.
