unit uAltaEdicionTPrintCronVar_CompararValoresMultiplesCronVars;

{$MODE Delphi}
interface

uses
  SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, uBaseFormularios, uBaseAltaEdicionPrintCronVars, StdCtrls,
  Grids, uPrintCronVars,
  uLectorSimRes3Defs,
  utilidades,
  uConstantesSimSEE, uOpcionesSimSEEEdit,
  xMatDefs, uverdoc, ExtCtrls, uPrint, uHistoVarsOps, Menus;

type
  { TAltaEdicionPrintCronVar_CompararValoresMultiplesCronVars }
  TAltaEdicionPrintCronVar_CompararValoresMultiplesCronVars =
    class(TBaseAltaEdicionPrintCronVars)
    BAgregar: TButton;
    BAuto: TButton;
    BAyuda: TButton;
    bCancelar: TButton;
    bGuardar: TButton;
    cbCronVar: TRadioButton;
    cbCronVars: TComboBox;
    cbCronVarEjex: TComboBox;
    cbGraficar: TCheckBox;
    cbMaxEjeYAuto_eje1: TCheckBox;
    cbMaxEjeYAuto_eje2: TCheckBox;
    cbMinEjeYAuto_eje1: TCheckBox;
    cbMinEjeYAuto_eje2: TCheckBox;
    cbPE: TRadioButton;
    cbPreOrdenar: TCheckBox;
    cbTiempo: TRadioButton;
    eDecimales_eje1: TEdit;
    eDecimales_eje2: TEdit;
    eDigitos_eje1: TEdit;
    eDigitos_eje2: TEdit;
    eMaxEjeY_eje1: TEdit;
    eMaxEjeY_eje2: TEdit;
    eMinEjeY_eje1: TEdit;
    eMinEjeY_eje2: TEdit;
    eNombreHoja: TEdit;
    ePE: TEdit;
    ePE1: TEdit;
    eTitulo: TEdit;
    eTitulo_eje1: TEdit;
    eTitulo_eje2: TEdit;
    gbEjeYPrimario: TGroupBox;
    gbEjeYSecundario: TGroupBox;
    GroupBox1: TGroupBox;
    eTitulo_ejeX: TLabeledEdit;
    lblFormato_eje1: TLabel;
    lblFormato_eje2: TLabel;
    lColor: TLabel;
    lCronVar: TLabel;
    lMaxEjeY_eje1: TLabel;
    lMaxEjeY_eje2: TLabel;
    lMinEjeY_eje1: TLabel;
    lMinEjeY_eje2: TLabel;
    lNombreHoja: TLabel;
    lPE: TLabel;
    lPE1: TLabel;
    lTitulo: TLabel;
    lUnidades: TLabel;
    lUnidades_eje2: TLabel;
    Panel1: TPanel;
    RGEje: TRadioGroup;
    RGEjex: TGroupBox;
    RGTipoGrafico: TRadioGroup;
    RGValoresAComparar: TRadioGroup;
    sgColor: TStringGrid;
    sgCronVars: TStringGrid;
    ColorDialog1: TColorDialog;
    procedure cbCronVarChange(Sender: TObject);
    procedure cbCronVarEjexChange(Sender: TObject);
    procedure cbMaxEjeYAuto_eje2Click(Sender: TObject);
    procedure cbMinEjeYAuto_eje2Click(Sender: TObject);
    procedure EditEnter(Sender: TObject);
    procedure EditStringExit(Sender: TObject);
    procedure eDigitos_eje1Exit(Sender: TObject);
    procedure eDecimales_eje1Exit(Sender: TObject);
    procedure cbCronVarsChange(Sender: TObject);
    procedure BAgregarClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure RGTodasCronicasClick(Sender: TObject);

    procedure RGEjexClick(Sender: TObject);

    procedure sgCronVarsMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: integer);
    procedure sgCronVarsMouseMove(Sender: TObject; Shift: TShiftState;
      X, Y: integer);
    procedure sgCronVarsMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: integer);
    procedure bCancelarClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: boolean);
    procedure BGuardarClick(Sender: TObject); override;
    procedure BAyudaClick(Sender: TObject);
    procedure cbMinEjeYAuto_eje1Click(Sender: TObject);
    procedure cbMaxEjeYAuto_eje1Click(Sender: TObject);
    procedure EditFloatExit(Sender: TObject);
    procedure cbGraficarClick(Sender: TObject);
    procedure cambiosForm(Sender: TObject);
    procedure RGValoresACompararClick(Sender: TObject);

    procedure sgCronVarsDrawCell(Sender: TObject; ACol, ARow: integer;
      Rect: TRect; State: TGridDrawState);
    procedure sgColorDrawCell(Sender: TObject; ACol, ARow: integer;
      Rect: TRect; State: TGridDrawState);
    procedure sgColorMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: integer);
    procedure sgColorMouseMove(Sender: TObject; Shift: TShiftState; X, Y: integer);
    procedure sgColorMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: integer);
    procedure BAutoClick(Sender: TObject);
  private
    coloresAgregar: TDAOfColores;
    tiposColsColoresAgregar: TDAOfTTipoColumna;

    coloresSGCronVars: TDAOfColores;

    tiposColsSGCronVars: TDAOfTTipoColumna;
  protected
    function validarFormulario: boolean; override;
  public
    constructor Create(AOwner: TComponent; lector: TLectorSimRes3Defs;
      printCronVar: TPrintCronVar; tipoPrintCronVar: TClaseDePrintCronVar); override;
  end;

function setEjex(var cb: TRadioButton; ejex: TTipoVariableDelEje): TTipoVariableDelEje;


implementation

uses SimSEEEditMain;

  {$R *.lfm}

procedure TAltaEdicionPrintCronVar_CompararValoresMultiplesCronVars.BAgregarClick(
  Sender: TObject);
begin
  inherited addSGCronVarTipoGraficoEjeColor(sgCronVars, cbCronVars,
    RGTipoGrafico, RGEje, sgColor, ColorDialog1, BAuto, BAgregar, coloresSGCronVars);
end;

procedure TAltaEdicionPrintCronVar_CompararValoresMultiplesCronVars.FormCreate(
  Sender: TObject);
begin
  inherited;
  self.cambiosForm(Sender);
end;

procedure TAltaEdicionPrintCronVar_CompararValoresMultiplesCronVars.RGTodasCronicasClick
  (Sender: TObject);
begin

end;


procedure TAltaEdicionPrintCronVar_CompararValoresMultiplesCronVars.RGEjexClick(
  Sender: TObject);
begin
  inherited cambiosForm(Sender);
end;


procedure TAltaEdicionPrintCronVar_CompararValoresMultiplesCronVars.BAutoClick(
  Sender: TObject);
begin
  inherited bColorAutoClick(BAuto, sgColor, ColorDialog1, coloresAgregar);
end;

procedure TAltaEdicionPrintCronVar_CompararValoresMultiplesCronVars.BAyudaClick(
  Sender: TObject);
begin
  uverdoc.verdoc(TPrintCronVar_compararValoresMultiplesCronVars);
end;

procedure TAltaEdicionPrintCronVar_CompararValoresMultiplesCronVars.bCancelarClick(
  Sender: TObject);
begin
  inherited bCancelarClick(Sender);
end;

procedure TAltaEdicionPrintCronVar_CompararValoresMultiplesCronVars.bGuardarClick(
  Sender: TObject);
var
  i: integer;
  printCronVarCast: TPrintCronVar_compararValoresMultiplesCronVars;

  minEjeYAuto_eje1, maxEjeYAuto_eje1: boolean;
  minEjeY_eje1, maxEjeY_eje1: NReal;

  minEjeYAuto_eje2, maxEjeYAuto_eje2: boolean;
  minEjeY_eje2, maxEjeY_eje2: NReal;

  tipoValoresAComparar: TTipoValoresAComparar;
  probExcedencia: NReal;
  pre_Ordenar: boolean;
  probExcedencia_Sup: NReal;
  ejex: TTipoVariableDelEje;
  cronVarsEjex: TCronVar;
  cronVars: TDAOfCronVar;
  tiposGraficos: TDAOfTTipoGrafico;
  tiposEjes: TDAOfTTipoEje;
  colores: TDAOfTColor;
begin
  if validarFormulario then
  begin
    // Mínimo del eje Y1
    valoresEditFloatCondicional(cbMinEjeYAuto_eje1, eMinEjeY_eje1,
      False, minEjeYAuto_eje1, minEjeY_eje1);
    // Máximo del eje Y1
    valoresEditFloatCondicional(cbMaxEjeYAuto_eje1, eMaxEjeY_eje1,
      False, maxEjeYAuto_eje1, maxEjeY_eje1);

    // Mínimo del eje Y2
    valoresEditFloatCondicional(cbMinEjeYAuto_eje2, eMinEjeY_eje2,
      False, minEjeYAuto_eje2, minEjeY_eje2);
    // Máimo del eje Y2
    valoresEditFloatCondicional(cbMaxEjeYAuto_eje2, eMaxEjeY_eje2,
      False, maxEjeYAuto_eje2, maxEjeY_eje2);

    tipoValoresAComparar := TTipoValoresAComparar(RGValoresAComparar.ItemIndex);
    if cbTiempo.Checked then
    begin
      ejex := tiempo;
      cronVarsEjex := nil;
    end
    else if cbPE.Checked then
    begin
      ejex := PE;
      cronVarsEjex := nil;
    end
    else if cbCronVar.Checked then
    begin
      ejex := CronVar;
      for i := 0 to lector.lstCronVars.Count - 1 do
        if TCronVar(lector.lstCronVars[i]).nombre =
          valorCBString(cbCronVarEjex) then
          cronVarsEjex := TCronVar(lector.lstCronVars[i]);
    end;

    probExcedencia := StrToFloat(ePE.Text);
    probExcedencia_Sup := StrToFloat(ePE1.Text);
    pre_Ordenar := cbPreOrdenar.Checked;

    valorSGCronVarTipoGraficoEjeColor(sgCronVars, cronVars, tiposGraficos,
      tiposEjes, colores, coloresSGCronVars);

    if printCronVar = nil then
      printCronVar := TPrintCronVar_compararValoresMultiplesCronVars.Create(
        valorSGCronVar(sgCronVars), eNombreHoja.Text, eTitulo.Text,
        eTitulo_eje1.Text, StrToInt(eDigitos_eje1.Text),
        StrToInt(eDecimales_eje1.Text), tipoValoresAComparar,
        probExcedencia,
        eTitulo_ejeX.Text,
        ejex, cronVarsEjex,
        Pre_Ordenar, ProbExcedencia_Sup, cbGraficar.Checked, tiposGraficos,
        tiposEjes, colores, minEjeYAuto_eje1, maxEjeYAuto_eje1,
        minEjeY_eje1, maxEjey_eje1, eTitulo_eje2.text,
        StrToInt( eDigitos_eje2.text ),
        StrToInt( eDecimales_eje2.text ),
        minEjeYAuto_eje2, maxEjeYAuto_eje2, minEjeY_eje2, maxEjeY_eje2 )
    else
    begin
      printCronVarCast := TPrintCronVar_compararValoresMultiplesCronVars(printCronVar);
      printCronVarCast.nombreHoja := eNombreHoja.Text;
      printCronVarCast.titulo := eTitulo.Text;
      printCronVarCast.titulo_eje1 := eTitulo_eje1.Text;
      printCronVarCast.digitos_eje1 := StrToInt(eDigitos_eje1.Text);
      printCronVarCast.decimales_eje1 := StrToInt(eDecimales_eje1.Text);
      printCronVarCast.cronVars := valorSGCronVar(sgCronVars);
      printCronVarCast.tipoValorAComparar := tipoValoresAComparar;
      printCronVarCast.probExcedencia := probExcedencia;
      printCronVarCast.titulo_ejeX:= eTitulo_ejeX.text;
      printCronVarCast.ejex := ejex;
      printCronVarCast.cronVarEjex := cronVarsEjex;
      printCronVarCast.Pre_Ordenar := pre_Ordenar;
      printCronVarCast.ProbExcedencia_Sup := probExcedencia_Sup;
      printCronVarCast.graficar := cbGraficar.Checked;
      printCronVarCast.tiposGraficos := tiposGraficos;
      printCronVarCast.ejes := tiposEjes;
      printCronVarCast.colores := colores;
      printCronVarCast.minEjeYAuto_eje1 := minEjeYAuto_eje1;
      printCronVarCast.minEjeY_eje1 := minEjeY_eje1;
      printCronVarCast.maxEjeYAuto_eje1 := maxEjeYAuto_eje1;
      printCronVarCast.maxEjeY_eje1 := maxEjeY_eje1;

      printCronVarCast.titulo_eje2:= eTitulo_eje2.text;
      printCronVarCast.Digitos_eje2 := StrToInt( eDigitos_eje2.text );
      printCronVarCast.Decimales_eje2 := StrToInt( eDecimales_eje2.text );
      printCronVarCast.minEjeYAuto_eje2:= minEjeYAuto_eje2;
      printCronVarCast.maxEjeYAuto_eje2:= maxEjeYAuto_eje2;
      printCronVarCast.minEjeY_eje2:= minEjeY_eje2;
      printCronVarCast.maxEjeY_eje2:= maxEjeY_eje2;
    end;
    modalResult := mrOk;
  end;
end;

procedure TAltaEdicionPrintCronVar_CompararValoresMultiplesCronVars.cambiosForm(
  Sender: TObject);
begin
  inherited cambiosForm(Sender);

  if self.RGTipoGrafico.ItemIndex = 0 then
  begin
    self.RGEje.ItemIndex := 0;
    self.RGEje.Enabled := False;
  end
  else
    self.RGEje.Enabled := True;

end;

procedure TAltaEdicionPrintCronVar_CompararValoresMultiplesCronVars.cbCronVarsChange(
  Sender: TObject);
begin
  inherited cbCronVarChange(Sender, False);
end;

procedure TAltaEdicionPrintCronVar_CompararValoresMultiplesCronVars.cbGraficarClick(
  Sender: TObject);
begin
  inherited cbChartMatClick(Sender, cbGraficar, cbMinEjeYAuto_eje1,
    cbMaxEjeYAuto_eje1, lMinEjeY_eje1,
    lMaxEjeY_eje1, eMinEjeY_eje1, eMaxEjeY_eje1);
  RGTipoGrafico.Enabled := cbGraficar.Checked;
  RGEje.Enabled := cbGraficar.Checked;
end;

procedure TAltaEdicionPrintCronVar_CompararValoresMultiplesCronVars.
cbMaxEjeYAuto_eje1Click(Sender: TObject);
begin
  inherited CBEditFloatCondicionalClick(cbMaxEjeYAuto_eje1, lMaxEjeY_eje1,
    eMaxEjeY_eje1, False);
end;

procedure TAltaEdicionPrintCronVar_CompararValoresMultiplesCronVars.
cbMinEjeYAuto_eje1Click(Sender: TObject);
begin
  inherited CBEditFloatCondicionalClick(cbMinEjeYAuto_eje1, lMinEjeY_eje1,
    eMinEjeY_eje1, False);
end;

constructor TAltaEdicionPrintCronVar_CompararValoresMultiplesCronVars.Create(
  AOwner: TComponent; lector: TLectorSimRes3Defs; printCronVar: TPrintCronVar;
  tipoPrintCronVar: TClaseDePrintCronVar);
var
  printCronVarCast: TPrintCronVar_compararValoresMultiplesCronVars;
begin
  inherited Create(AOwner, lector, printCronVar, tipoPrintCronVar);

  inicializarSGCronVarTipoGraficoEjeColor(
    sgCronVars, tiposColsSGCronVars, tiposColsColoresAgregar, cbCronVars, cbCronVarEjex,
    RGTipoGrafico, RGEje, sgColor,
    ColorDialog1, BAuto, coloresAgregar, BAgregar);

  if printCronVar <> nil then
  begin
    printCronVarCast := TPrintCronVar_compararValoresMultiplesCronVars(printCronVar);
    eNombreHoja.Text := printCronVarCast.nombreHoja;
    eTitulo.Text := printCronVarCast.titulo;


    setSGCronVarTipoGraficoEjeColor(sgCronVars, printCronVarCast.cronVars,
      printCronVarCast.tiposGraficos, printCronVarCast.ejes,
      printCronVarCast.colores, cbCronVars,
      RGTipoGrafico, RGEje, sgColor, ColorDialog1, BAuto,
      BAgregar, coloresSGCronVars);

    //    setRGString(RGValoresAComparar, TTipoValoresACompararToString(printCronVarCast.tipoValorAComparar));
    RGValoresAComparar.ItemIndex := Ord(printCronVarCast.tipoValorAComparar);
    ePE.Text := FloatToStr(printCronVarCast.probExcedencia);
    ePE1.Text := FloatToStr(printCronVarCast.ProbExcedencia_Sup);
    cbPreOrdenar.Checked := printCronVarCast.Pre_Ordenar;

    RGValoresACompararClick(nil);

    case printCronVarCast.ejex of
      tiempo: cbTiempo.Checked := True;
      PE: cbPE.Checked := True;
      CronVar:
      begin
        cbCronVar.Checked := True;
        cbCronVarEjex.ItemIndex :=
          cbCronVarEjex.Items.IndexOf( printCronVarCast.cronVarEjex_nombre);
      end;
    end;

    cbGraficar.Checked := printCronVarCast.graficar;
    cbGraficarClick(nil);
    setSGCronVarTipoGraficoEjeColor(sgCronVars,
      printCronVarCast.cronVars,
      printCronVarCast.tiposGraficos, printCronVarCast.ejes, printCronVarCast.colores,
      cbCronVars, RGTipoGrafico, RGEje,
      sgColor, ColorDialog1, BAuto, BAgregar, coloresSGCronVars);

    // Parámetros del eje X
    eTitulo_ejeX.Text:= printCronVarCast.titulo_ejeX;


    // Parámetros de eje Y1
    eTitulo_eje1.Text := printCronVarCast.titulo_eje1;
    eDigitos_eje1.Text := IntToStr(printCronVarCast.digitos_eje1);
    eDecimales_eje1.Text := IntToStr(printCronVarCast.decimales_eje1);

    cbMinEjeYAuto_eje1.Checked := printCronVarCast.minEjeYAuto_eje1;
    if cbGraficar.Checked then
      cbMinEjeYAuto_eje1Click(nil);
    eMinEjeY_eje1.Text := FloatToStrF(printCronVarCast.minEjeY_eje1, ffGeneral, 16, 10);

    cbMaxEjeYAuto_eje1.Checked := printCronVarCast.maxEjeYAuto_eje1;
    if cbGraficar.Checked then
      cbMaxEjeYAuto_eje1Click(nil);
    eMaxEjeY_eje1.Text := FloatToStrF(printCronVarCast.MaxEjeY_eje1, ffGeneral, 16, 10);


    // Parámetros del eje Y2
    eTitulo_eje2.Text := printCronVarCast.titulo_eje2;
    eDigitos_eje2.Text := IntToStr(printCronVarCast.digitos_eje2);
    eDecimales_eje2.Text := IntToStr(printCronVarCast.decimales_eje2);

    cbMinEjeYAuto_eje2.Checked := printCronVarCast.minEjeYAuto_eje2;
    if cbGraficar.Checked then
      cbMinEjeYAuto_eje2Click(nil);
    eMinEjeY_eje2.Text := FloatToStrF(printCronVarCast.minEjeY_eje2, ffGeneral, 16, 10);

    cbMaxEjeYAuto_eje2.Checked := printCronVarCast.maxEjeYAuto_eje2;
    if cbGraficar.Checked then
      cbMaxEjeYAuto_eje2Click(nil);
    eMaxEjeY_eje2.Text := FloatToStrF(printCronVarCast.MaxEjeY_eje2, ffGeneral, 16, 10);

  end;
  utilidades.AutoSizeTypedColsAndTable( sgCronVars, tiposColsSGCronVars, FSimSEEEdit.iconos );
  guardado := True;
end;

procedure TAltaEdicionPrintCronVar_CompararValoresMultiplesCronVars.eDecimales_eje1Exit(
  Sender: TObject);
begin
  inherited EditIntExit(Sender, 0, MaxInt);
end;

procedure TAltaEdicionPrintCronVar_CompararValoresMultiplesCronVars.eDigitos_eje1Exit(
  Sender: TObject);
begin
  inherited EditIntExit(Sender, 1, MaxInt);
end;

procedure TAltaEdicionPrintCronVar_CompararValoresMultiplesCronVars.EditEnter(
  Sender: TObject);
begin
  inherited EditEnter(Sender);
end;

procedure TAltaEdicionPrintCronVar_CompararValoresMultiplesCronVars.cbCronVarEjexChange
  (Sender: TObject);
begin
  inherited cbCronVarChange(Sender, False);
end;

procedure TAltaEdicionPrintCronVar_CompararValoresMultiplesCronVars.
cbMaxEjeYAuto_eje2Click
  (Sender: TObject);
begin
  inherited CBEditFloatCondicionalClick(cbMaxEjeYAuto_eje2,
    lMaxEjeY_eje2, eMaxEjeY_eje2, False);
end;

procedure TAltaEdicionPrintCronVar_CompararValoresMultiplesCronVars.
cbMinEjeYAuto_eje2Click
  (Sender: TObject);
begin
  inherited CBEditFloatCondicionalClick(cbMinEjeYAuto_eje2,
    lMinEjeY_eje2, eMinEjeY_eje2, False);
end;

procedure TAltaEdicionPrintCronVar_CompararValoresMultiplesCronVars.cbCronVarChange
  (Sender: TObject);
begin
  if Self.cbCronVar.Checked then
    self.cbCronVarEjex.Enabled := True
  else
    self.cbCronVarEjex.Enabled := False;

end;


procedure TAltaEdicionPrintCronVar_CompararValoresMultiplesCronVars.EditFloatExit(
  Sender: TObject);
begin
  inherited EditFloatExit(Sender, -MaxNReal, MaxNReal);
end;

procedure TAltaEdicionPrintCronVar_CompararValoresMultiplesCronVars.EditStringExit(
  Sender: TObject);
begin
  inherited EditStringExit(Sender, True);
end;

procedure TAltaEdicionPrintCronVar_CompararValoresMultiplesCronVars.FormCloseQuery(
  Sender: TObject; var CanClose: boolean);
begin
  inherited FormCloseQuery(Sender, CanClose);
end;

procedure TAltaEdicionPrintCronVar_CompararValoresMultiplesCronVars.
RGValoresACompararClick(Sender: TObject);
begin

  ePE.Enabled := ((TTipoValoresAComparar(RGValoresAComparar.ItemIndex) =
    ProbabilidadesDeExcedencia) or
    (TTipoValoresAComparar(RGValoresAComparar.ItemIndex) = ValoresEnRiesgo));

  lPE.Enabled := ePE.Enabled;
  cbPreOrdenar.Enabled := ePE.Enabled;

  if (TTipoValoresAComparar(RGValoresAComparar.ItemIndex) = ValoresEnRiesgo) then
  begin
    ePE1.Enabled := True;
    lPE1.Enabled := True;
  end
  else
  begin
    ePE1.Enabled := False;
    lPE1.Enabled := False;
  end;

  if Sender <> nil then
    guardado := False;
end;

procedure TAltaEdicionPrintCronVar_CompararValoresMultiplesCronVars.sgColorDrawCell(
  Sender: TObject; ACol, ARow: integer; Rect: TRect; State: TGridDrawState);
begin
  utilidades.ListadoDrawCell(Sender, ACol, ARow, Rect, State,
    tiposColsColoresAgregar[Acol], coloresAgregar, FSimSEEEdit.iconos);
end;

procedure TAltaEdicionPrintCronVar_CompararValoresMultiplesCronVars.sgColorMouseDown(
  Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: integer);
begin
  utilidades.ListadoMouseDown(Sender, Button, Shift, X, Y);
end;

procedure TAltaEdicionPrintCronVar_CompararValoresMultiplesCronVars.sgColorMouseMove(
  Sender: TObject; Shift: TShiftState; X, Y: integer);
begin
  utilidades.ListadoMouseMove(Sender, Shift, X, Y, tiposColsColoresAgregar);
end;

procedure TAltaEdicionPrintCronVar_CompararValoresMultiplesCronVars.sgColorMouseUp(
  Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: integer);
var
  res: TTipoColumna;
begin
  res := utilidades.ListadoMouseUp(Sender, Button, Shift, X, Y, tiposColsColoresAgregar);
  case res of
    TC_Color: cambiarColor(sgColor, utilidades.filaListado,
        ColorDialog1, coloresAgregar);
  end;
end;

procedure TAltaEdicionPrintCronVar_CompararValoresMultiplesCronVars.sgCronVarsDrawCell(
  Sender: TObject; ACol, ARow: integer; Rect: TRect; State: TGridDrawState);
begin
  utilidades.ListadoDrawCell(Sender, ACol, ARow, Rect, State,
    tiposColsSGCronVars[ACol], coloresSGCronVars, iconos);
end;

procedure TAltaEdicionPrintCronVar_CompararValoresMultiplesCronVars.sgCronVarsMouseDown(
  Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: integer);
begin
  utilidades.ListadoMouseDown(Sender, Button, Shift, X, Y);
end;

procedure TAltaEdicionPrintCronVar_CompararValoresMultiplesCronVars.sgCronVarsMouseMove(
  Sender: TObject; Shift: TShiftState; X, Y: integer);
begin
  utilidades.ListadoMouseMove(Sender, Shift, X, Y, tiposColsSGCronVars);
end;

procedure TAltaEdicionPrintCronVar_CompararValoresMultiplesCronVars.sgCronVarsMouseUp(
  Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: integer);
var
  res: TTipoColumna;
begin
  res := utilidades.ListadoMouseUp(Sender, Button, Shift, X, Y, tiposColsSGCronVars);
  case res of
    TC_Color: cambiarColor(sgCronVars, utilidades.filaListado,
        ColorDialog1, coloresSGCronVars);
    TC_btEliminar: eliminarSGCronVarTipoGraficoEjeColor(sgCronVars,
        utilidades.filaListado, cbCronVars, RGTipoGrafico, RGEje,
        sgColor, ColorDialog1, BAuto,
        BAgregar,
        coloresSGCronVars, coloresAgregar);

    TC_btUp: utilidades.listadoClickUp_(
        sgCronVars, utilidades.filaListado,
        nil, Shift, nil, Modificado, coloresSGCronVars);
    TC_btDown: utilidades.listadoClickDown_(sgCronVars,
        utilidades.filaListado, nil, Shift, nil, Modificado, coloresSGCronVars);

  end;
end;

function TAltaEdicionPrintCronVar_CompararValoresMultiplesCronVars.
validarFormulario: boolean;
begin

  Result := validarNombreHoja(eNombreHoja) and
    validarEditString(eTitulo, RS_TITULO) and validarEditString(
    eTitulo_eje1, RS_UNIDADES) and validarEditInt(eDigitos_eje1, 1, MaxInt) and
    validarEditInt(eDecimales_eje1, 0, MaxInt) and validarSGCronVar(
    sgCronVars, cbCronVars) and validarCronVarEjex(cbCronVarEjex, cbCronVar) and
    ((TTipoValoresAComparar(RGValoresAComparar.ItemIndex) <
    ProbabilidadesDeExcedencia) or (validarEditFloat(ePE, 0, 1) and
    (validarEditFloat(ePE1, 0, 1)))) and (not cbGraficar.Checked or
    (validarEditFloatCondicional(cbMinEjeYAuto_eje1, eMinEjeY_eje1,
    -MaxNReal, MaxNReal, False) and validarEditFloatCondicional(
    cbMaxEjeYAuto_eje1, eMinEjeY_eje1, -MaxNReal, MaxNReal, False)));
end;

function setEjex(var cb: TRadioButton; ejex: TTipoVariableDelEje): TTipoVariableDelEje;
begin
  cb.Checked := True;
  Result := ejex;
end;

initialization
end.
