unit uAltaEdicionTPrintCronVar_matrizDeDatos;
{$MODE Delphi}

interface

uses
  {$IFDEF WINDOWS}
  Windows,
  {$ENDIF}
  Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, StdCtrls, ExtCtrls,
  uBaseFormularios,
  uBaseAltaEdicionPrintCronVars, uLectorSimRes3Defs, uverdoc, uPrintCronVars,
  xMatDefs, utilidades, uOpcionesSimSEEEdit;

type

  { TAltaEdicionPrintCronVar_matrizDeDatos }

  TAltaEdicionPrintCronVar_matrizDeDatos = class(TBaseAltaEdicionPrintCronVars)
    cbMaxEjeYAuto_eje1: TCheckBox;
    cbMinEjeYAuto_eje1: TCheckBox;
    eDecimales_eje1: TEdit;
    eDigitos_eje1: TEdit;
    eMaxEjeY_eje1: TEdit;
    eMinEjeY_eje1: TEdit;
    eTitulo: TEdit;
    eUnidades_eje1: TEdit;
    gbEjeYPrimario: TGroupBox;
    lblFormato_eje1: TLabel;
    lMaxEjeY_eje1: TLabel;
    lMinEjeY_eje1: TLabel;
    cbCronVar: TComboBox;
    lTitulo: TLabel;
    lUnidades1: TLabel;
    sgTitulosCols: TStringGrid;
    lCronVar: TLabel;
    lNombreHoja: TLabel;
    eNombreHoja: TEdit;
    lTituloCol: TLabel;
    eTituloCol: TEdit;
    bAgregar: TButton;
    cbPrintPromedio: TCheckBox;
    cbGraficarMatriz: TCheckBox;
    bGuardar: TButton;
    bCancelar: TButton;
    BAyuda: TButton;
    procedure BAyudaClick(Sender: TObject);
    procedure cambiosForm(Sender: TObject);
    procedure EditEnter(Sender: TObject);
    procedure EditStringExit(Sender: TObject);
    procedure EditFloatExit(Sender: TObject);
    procedure bCancelarClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: boolean);
    procedure BGuardarClick(Sender: TObject); override;
    procedure cbGraficarMatrizClick(Sender: TObject);
    procedure cbMinEjeYAutoClick(Sender: TObject);
    procedure cbMaxEjeYAutoClick(Sender: TObject);
    procedure bAgregarClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure sgTitulosColsDrawCell(Sender: TObject; ACol, ARow: integer;
      Rect: TRect; State: TGridDrawState);
    procedure sgTitulosColsMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: integer);
    procedure sgTitulosColsMouseMove(Sender: TObject; Shift: TShiftState;
      X, Y: integer);
    procedure sgTitulosColsMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: integer);
    procedure eDecimalesExit(Sender: TObject);
    procedure eDigitosExit(Sender: TObject);
    procedure CBCronVarChange(Sender: TObject);
    procedure cbCronVarEnter(Sender: TObject);
    procedure eTituloColKeyDown(Sender: TObject; var Key: word; Shift: TShiftState);
  private
    tiposColsSGTitulosCols: TDAOfTTipoColumna;
  protected
    function validarFormulario: boolean; override;
  public
    constructor Create(AOwner: TComponent; lector: TLectorSimRes3Defs;
      printCronVar: TPrintCronVar; tipoPrintCronVar: TClaseDePrintCronVar); override;
  end;

implementation
uses SimSEEEditMain;
{$R *.lfm}

procedure TAltaEdicionPrintCronVar_matrizDeDatos.cbCronVarEnter(Sender: TObject);
begin
  inherited CBEnter(Sender);
end;

procedure TAltaEdicionPrintCronVar_matrizDeDatos.cbMaxEjeYAutoClick(Sender: TObject);
begin
  inherited CBEditFloatCondicionalClick(cbMaxEjeYAuto_eje1, lMaxEjeY_eje1,
    eMaxEjeY_eje1, False);
end;

procedure TAltaEdicionPrintCronVar_matrizDeDatos.cbMinEjeYAutoClick(Sender: TObject);
begin
  inherited CBEditFloatCondicionalClick(cbMinEjeYAuto_eje1, lMinEjeY_eje1,
    eMinEjeY_eje1, False);
end;

constructor TAltaEdicionPrintCronVar_matrizDeDatos.Create(AOwner: TComponent;
  lector: TLectorSimRes3Defs; printCronVar: TPrintCronVar;
  tipoPrintCronVar: TClaseDePrintCronVar);
begin
  inherited Create(AOwner, lector, printCronVar, tipoPrintCronVar);

  inicializarCBCronVars(cbCronVar, False);
  inicializarSGString(sgTitulosCols, [RS_TITULO, encabezadoBTEliminar,
    encabezadoBTUp, encabezadoBTDown], tiposColsSGTitulosCols,
    eTitulo, lTitulo, bAgregar);

  if printCronVar <> nil then
  begin
    setCBCronVar(cbCronVar, TPrintCronVar_matrizDeDatos(printCronVar).cronVar);
    eNombreHoja.Text := TPrintCronVar_matrizDeDatos(printCronVar).nombreHoja;

    eTitulo.Text := TPrintCronVar_matrizDeDatos(printCronVar).titulo;
    eUnidades_eje1.Text := TPrintCronVar_matrizDeDatos(printCronVar).titulo_eje1;
    setSGString(sgTitulosCols, TPrintCronVar_matrizDeDatos(printCronVar).titulosCols);
    eDigitos_eje1.Text := IntToStr(TPrintCronVar_matrizDeDatos(
      printCronVar).digitos_eje1);
    eDecimales_eje1.Text := IntToStr(TPrintCronVar_matrizDeDatos(
      printCronVar).decimales_eje1);
    cbPrintPromedio.Checked := TPrintCronVar_matrizDeDatos(printCronVar).Print_promedio;
    cbGraficarMatriz.Checked := TPrintCronVar_matrizDeDatos(printCronVar).chart_Mat;
    cbGraficarMatrizClick(Self);
    cbMinEjeYAuto_eje1.Checked :=
      TPrintCronVar_matrizDeDatos(printCronVar).minEjeYAuto_eje1;
    cbMinEjeYAutoClick(Self);
    eMinEjeY_eje1.Text := FloatToStrF(TPrintCronVar_matrizDeDatos(
      printCronVar).minEjeY_eje1, ffGeneral, 16, 10);
    cbMaxEjeYAuto_eje1.Checked :=
      TPrintCronVar_matrizDeDatos(printCronVar).maxEjeYAuto_eje1;
    cbMaxEjeYAutoClick(Self);
    eMaxEjeY_eje1.Text := FloatToStrF(TPrintCronVar_matrizDeDatos(
      printCronVar).MaxEjeY_eje1, ffGeneral, 16, 10);
    guardado := True;
  end
  else
  begin
    eTitulo.Text := '';
    eUnidades_eje1.Text := '';
    eDigitos_eje1.Text := IntToStr(12);
    eDecimales_eje1.Text := IntToStr(2);
    cbPrintPromedio.Checked := True;
    cbGraficarMatriz.Checked := False;
    cbGraficarMatrizClick(Self);
    cbMinEjeYAuto_eje1.Checked := True;
    cbMinEjeYAutoClick(Self);
    eMinEjeY_eje1.Text := FloatToStr(0.0);
    cbMaxEjeYAuto_eje1.Checked := True;
    cbMaxEjeYAutoClick(Self);
    eMaxEjeY_eje1.Text := FloatToStr(0.0);
    guardado := True;
  end;

  utilidades.AutoSizeTypedColsAndTable(
    sgTitulosCols, tiposColsSGTitulosCols, FSimSEEEdit.iconos );
end;

procedure TAltaEdicionPrintCronVar_matrizDeDatos.eDecimalesExit(Sender: TObject);
begin
  inherited EditIntExit(Sender, 0, MaxInt);
end;

procedure TAltaEdicionPrintCronVar_matrizDeDatos.eDigitosExit(Sender: TObject);
begin
  inherited EditIntExit(Sender, 1, MaxInt);
end;

function TAltaEdicionPrintCronVar_matrizDeDatos.validarFormulario: boolean;
begin
  Result := validarCBCronVars(cbCronVar) and validarNombreHoja(eNombreHoja) and
    validarEditString(eTitulo, RS_TITULO) and
    validarEditString(eUnidades_eje1, RS_UNIDADES) and
    validarEditInt(eDigitos_eje1, 1, MaxInt) and
    validarEditInt(eDecimales_eje1, 0, MaxInt) and
    (not cbGraficarMatriz.Checked or
    (validarEditFloatCondicional(cbMinEjeYAuto_eje1, eMinEjeY_eje1,
    -MaxNReal, MaxNReal, False) and validarEditFloatCondicional(
    cbMaxEjeYAuto_eje1, eMinEjeY_eje1, -MaxNReal, MaxNReal, False)));
end;

procedure TAltaEdicionPrintCronVar_matrizDeDatos.bAgregarClick(Sender: TObject);
begin
  inherited addSGString(sgTitulosCols, eTituloCol, RS_TITULO_DE_COLUMNA,
    TSimSEEEditOptions.getInstance.deshabilitarScrollHorizontalEnListados);
end;

procedure TAltaEdicionPrintCronVar_matrizDeDatos.FormCreate(Sender: TObject);
begin

end;


procedure TAltaEdicionPrintCronVar_matrizDeDatos.BAyudaClick(Sender: TObject);
begin
  verdoc(TPrintCronVar_matrizDeDatos);
end;

procedure TAltaEdicionPrintCronVar_matrizDeDatos.bCancelarClick(Sender: TObject);
begin
  inherited bCancelarClick(Sender);
end;

procedure TAltaEdicionPrintCronVar_matrizDeDatos.bGuardarClick(Sender: TObject);
var
  minEjeYAuto, maxEjeYAuto: boolean;
  minEjeY, maxEjeY: NReal;
begin
  if validarFormulario then
  begin
    valoresEditFloatCondicional(cbMinEjeYAuto_eje1, eMinEjeY_eje1,
      False, minEjeYAuto, minEjeY);
    valoresEditFloatCondicional(cbMaxEjeYAuto_eje1, eMaxEjeY_eje1,
      False, maxEjeYAuto, maxEjeY);

    if printCronVar = nil then
      printCronVar := TPrintCronVar_matrizDeDatos.Create(valorCBCronVar(cbCronVar),
        eNombreHoja.Text,
        eTitulo.Text,
        eUnidades_eje1.Text,
        valorSGString(sgTitulosCols),
        StrToInt(eDigitos_eje1.Text),
        StrToInt(eDecimales_eje1.Text),
        cbPrintPromedio.Checked,
        cbGraficarMatriz.Checked,
        minEjeYAuto, maxEjeYAuto, minEjeY,
        maxEjey)
    else
    begin
      TPrintCronVar_matrizDeDatos(printCronVar).cronVar := valorCBCronVar(cbCronVar);
      TPrintCronVar_matrizDeDatos(printCronVar).nombreHoja := eNombreHoja.Text;
      TPrintCronVar_matrizDeDatos(printCronVar).titulo := eTitulo.Text;
      TPrintCronVar_matrizDeDatos(printCronVar).titulo_eje1 := eUnidades_eje1.Text;
      TPrintCronVar_matrizDeDatos(printCronVar).titulosCols :=
        valorSGString(sgTitulosCols);
      TPrintCronVar_matrizDeDatos(printCronVar).digitos_eje1 :=
        StrToInt(eDigitos_eje1.Text);
      TPrintCronVar_matrizDeDatos(printCronVar).decimales_eje1 :=
        StrToInt(eDecimales_eje1.Text);
      TPrintCronVar_matrizDeDatos(printCronVar).Print_promedio := cbPrintPromedio.Checked;
      TPrintCronVar_matrizDeDatos(printCronVar).chart_Mat := cbGraficarMatriz.Checked;
      TPrintCronVar_matrizDeDatos(printCronVar).minEjeYAuto_eje1 := minEjeYAuto;
      TPrintCronVar_matrizDeDatos(printCronVar).minEjeY_eje1 := minEjeY;
      TPrintCronVar_matrizDeDatos(printCronVar).maxEjeYAuto_eje1 := maxEjeYAuto;
      TPrintCronVar_matrizDeDatos(printCronVar).MaxEjeY_eje1 := maxEjeY;
    end;

    modalResult := mrOk;
  end;
end;

procedure TAltaEdicionPrintCronVar_matrizDeDatos.cambiosForm(Sender: TObject);
begin
  inherited cambiosForm(Sender);
end;

procedure TAltaEdicionPrintCronVar_matrizDeDatos.cbGraficarMatrizClick(
  Sender: TObject);
begin
  inherited cbChartMatClick(Sender, cbGraficarMatriz, cbMinEjeYAuto_eje1,
    cbMaxEjeYAuto_eje1, lMinEjeY_eje1,
    lMaxEjeY_eje1, eMinEjeY_eje1, eMaxEjeY_eje1);
end;

procedure TAltaEdicionPrintCronVar_matrizDeDatos.CBCronVarChange(Sender: TObject);
begin
  inherited CBCronVarChange(Sender, True);
  if (eTitulo.Text = loQueHabia) or (eTitulo.Text = '') then
    eTitulo.Text := valorCBString(TComboBox(Sender));
  if (eNombreHoja.Text = loQueHabia) or (eNombreHoja.Text = '') then
    eNombreHoja.Text := valorCBString(TComboBox(Sender));
  loQueHabia := valorCBString(TComboBox(Sender));
end;

procedure TAltaEdicionPrintCronVar_matrizDeDatos.EditEnter(Sender: TObject);
begin
  inherited EditEnter(Sender);
end;

procedure TAltaEdicionPrintCronVar_matrizDeDatos.EditFloatExit(Sender: TObject);
begin
  inherited EditFloatExit(Sender, -MaxNReal, MaxNReal);
end;

procedure TAltaEdicionPrintCronVar_matrizDeDatos.EditStringExit(Sender: TObject);
begin
  inherited EditStringExit(Sender, True);
end;

procedure TAltaEdicionPrintCronVar_matrizDeDatos.eTituloColKeyDown(Sender: TObject;
  var Key: word; Shift: TShiftState);
begin
  inherited eStringKeyDown(sgTitulosCols, eTituloCol, lTituloCol.Caption,
    TSimSEEEditOptions.getInstance.deshabilitarScrollHorizontalEnListados, Key, Shift);
end;

procedure TAltaEdicionPrintCronVar_matrizDeDatos.FormCloseQuery(Sender: TObject;
  var CanClose: boolean);
begin
  inherited FormCloseQuery(Sender, CanClose);
end;

procedure TAltaEdicionPrintCronVar_matrizDeDatos.sgTitulosColsDrawCell(Sender: TObject;
  ACol, ARow: integer; Rect: TRect; State: TGridDrawState);
begin
  utilidades.ListadoDrawCell(Sender, ACol, ARow, Rect, State,
    tiposColsSGTitulosCols[Acol], nil, FSimSEEEdit.iconos);
end;

procedure TAltaEdicionPrintCronVar_matrizDeDatos.sgTitulosColsMouseDown(
  Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: integer);
begin
  utilidades.ListadoMouseDown(Sender, Button, Shift, X, Y);
end;

procedure TAltaEdicionPrintCronVar_matrizDeDatos.sgTitulosColsMouseMove(
  Sender: TObject;
  Shift: TShiftState; X, Y: integer);
begin
  utilidades.ListadoMouseMove(Sender, Shift, X, Y, tiposColsSGTitulosCols);
end;

procedure TAltaEdicionPrintCronVar_matrizDeDatos.sgTitulosColsMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: integer);
var
  res: TTipoColumna;
begin
  res := utilidades.ListadoMouseUp(Sender, Button, Shift, X, Y, tiposColsSGTitulosCols);
  case res of
    TC_btEliminar: eliminarSGString(sgTitulosCols, utilidades.filaListado,
        eTituloCol, TSimSEEEditOptions.getInstance.deshabilitarScrollHorizontalEnListados);
    TC_btUp: listadoClickUp_(sgTitulosCols, utilidades.filaListado,
        nil, Shift, nil, Modificado);
    TC_btDown: listadoClickDown_(sgTitulosCols, utilidades.filaListado,
        nil, Shift, nil, Modificado);
  end;
end;

end.
