unit uFormParametrizador;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, xMatDefs, StdCtrls, uauxiliares, shellApi, uconstantes;

type
  TForm1 = class(TForm)
    ENArch: TEdit;
    LNArch: TLabel;
    BBuscar: TButton;
    LParam: TLabel;
    EParam: TEdit;
    BGenerar: TButton;
    OpenDialog1: TOpenDialog;
    LRes: TLabel;
    ERes: TEdit;
    procedure BBuscarClick(Sender: TObject);
    procedure BGenerarClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

procedure aplicarParametro(param: NReal; nArch: String);

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure aplicarParametro(param: NReal; nArch: String);
var
  archEntrada, archSalida: Textfile;
  linea, strParam: String;
begin
  try
    AssignFile(archEntrada, nArch);
    Reset(archEntrada);
    try
      AssignFile(archSalida, uconstantes.RUNDIR + 'temp.ese');
      Rewrite(archSalida);
      strParam:= FloatToStr(param + 25);
      while not Eof(archEntrada) do
      begin
        readln(archEntrada, linea);
        linea:= StringReplace(linea, '$P[1]', strParam, [rfReplaceAll]);
        writeln(archSalida, linea);
      end;
    finally
      closefile(archSalida);
    end;
  finally
    CloseFile(archEntrada);
  end;
end;

procedure TForm1.BBuscarClick(Sender: TObject);
begin
  if OpenDialog1.Execute then
    ENArch.Text:= OpenDialog1.FileName;
end;

procedure TForm1.BGenerarClick(Sender: TObject);
var
  param, costo: NReal;
  parametros: String;
  fres: Textfile;
  handle: HWND;
begin
  param:= StrToFloat(EParam.Text);
  aplicarParametro(param, ENArch.Text);
  parametros:='"'+ uconstantes.RUNDIR + 'temp.ese' + '"'+#0;
{  handle:= ShellExecute(self.Handle, 'open', 'c:\simseeu\bin\cmdopt.exe', @parametros[1], NIL, SW_SHOWNORMAL);
  if handle > 32 then
    WaitForSingleObject(handle, INFINITE)
  else
    raise Exception.Create('Error en shellExecute cmdopt.exe');}

  handle:= ShellExecute(self.Handle, 'open', 'c:\simseeu\bin\SimSEEUSimulador.exe', @parametros[1], NIL, SW_SHOWNORMAL);
  if handle > 32 then
  begin
    ShowMessage('Cerrar el Simulador');
    WaitForSingleObject(handle, INFINITE);
    try
      AssignFile(fres, uconstantes.RUNDIR + 'simcosto_31x1.xlt');
      Reset(fres);
      system.readln(fres, costo);
      ERes.Text:= FloatToStr(costo - (param*80*7*24));
    finally
      CloseFile(fres);
    end;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  sysutils.DecimalSeparator:= '.';
end;

end.
