unit uProcesadorResultadosMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Menus, uProcesarOptVarEstado, uSeleccionarArchivo, uAcumuladorVars,
  uPromediarYAgrupar, uverdoc, uEvaluadorContratos, uObtenerEnergiasDeFallaAnuales;

type
  TProcesadorResultadosMain = class(TForm)
    MainMenu1: TMainMenu;
    MArchivo: TMenuItem;
    MAyuda: TMenuItem;
    MAcumuladorVars: TMenuItem;
    MPoliticasOperacion: TMenuItem;
    MSeparador: TMenuItem;
    MSalir: TMenuItem;
    MAgruparAniosYPromediarCronicas: TMenuItem;
    MEvaluadorContratos: TMenuItem;
    MObtenerEnergiasDeFallaAnuales: TMenuItem;
    procedure MSalirClick(Sender: TObject);
    procedure MPoliticasOperacionClick(Sender: TObject);
    procedure MAcumuladorVarsClick(Sender: TObject);
    procedure MAgruparAniosYPromediarCronicasClick(Sender: TObject);
    procedure MAyudaClick(Sender: TObject);
    procedure MEvaluadorContratosClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure MObtenerEnergiasDeFallaAnualesClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ProcesadorResultadosMain: TProcesadorResultadosMain;

implementation

uses uInicioYFinal;

{$R *.dfm}

procedure TProcesadorResultadosMain.MAgruparAniosYPromediarCronicasClick(
  Sender: TObject);
var
  fSelect: TSeleccionarArchivo;
  fVarEstado: TPromediarYAgrupar;
  nArch: String;
begin
  fSelect:= TSeleccionarArchivo.Create(self, TPromediarYAgrupar.filtrosDeArchivos, false);
  if fSelect.ShowModal = mrOk then
  begin
    nArch:= fSelect.getFileName;
    fSelect.Free;
    fVarEstado:= TPromediarYAgrupar.Create(self, nArch);
    fVarEstado.ShowModal;
    fVarEstado.Free;
  end
  else
  begin
    fSelect.Free;
  end;
end;

procedure TProcesadorResultadosMain.MAyudaClick(Sender: TObject);
begin
  verdoc( 'procesador-resultados-main', 'Ayuda del Procesador de Resultados');
end;

procedure TProcesadorResultadosMain.MPoliticasOperacionClick(Sender: TObject);
var
  fSelect: TSeleccionarArchivo;
  fVarEstado: TProcesarOptVarEstado;
  nArch: String;
begin
  fSelect:= TSeleccionarArchivo.Create(self, TProcesarOptVarEstado.filtrosDeArchivos, false);
  if fSelect.ShowModal = mrOk then
  begin
    nArch:= fSelect.getFileName;
    fSelect.Free;
    fVarEstado:= TProcesarOptVarEstado.Create(self, nArch);
    fVarEstado.ShowModal;
    fVarEstado.Free;
  end
  else
  begin
    fSelect.Free;
  end;
end;

procedure TProcesadorResultadosMain.MEvaluadorContratosClick(Sender: TObject);
var
  fEvaluador: TEvaluadorContratos;
  fSelect: TSeleccionarArchivo;
  nArch: String;
begin
  fSelect:= TSeleccionarArchivo.Create(self, TEvaluadorContratos.filtrosDeArchivos, false);
  if fSelect.ShowModal = mrOk then
  begin
    nArch:= fSelect.getFileName;
    fSelect.Free;
    fEvaluador:= TEvaluadorContratos.Create(self, nArch);
    fEvaluador.ShowModal;
    fEvaluador.Free;
  end
  else
  begin
    fSelect.Free;
  end;
end;

procedure TProcesadorResultadosMain.MObtenerEnergiasDeFallaAnualesClick(
  Sender: TObject);
var
  fSelect: TSeleccionarArchivo;
  fVarEstado: TObtenerEnergiasDeFallaAnuales;
  nArch: String;
begin
  fSelect:= TSeleccionarArchivo.Create(self, TObtenerEnergiasDeFallaAnuales.filtrosDeArchivos, false);
  if fSelect.ShowModal = mrOk then
  begin
    nArch:= fSelect.getFileName;
    fSelect.Free;
    fVarEstado:= TObtenerEnergiasDeFallaAnuales.Create(self, nArch);
    fVarEstado.ShowModal;
    fVarEstado.Free;
  end
  else
  begin
    fSelect.Free;
  end;
end;

procedure TProcesadorResultadosMain.MSalirClick(Sender: TObject);
begin
  self.Close;
end;

procedure TProcesadorResultadosMain.FormCreate(Sender: TObject);
begin
  uInicioYFinal.AlInicio;
end;

procedure TProcesadorResultadosMain.FormDestroy(Sender: TObject);
begin
  uInicioYFinal.AlFinal;
end;

procedure TProcesadorResultadosMain.MAcumuladorVarsClick(Sender: TObject);
var
  fSelect: TSeleccionarArchivo;
  fVarEstado: TAcumuladorVars;
  nArch: String;
begin
  fSelect:= TSeleccionarArchivo.Create(self, TAcumuladorVars.filtrosDeArchivos, false);
  if fSelect.ShowModal = mrOk then
  begin
    nArch:= fSelect.getFileName;
    fSelect.Free;
    fVarEstado:= TAcumuladorVars.Create(self, nArch);
    fVarEstado.ShowModal;
    fVarEstado.Free;
  end
  else
  begin
    fSelect.Free;
  end;
end;

end.
