unit uPromediarYAgrupar;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, ComCtrls, uParseSimRes;

type
  TPromediarYAgrupar = class(TForm)
    StatusBar1: TStatusBar;
    Timer1: TTimer;
    ProgressBar1: TProgressBar;
    procedure Timer1Timer(Sender: TObject);
  private
    archiEnt: String;
    procedure run;
  public
    Constructor Create(owner : TComponent ; nArch: String); reintroduce;
    class function filtrosDeArchivos: String;    
  end;

var
  PromediarYAgrupar: TPromediarYAgrupar;

implementation

{$R *.dfm}

procedure IniNot(nAvisos : Integer);
begin
  PromediarYAgrupar.ProgressBar1.min:= 0;
  PromediarYAgrupar.ProgressBar1.Position:= 0;
  PromediarYAgrupar.ProgressBar1.Step:= 1;
  PromediarYAgrupar.ProgressBar1.Max:= nAvisos;
end;

procedure Notify;
begin
  PromediarYAgrupar.ProgressBar1.StepIt;
  Application.ProcessMessages;
end;

Constructor TPromediarYAgrupar.Create(owner : TComponent ; nArch: String);
begin
  inherited Create(owner);
  archiEnt:= nArch;

  Self.Caption:= 'Promediar Cronicas y Agrupar en Aos - ' + nArch;
  timer1.Enabled:= true;
  PromediarYAgrupar:= self;
end;

class function TPromediarYAgrupar.filtrosDeArchivos: String;
begin
  result:= 'Archivos de Resultado de Simulacin (simres_*.xlt)|simres_*.xlt';
end;

procedure TPromediarYAgrupar.run;
var
  ok: boolean;
  exts: String;
  archiSalProm, archiSalAnual : String;
begin
  ok:= False;

  uParseSimRes.asignarProcIniNot(IniNot);
  uParseSimRes.asignarProcNot(Notify);

  archiSalProm:= archiEnt;
  exts:= ExtractFileExt(archiSalProm);
  archiSalProm:= copy( archiSalProm, 1, length( archiSalProm )-length( exts ) );
  archiSalProm:= archiSalProm+'_prom.xlt';
  StatusBar1.SimpleText:= 'Promediando... - Archivo de Salida: ' + archiSalProm;
  try
    uParseSimRes.promediarCronicas(archiEnt, archiSalProm);
    archiSalAnual:= archiEnt;
    exts:=ExtractFileExt(archiSalAnual);
    archiSalAnual:= copy( archiSalAnual, 1, length( archiSalAnual )-length( exts ) );
    archiSalAnual:= archiSalAnual+'_anual.xlt';
    StatusBar1.SimpleText:= 'Agrupando Aos... - Archivo de Salida: ' + archiSalProm;
    uParseSimRes.agruparAnios(archiSalProm, archiSalAnual);

    ShowMessage('Se termino de promediar y los resultados en el archivo: ' + archiSalProm +
                #13 + ' y de agrupar los aos en el archivo: ' + archiSalAnual);
    ok:= true;
  finally
    if ok then
      ModalResult:= mrOk
    else
      ModalResult:= mrAbort;
  end;
end;

procedure TPromediarYAgrupar.Timer1Timer(Sender: TObject);
begin
  timer1.Enabled:= false;
  run;
end;

end.
