unit uSeleccionarArchivo;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, uConstantesSimSEE, ExtCtrls;

type
  TSeleccionarArchivo = class(TForm)
    OpenDialog1: TOpenDialog;
    Timer1: TTimer;
    SaveDialog1: TSaveDialog;
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    mres: Integer;
    filtros: String;
    initialDir: String;
    forSave: boolean;
  public
    Constructor Create(Owner : TComponent; filtrosArchivos : String; forSave : boolean); reintroduce; overload;
    Constructor Create(Owner : TComponent; filtrosArchivos : String; initialDir: String; forSave : boolean); reintroduce; overload;

    function getFileName: String;
  end;

var
  SeleccionarArchivo: TSeleccionarArchivo;

implementation

{$R *.dfm}

Constructor TSeleccionarArchivo.Create(Owner : TComponent; filtrosArchivos : String; forSave: boolean);
begin
  Create(Owner, filtrosArchivos, uConstantesSimSEE.getDir_Run, forSave);
end;

Constructor TSeleccionarArchivo.Create(Owner : TComponent; filtrosArchivos : String; initialDir: String; forSave : boolean);
begin
  inherited Create(Owner);
  filtros:= filtrosArchivos;
  self.forSave:= forSave;
  self.initialDir:= initialDir;  
end;

procedure TSeleccionarArchivo.FormCreate(Sender: TObject);
var
  posAster, posParen: Integer;
begin
  self.Top:= Screen.Height +1;//Fuera de la pantalla
  self.Left:= Screen.Width +1;
  if forSave then
  begin
    SaveDialog1.InitialDir:= initialDir;
    SaveDialog1.Filter:= filtros;
    posAster:= pos('*.', filtros);
    posParen:= pos(')', filtros);
    SaveDialog1.DefaultExt:= Copy(filtros, posAster, posParen - posAster - 1);
  end
  else
  begin
    OpenDialog1.InitialDir:= initialDir;
    OpenDialog1.Filter:= filtros;
  end;
end;

procedure TSeleccionarArchivo.FormShow(Sender: TObject);
begin
  if forSave then
  begin
    if SaveDialog1.Execute then
      mres:= mrOk
    else
      mres:= mrCancel;
  end
  else
  begin
    if OpenDialog1.Execute then
      mres:= mrOk
    else
      mres:= mrCancel;
  end;
  Timer1.Enabled:= true;
end;

function TSeleccionarArchivo.getFileName : String;
begin
  if ModalResult = mrOk then
    if forSave then
      result:= SaveDialog1.FileName
    else
      result:= OpenDialog1.FileName
  else
    raise Exception.Create('No selecciono ningun archivo!');
end;

procedure TSeleccionarArchivo.Timer1Timer(Sender: TObject);
begin
  Timer1.Enabled:= false;
  ModalResult:= mres;
end;

end.
