unit uTestParseSimRes;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, uParseSimRes, ComCtrls;

type
  TFormRealizarPromedios = class(TForm)
    BPromediarCronicas: TButton;
    OpenDialog1: TOpenDialog;
    StatusBar1: TStatusBar;
    BAgruparAnios: TButton;
    procedure BPromediarCronicasClick(Sender: TObject);
    procedure BAgruparAniosClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    archiSal: string;
    archiEnt: string;
  end;

var
  FormRealizarPromedios: TFormRealizarPromedios;

implementation

uses uconstantesSimSEE;

{$R *.dfm}

procedure TFormRealizarPromedios.BPromediarCronicasClick(Sender: TObject);
var
  exts: string;
begin
  if OpenDialog1.Execute then
  begin
    archiEnt:= OpenDialog1.FileName;
    archiSal:= archiEnt;
    exts:=ExtractFileExt(archiSal);
    archiSal:= copy( archiSal, 1, length( archiSal )-length( exts ) );
    archiSal:= archiSal+'_prom.xlt';
    statusbar1.SimpleText:= 'Procesando archivo...';
    uParseSimRes.promediarCronicas(archiEnt, ArchiSal);
    statusbar1.SimpleText:= 'PROCESO TERMINADO!!';
    OpenDialog1.FileName:= archiSal;
  end;
end;

procedure TFormRealizarPromedios.FormCreate(Sender: TObject);
begin
  OpenDialog1.InitialDir:= uConstantesSimSEE.getDir_Run;
end;

procedure TFormRealizarPromedios.BAgruparAniosClick(Sender: TObject);
var
  exts : String;
begin
  if OpenDialog1.Execute then
  begin
    archiEnt:= OpenDialog1.FileName;
    archiSal:= archiEnt;
    exts:=ExtractFileExt(archiSal);
    archiSal:= copy( archiSal, 1, length( archiSal )-length( exts ) );
    archiSal:= archiSal+'_anual.xlt';
    statusbar1.SimpleText:= 'Procesando archivo...';
    uParseSimRes.agruparAnios(archiEnt, ArchiSal);
    statusbar1.SimpleText:= 'PROCESO TERMINADO!!';
  end
end;

end.
