unit uSparseMatReal2;

interface
uses
	Classes,
	SysUtils,
	Math,
	xMatDefs,
	COMPOL,
	MatReal;
type
	TCoeficiente = class
		private
			findice : Integer;
			fvalor : NReal;
      fsig: TCoeficiente;
		public
			property indice : Integer read findice write findice;
			property valor : NReal read fvalor write fvalor;
      property sig : TCoeficiente read fsig write fsig;

      Constructor Create(indice : Integer ; valor : NReal);
			Constructor Create(indice : Integer ; valor : NReal; sig: TCoeficiente);
//			Constructor Create_Clone(x : TCoeficiente);
			//Clona el coeficiente
	end;

	TSparseVectR = class
		private
			//n : Integer; no se usa mas es el capacity de la lista
			//cantNoCeros : Integer; no se usa mas, es el count de la lista
			Coefs : TList; {of TCoeficiente}
			ultimoIter : Integer;

			function buscarCoef(k : Integer) : Integer;
			//retorna la posicin de la lista donde ira el indice k
			function getCapacity : Integer;
			procedure setCapacity(n : Integer);
		public
			property n : Integer read getCapacity write setCapacity;

		procedure Igual( x: TSparseVectR );
		constructor Create_Init( ne: integer);
		constructor Create_FromDAofR( a: TDAofNReal );
		constructor Create_Clone( vrx: TSparseVectR );
		procedure Free; virtual;

		constructor Create_Load( var S: TStream );
		procedure Store( var S: TStream );
		function e(k : integer) : NReal;
		procedure pon_e(k : integer ; x : NReal);
		procedure acum_e(k : integer ; x : NReal);

// copia los valores del vector xv a partir del kini  for k= 0 to high( xv ) do pon_e(ini+k, xv[k] ) ;
		procedure pon_ev( kini : integer ; xv : array of NReal );

		function PEV( y : TSparseVectR):NReal;
		function PEVRFLX(y : TSparseVectR): NReal;

// norma euclidea al cuadrado de la diferencia
		function distancia2( y : TSparseVectR):NReal;

// norma eucldea de la diferencia
		function distancia( y :TSparseVectR):NReal;

//Coeficiente de correlacin < x[k] * y[k-kdesp] >
		function coefcorr( y: TSparseVectR ; kdesp : integer ): NReal;

		procedure PorReal(r : NReal);
		procedure sum(y : TSparseVectR);
		procedure sumRPV(r : NReal ; x : TSparseVectR);
		function ne2 : NReal; {norma euclideana al cuadrado }
		function varianza : NReal; { <pv[k]^2> }
		function normEuclid : NReal;
		function normMaxAbs : NReal;
		function normSumAbs : NReal;
		procedure Copy(var x : TSparseVectR);
		procedure Ceros; virtual;
		procedure MinMax(var kMin, kMax : integer ; var Min, Max : NReal);
		procedure Print; virtual;

		{ Divide las componetes por la norma obligando al vector a
		tener norma ecuclidea = 1 }
		procedure HacerUnitario;

		(*
		function EstimFrec(
						nivel,					{nivel de compoaracion}
						histeresis: NReal;	{histeresis del cruce }
						AbajoArriba: boolean	{sentido del cruce}
						): NReal;				{cantidad de cruces}
		*)

		procedure Sort( creciente: boolean );

		// evalua sum( ak * x^(k-1) ; k= 1 a n );
		function rpoly( x: NReal ): NReal;

		// evalua sum( ak * x^(k-1) ; k= 1 a n );
		procedure cpoly( var resc: NComplex; xc: NComplex );
		procedure versor_randomico;

// el indice kr es real y debe estar en el rango 1..n
		function interpol( kr: NReal ): NReal;

// retorna la recta que a*k+b que mejor aproxima al conjunto
// de puntos del vector en el sentido de mnimos cuadrados
		procedure AproximacionLineal( var a, b: NReal );
	end;

	TFuncCompare = function(item1, item2 : NReal) : Integer;
	//La funcin retorna: < 0 si Item1 es menor que Item2
	// 										0 si son iguales
	//									  > 0 si Item1 es mayor que Item2.
implementation

      Constructor Create(indice : Integer ; valor : NReal);
			Constructor Create(indice : Integer ; valor : NReal; sig: TCoeficiente);

end.
 