unit uanalisisvientos;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	StdCtrls, xMatDefs, ufUbicacion, uvhorariomet;

type
  TForm1 = class(TForm)
    odg: TOpenDialog;
    bt_DepurarArchivo: TButton;
    btVisorVientosUY: TButton;
    Button1: TButton;
		procedure bt_DepurarArchivoClick(Sender: TObject);
    procedure btVisorVientosUYClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
	Form1: TForm1;

implementation

{$R *.DFM}





procedure TForm1.bt_DepurarArchivoClick(Sender: TObject);
var
	f: textfile;
	r: string;
	Anio, Mes, Dia, Hora: integer;
	Dir: string;
	vel: integer;
	cnt_lineas: integer;
	vels: TDAOfNReal;
	buscando: boolean;
	k: integer;
	sal: textfile;
	DiaAnt: integer;
  cnt_999: integer;
  timeStamp: string;
begin
//	vel:= 0;


	if odg.Execute then
	begin

		assignFile( f, odg.FileName );
		filemode:= 0;
		reset(f );

(* PRIMERO CONTAMOS LAS LINEAS DEL ARCHIVO *)
		cnt_lineas:= 0;
//    cnt_999:= 0;
		buscando:= true;
		while not eof( f ) and buscando do
		begin
			readln( f, r );
			if (length( r ) = 14) then
      begin
        if pos('999', r )>0 then
        begin
          inc( cnt_999 );
        end;
				inc( cnt_lineas )

      end
			else
      begin
        writeln('Termin por encontrar: ['+r+']' );
				buscando:= true;
      end;
		end;
		reset(f );

		FileMode:= 2;
		assignFile( sal, 'viento.txt');
		rewrite( sal );
		DiaAnt:= -1;
    writeln(sal, 1, #9, 'NSeries' );
    writeln(sal, cnt_lineas, #9, 'NPuntos' );
    writeln(sal, 365, #9, 'Puntos por Ciclo' );

    writeln( sal, #9, 'vel' );
		setlength( vels, cnt_lineas );
		for k:= 0 to cnt_lineas-1 do
		begin
			readln( f, r );
			if length( r ) > 8 then
			begin
        timeStamp:= copy( r, 1, 8 );
				Anio:= 1900+ StrToInt( copy( r, 1, 2 ));
				Mes:= StrToInt( copy( r, 3, 2 ));
				Dia:= StrToInt( copy( r, 5, 2 ));
				Hora:= StrToInt( copy( r, 7, 2 ));
				Dir:= copy( r, 9, 3 );
				vel:= StrToInt( copy( r, 12, 3));

        if vel > 990 then
          vels[k]:= -11111 // lo marco as para filtrarlo al analizar
        else
          vels[k]:= vel / 3.6; // lo pasamos de km/h a m/s

				writeln(sal, timeStamp,#9, vels[k]:12:2 );
			end;
		end;
		writeln( sal );
		closefile( sal );
		closefile( f );
	end;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  vientos: TVientosHorarios;
//  k: integer;
//  av: TArchiVhoraria;
//  spu: NReal;

begin
  vientos:= TVientosHorarios.Create();
  vientos.setCaminoADatos( 'C:\simsee\datos_vientos' );

  vientos.AddArchiDatos( 'vcarrasc.dat',	34.8,	56.1 );
  vientos.AddArchiDatos( 'vcolonia.dat',	34.5,	57.8 );
  vientos.AddArchiDatos( 'vmelo.dat',	32.4,	54.2 );
  vientos.AddArchiDatos( 'vpdelest.dat',	35.0,	55.0 );
  vientos.AddArchiDatos( 'vpdtoros.dat',	32.8,	56.5 );

  vientos.AddArchiDatos( 'vtytres.dat',	33.2,	54.4 );
  vientos.AddArchiDatos( 'vartigas.dat',	30.4,	56.5 );
//  vientos.AddArchiDatos( 'vprado.dat',	34.8,	56.2 );
  vientos.AddArchiDatos( 'vrivera.dat',	30.9,	55.5 );
  vientos.AddArchiDatos( 'vrocha.dat',	34.5,	54.3 );
  vientos.AddArchiDatos( 'vsalto.dat',	31.4,	57.9 );

  Vientos.WriteSeriesToXLT( 'series_vientos.xlt' );

end;

procedure TForm1.btVisorVientosUYClick(Sender: TObject);
var
  fm: TfUbicacion;
  vientos: TVientosHorarios;
begin
  vientos:= TVientosHorarios.Create();
  vientos.setCaminoADatos( 'C:\simsee\datos_vientos' );
  vientos.AddArchiDatos( 'vcarrasc.dat',	34.8,	56.1 );
  vientos.AddArchiDatos( 'vcolonia.dat',	34.5,	57.8 );
  vientos.AddArchiDatos( 'vmelo.dat',	32.4,	54.2 );
  vientos.AddArchiDatos( 'vpdelest.dat',	35.0,	55.0 );
  vientos.AddArchiDatos( 'vpdtoros.dat',	32.8,	56.5 );
  vientos.AddArchiDatos( 'vtytres.dat',	33.2,	54.4 );
  vientos.AddArchiDatos( 'vartigas.dat',	30.4,	56.5 );

//  vientos.AddArchiDatos( 'vprado.dat',	34.8,	56.2 );
  vientos.AddArchiDatos( 'vrivera.dat',	30.9,	55.5 );
  vientos.AddArchiDatos( 'vrocha.dat',	34.5,	54.3 );
  vientos.AddArchiDatos( 'vsalto.dat',	31.4,	57.9 );

  fm:= TfUbicacion.Create( self );
  fm.Latitud:= 32;
  fm.Longitud:= 56;
  fm.vientos:= vientos;
  fm.Show;
end;

end.
