unit ucluster_dem;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  ComCtrls, ExtCtrls,
  uauxiliares,
  ucluster_dem_datos,
  useriestemporales,
  ufechas, uopencalc;

type

  { Tform_cluster_dem }

  Tform_cluster_dem = class(TForm)
    Button1: TButton;
    AbrirSerie: TOpenDialog;
    Button2: TButton;
    Button3: TButton;
    btGenArchiTiposDeDia: TButton;
    eIter: TEdit;
    eNroClusters: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    eNombreSerieDemanda: TLabeledEdit;
    eNombreSerieTemp: TLabeledEdit;
    ekHoraIni: TLabeledEdit;
    ekHoraFin: TLabeledEdit;
    TabControl1: TTabControl;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure btGenArchiTiposDeDiaClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);

  private
    { private declarations }
  public
    { public declarations }
  end;

var
  form_cluster_dem: Tform_cluster_dem;

  series: TSeriesDeDatos;
  datos: TDAOfDiaDemRec;

implementation

{$R *.lfm}

{ Tform_cluster_dem }

procedure Tform_cluster_dem.Button1Click(Sender: TObject);
//var

begin
  if (AbrirSerie.Execute) then
  begin
    if series <> nil then
      series.Free;
    setSeparadoresGlobales;
    series:=TSeriesDeDatos.CreateFromArchi(AbrirSerie.FileName);
    setSeparadoresLocales;
    TabControl1.Visible:=true;
  end;
end;

procedure Tform_cluster_dem.Button2Click(Sender: TObject);
var
  kSerieDem, kSerieTemp: integer;
  flg_ok: boolean;
  clasificador_k_means: TClasificador_K_Means;
  k_clusters, NMaxIteraciones: integer;
begin
  if series = nil then exit;

  kSerieDem:= series.kOfSerie( eNombreSerieDemanda.text );
  kSerieTemp:= series.kOfSerie( eNombreSerieTemp.Text );

  flg_ok := ( kSerieDem >= 0 ) and ( kSerieTemp >= 0 );

  if flg_ok  then
  begin
    datos:= ExtraerCurvasDem( series, kSerieDem, kSerieTemp, StrToInt( ekHoraIni.text ), StrToInt( ekHoraFin.Text )  );

    k_clusters:= strtoint(eNroClusters.Text);
    NMaxIteraciones:= strtoint(eIter.text);
    clasificador_k_means:= TClasificador_K_Means.Create(
      datos, k_clusters, NMaxIteraciones );

    clasificador_k_means.WritToArchiODS( 'clasificador_k_means.ods' );
    clasificador_k_means.Free;
  end;

end;

procedure Tform_cluster_dem.Button3Click(Sender: TObject);
begin
  if series<>nil then
     series.Free;
  close;
end;

procedure Tform_cluster_dem.btGenArchiTiposDeDiaClick(Sender: TObject);

var
  // f: TLibroOpenCalc;
  sal: text;
  dia: TFecha;
  dtFin: TDateTime;
begin
  dia:= TFecha.Create_AnioMesDia( 2016, 1, 1 );
  dtFin:= now+365*100;

  assignfile( sal, 'tipodia.txt' );
  rewrite( sal );
//  f:= TLibroOpenCalc.Create( true, 'tiposdedia.ods' );
  while dia.dt < dtFin do
  begin
    (*
    f.WriteDateTime( dia.dt );
    f.Write( ord( TipoDeDiaUruguay( dia.dt ) ) );
    f.writeln;
    *)
    writeln( sal, trunc( dia.dt + 0.5 ), #9, ord( TipoDeDiaUruguay( dia.dt ) )  );
    dia.addDias(1);
  end;
//  f.Free;
  closefile( sal );


end;

procedure Tform_cluster_dem.FormCreate(Sender: TObject);
begin
  series:= nil;
  datos:= nil;
end;





end.

