unit uArbolEscenarios;

//{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  ComCtrls, ExtCtrls, Grids, EditBtn,
  uArbol,
  uInicioYFinal ,
  xmatdefs,
  ufechas;

type

  { TFormArbolEscenarios }

  TFormArbolEscenarios = class(TForm)
    btCagarSala: TButton;
    btagregar_nodo: TButton;
    btOpt: TButton;
    btInsertarNodo: TButton;
    btCancelar: TButton;
    cbTipoBif: TComboBox;
    eFecha: TDateEdit;
    eNombre: TEdit;
    eNumRamas: TEdit;
    eFechaFinsim: TEdit;
    eFechaInisim: TEdit;
    eFechainiopt: TEdit;
    eFechafinopt: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    sgVistaEscenario: TStringGrid;
    TabControl1: TTabControl;
    txNombreSala: TEdit;
    OpenDialog1: TOpenDialog;

    procedure btCagarSalaClick(Sender: TObject);
    procedure btagregar_nodoClick(Sender: TObject);
    procedure btOptClick(Sender: TObject);
    procedure btInsertarNodoClick(Sender: TObject);
    procedure btCancelarClick(Sender: TObject);
    procedure eFechaChange(Sender: TObject);


    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure FormCreate(Sender: TObject);



    procedure Arbol_to_Grid(Raiz:ptNodo);

  private
    { private declarations }

  public
    { public declarations }
    Arbol: TArbolEscenarios;
  end;

var
  FormArbolEscenarios: TFormArbolEscenarios;

implementation

{$R *.lfm}

{ TFormArbolEscenarios }

procedure TFormArbolEscenarios.btCagarSalaClick(Sender: TObject);
var
  i,pos:integer;

begin
  if (OpenDialog1.Execute) then
    begin
       btagregar_nodo.Visible:=true;
       txNombreSala.Text:=OpenDialog1.FileName;
       Arbol:=TArbolEscenarios.create_init_from_file(txNombreSala.Text);
       eFechainiopt.Text:=Arbol.Fecha_Iniopt.AsStr;
       eFechafinopt.Text:=Arbol.Fecha_Finopt.AsStr;
       eFechainisim.Text:=Arbol.Fecha_Inisim.AsStr;
       eFechafinsim.Text:=Arbol.Fecha_Finsim.AsStr;
       sgVistaEscenario.Visible:=true;
       sgVistaEscenario.Clean;
       sgVistaEscenario.RowCount:=1;
       Arbol_to_Grid(Arbol.Raiz);

    end;

end;



procedure TFormArbolEscenarios.Arbol_to_Grid(Raiz:ptNodo);
var
  i,j,pos:integer;
  nod:ptNodo;
  ram: ptRama;
begin

  New(nod);
  sgVistaEscenario.RowCount:=sgVistaEscenario.RowCount+1;
  nod^:=Raiz^;
  pos:=sgVistaEscenario.RowCount-1;
  sgVistaEscenario.Cells[1,pos]:=nod^.Nombre;
  sgVistaEscenario.Cells[2,pos]:=nod^.Fecha.AsStr;
  sgVistaEscenario.Cells[3,pos]:=nod^.TipoBifurcacion.Tipobifurcacion;
  if nod^.Hoja then
      sgVistaEscenario.Cells[4,pos]:='Si';
  for j:=0 to nod^.ramas.Count-1 do
      begin
          if nod^.Hoja=False then
              begin
                  New(ram);
                  ram:=nod^.ramas[j];
                  sgVistaEscenario.RowCount:=sgVistaEscenario.RowCount+1;
                  pos:=sgVistaEscenario.RowCount-1;
                  sgVistaEscenario.Cells[1,pos]:='-----';
                  sgVistaEscenario.Cells[2,pos]:='-----';
                  sgVistaEscenario.Cells[3,pos]:='-----';
                  sgVistaEscenario.Cells[4,pos]:='-----';
                  sgVistaEscenario.Cells[5,pos]:=ram^.Nombre;
                  sgVistaEscenario.Cells[6,pos]:=DAOfNIntToStr(ram^.capas,';');
                  sgVistaEscenario.Cells[7,pos]:=floattostr(ram^.ProbCapas);
                  Arbol_to_Grid(ram^.Nodo);
              end;
      end;
end;

procedure TFormArbolEscenarios.btagregar_nodoClick(Sender: TObject);
begin
  tabcontrol1.Visible:=true;
  btagregar_nodo.Visible:=false;
  btInsertarNodo.Visible:=true;
  btCancelar.Visible:=true;
end;

procedure TFormArbolEscenarios.btOptClick(Sender: TObject);
begin
  Arbol.recorrer_optimizando(arbol.Raiz);
end;

procedure TFormArbolEscenarios.btCancelarClick(Sender: TObject);
begin
  tabcontrol1.Visible:=false;
  btagregar_nodo.Visible:=true;
  btInsertarNodo.Visible:=false;
  btCancelar.Visible:=false;


end;

procedure TFormArbolEscenarios.eFechaChange(Sender: TObject);
begin

end;



procedure TFormArbolEscenarios.btInsertarNodoClick(Sender: TObject);
var
  nod:ptNodo;
  Rama: ptRama;
  Bif: TBifurcacion;
  i:integer;
  capas:TDAofNInt;
begin
  new(nod);
  tabcontrol1.Visible:=false;
  btagregar_nodo.Visible:=true;
  btInsertarNodo.Visible:=false;
  btCancelar.Visible:=false;

  setlength(capas,0);
  bif:=TBifurcacion.Create;
  bif.Tipobifurcacion:=cbTipoBif.Text;
  //Rama:=TRama.Create;

  nod^:=TNodo.Create(eNombre.Text,TFecha.Create_Str(DateToStr(efecha.Date)),nil,bif,False,0);
  for i:=1 to strtoint(eNumRamas.Text) do
      begin
         New(Rama);
         Rama^:=TRama.Create('Rama_'+nod^.Nombre+'_'+inttostr(i),capas,1,nil);
         nod^.agregar_rama(Rama);
      end;
  Arbol.insertar_nodo(Arbol.Raiz,nod);
  sgVistaEscenario.Clean;
  sgVistaEscenario.RowCount:=1;
  Arbol_to_Grid(Arbol.Raiz);
end;





procedure TFormArbolEscenarios.FormClose(Sender: TObject; var CloseAction: TCloseAction);
begin
   AlFinal;
end;

procedure TFormArbolEscenarios.FormCreate(Sender: TObject);
begin
    AlInicio; // procedimiento a agregar antes de cargar las salas.

end;





end.

