unit ubrasil_como_durpat;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls, math,
  uDatosCronicosMensuales, xMatDefs;

type

  { TForm1 }

  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    btEscurrimientosMesToSem: TButton;
    btMes2SemAnomaliaN34: TButton;
    od1: TOpenDialog;
    procedure btMes2SemAnomaliaN34Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure btEscurrimientosMesToSemClick(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end; 

var
  Form1: TForm1;



implementation

{$R *.lfm}


{ TForm1 }


procedure TForm1.Button1Click(Sender: TObject);
var
  archi, r: string;
  fent, fsal: textfile;
  aeco_ini, aeco_fin, naecos: integer;
  cmo_1, cmo_1_2, cmo_2_3: array of NReal;
  derivadas: array of NReal;
  scmo_1, scmo_1_2, scmo_2_3: array of NReal;
  nmeses, nsemanas: integer;
  kmes, ksem: integer;
begin
  if od1.Execute then
  begin
    archi:= od1.FileName;
    assignfile( fent, archi );
    reset( fent );
    readln( fent, aeco_ini );
    readln( fent, aeco_fin );
    naecos:= aeco_fin - aeco_ini + 1;
    readln( fent, r );
    nmeses:= naecos * 12;
    nsemanas:= naecos * 52;

    setlength( cmo_1, nmeses );
    setlength( cmo_1_2, nmeses );
    setlength( cmo_2_3, nmeses );

    for kmes:= 0 to nmeses - 1 do
      readln( fent, cmo_1[kmes], cmo_1_2[kmes], cmo_2_3[kmes] );
    closefile( fent );

    setlength( derivadas, nmeses );

    scmo_1  := resampling( cmo_1   , nsemanas );
    scmo_1_2:= resampling( cmo_1_2 , nsemanas );
    scmo_2_3:= resampling( cmo_2_3 , nsemanas );

    assignfile( fsal, 'series_semanales.xlt' );
    rewrite( fsal );
    for ksem:= 0 to nsemanas - 1 do
    begin
      writeln( fsal, Aeco_Ini + ksem div 52, #9, (ksem mod 52)+1, #9, scmo_1[ ksem ]:12:4, #9, scmo_1_2[ ksem ]:12:4, #9, scmo_2_3[ ksem ]:12:4 );
    end;
    closefile( fsal );
  end;
end;

procedure TForm1.btMes2SemAnomaliaN34Click(Sender: TObject);
var
  archi, r: string;
  fent, fsal: textfile;
  AEcoIni, MesIni, AEcoFin, MesFin: integer;
  datos_semanales, datos_mensuales: TTira;
  kMes, kSem: integer;
  jDato: integer;
  anio, mes: integer;
  nMeses: integer;
  nSemanas: integer;
begin
  setlength( datos_mensuales, 12* 300 );
  if od1.Execute then
  begin
    archi:= od1.FileName;
    assignfile( fent, archi );
    filemode:= 0;
    reset(fent );
    readln( fent, r );
    jDato:= 0;
    while not eof( fent ) do
    begin
      read( fent, anio );
      read( fent, mes );
      readln( fent, datos_mensuales[jDato] );
      if jDato  = 0 then
      begin
         aEcoINi:= anio;
         MesIni:= mes;
      end;
      inc( jDato );
    end;
    closefile( fent );
    setlength( datos_mensuales, jDato );
    aEcoFin:= anio;
    mesFin:= mes;
  end;

  nMeses:= ( aEcoFin - aEcoIni ) *12 + MesFin - MesIni + 1;
  nSemanas:= trunc( nMeses /12.0 * 52.0 + 0.5 );

  datos_semanales:= Resampling( datos_mensuales, nSemanas );

  assignfile( fsal, 'serie_semanal.xlt' );
  filemode:= 2;
  rewrite( fsal );
  for ksem:= 0 to nsemanas - 1 do
     writeln( fsal, AecoIni + ksem div 52, #9, (ksem mod 52)+1, #9, datos_semanales[ ksem ]:12:4);
  closefile( fsal );

end;



procedure TForm1.Button2Click(Sender: TObject);
begin
  if od1.Execute then
  begin
    GenerarSeriesYTendencia( od1.FileName );
  end;
end;

procedure TForm1.btEscurrimientosMesToSemClick(Sender: TObject);
  var
    archi, r: string;
    fent, fsal: textfile;
    aeco_ini, aeco_fin, naecos: integer;
    nseries: integer;

    serie_mensual: array of TDAOfNReal;
    serie_semanal: array of TDAOfNReal;

    nmeses, nsemanas: integer;
    kmes, ksem: integer;
    kserie: integer;
    kAnio, jMes: integer;

  begin
    if od1.Execute then
    begin
      archi:= od1.FileName;
      assignfile( fent, archi );
      reset( fent );
      readln( fent, aeco_ini );
      readln( fent, aeco_fin );
      naecos:= aeco_fin - aeco_ini + 1;

      readln( fent, nseries );
      readln( fent, r );
      readln( fent, r );

      nmeses:= naecos * 12;
      nsemanas:= naecos * 52;

      setlength( serie_mensual, nseries );
      for kserie:= 0 to nseries - 1 do
        setlength( serie_mensual[kserie], nmeses );

      for kmes:= 0 to nmeses - 1 do
      begin

        read( fent, kAnio, jMes );
        jMes:= ( kAnio - aeco_ini ) * 12 + jMes - 1;
        if kmes <> jmes then
          raise Exception.Create( 'No coincideel kMes con el (año,mes) leído ' );

        for kserie:= 0 to nseries - 1 do
          read( fent, serie_mensual[kserie][kmes] );
        readln( fent );
      end;
      closefile( fent );

      setlength( serie_semanal, nseries );
      for kserie:= 0 to nseries - 1 do
        serie_semanal[kserie]:= Resampling( serie_mensual[kserie], nsemanas );


      assignfile( fsal, 'series_semanales.xlt' );
      rewrite( fsal );
      for ksem:= 0 to nsemanas - 1 do
      begin
        write( fsal, Aeco_Ini + ksem div 52, #9, (ksem mod 52)+1 );
        for kserie:= 0 to nseries - 1 do
         write( fsal, #9, serie_semanal[kserie][ ksem ]:12:4 );
        writeln( fsal );
      end;
      closefile( fsal );
    end;
  end;

end.

