unit uColectarSimCostos;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls;

type

  { TForm1 }

  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    cbMultiDir: TCheckBox;
    eNPasos: TEdit;
    Label1:  TLabel;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.lfm}

{ TForm1 }

procedure TForm1.Button1Click(Sender: TObject);
var
  ConP_ct_ve, ConP_ct_var5: array of double;
  SinP_ct_ve, SinP_ct_var5: array of double;
  k:      integer;
  f:      textfile;
  r:      string;
  NPasos: integer;
  acum:   double;

begin
  NPasos := StrToInt(eNPasos.Text);
  setlength(ConP_ct_ve, NPasos);
  setlength(ConP_ct_var5, NPasos);
  setlength(SinP_ct_ve, NPasos);
  setlength(SinP_ct_var5, NPasos);
  for k := 1 to NPasos do
  begin

    assignfile(f, 'C:\simsee\corridas\TDLA2012PronosticosViento\resultados\sim_costo_ConP_'
      +
      IntToStr(k) + '.txt');
    reset(f);
    readln(f, r);
    readln(f, r);
    readln(f, r);

    Read(f, ConP_ct_ve[k - 1]);
    readln(f, r);
    Read(f, ConP_ct_var5[k - 1]);
    closefile(f);

    assignfile(f, 'C:\simsee\corridas\TDLA2012PronosticosViento\resultados\sim_costo_SinP_'
      +
      IntToStr(k) + '.txt');
    reset(f);
    readln(f, r);
    readln(f, r);
    readln(f, r);

    Read(f, SinP_ct_ve[k - 1]);
    readln(f, r);
    Read(f, SinP_ct_var5[k - 1]);
    closefile(f);

  end;

  assignfile(f, 'C:\simsee\corridas\TDLA2012PronosticosViento\Analisis\recolectados.xlt'
    );
  rewrite(f);
  acum := 0;
  writeln(f, #9, 'CT_SinP', #9, 'CT_ConP', #9, 'CT_SinP-CT_ConP', #9, 'dAcum');
  for k := 0 to NPasos - 1 do
  begin
    acum := acum + SinP_ct_ve[k] - ConP_ct_ve[k];
    writeln(f, #9, SinP_ct_ve[k], #9, ConP_ct_ve[k], #9,
      SinP_ct_ve[k] - ConP_ct_ve[k], #9, acum);
  end;

  writeln(f);
  writeln(f, '<CT_SinP-CT_ConP> = ', #9, acum / NPasos);
  closefile(f);

  setlength(ConP_ct_ve, 0);
  setlength(ConP_ct_var5, 0);
  setlength(SinP_ct_ve, 0);
  setlength(SinP_ct_var5, 0);
end;


function nextpal_sep(var r: string; sep: string ): string;
var
  res: string;
  i:   integer;
begin
  r := trim(r);
  i := pos( sep, r);
  if i > 0 then
  begin
    res := trim(copy(r, 1, i - 1));
    Delete(r, 1, i);
  end
  else
  begin
    res := r;
    r   := '';
  end;
  Result := res;
end;


function nextpal_tab(var r: string): string;
begin
  result:= nextpal_sep( r, #9 );
end;




function Get_CDP(archi: string): double;
var
  f:   textfile;
  r:   string;
  pal: string;
  res: double;
begin
  assignfile(f, archi);
  reset(f);
  readln(f, r); // tasa
  readln(f, r); // CT_ve
  readln(f, r); // CT_pe5
  readln(f, r); // CTaux_ve
  readln(f, r); // CTaux_pe5
  readln(f, r); // ct por crónica
  readln(f, r); // ctaux por crónica
  readln(f, r); // cdp por crónica
  pal := nextpal_tab(r);
  res := StrToFloat(nextpal_tab(r));
  closefile(f);
  Result := res;
end;


procedure TForm1.Button2Click(Sender: TObject);
var
  cdp_SinP, cdp_ConP: double;
  diff, acum: double;

  kCron, kPaso: integer;
  seguir: boolean;
  archi_SinP, archi_ConP: string;

  cnt: integer;
  f:   textfile;

begin

  kCron  := 31;
  kPaso  := 1;
  seguir := True;

  acum := 0;
  cnt  := 0;

  assignfile(f,
    'C:\simsee\corridas\TDLA2012PronosticosViento\Analisis\recolectados_cdp_multicronicas.xlt'
    );
  rewrite(f);
  writeln(f, 'kPaso', #9, 'kCron', #9, 'kDia', #9, 'cdp_SinP', #9,
    'cdp_ConP', #9, 'SinP-ConP', #9, 'acum(SinP-ConP)');

  while seguir do
  begin

if not cbMultiDir.Checked then
begin
    archi_SinP := 'C:\simsee\corridas\TDLA2012PronosticosViento\resultados\sim_costo_s'
      +
      IntToStr(kCron) + '_SinP_' + IntToStr(kPaso) + '.txt';
    archi_ConP := 'C:\simsee\corridas\TDLA2012PronosticosViento\resultados\sim_costo_s'
      +
      IntToStr(kCron) + '_ConP_' + IntToStr(kPaso) + '.txt';
end
else
begin
  archi_SinP := 'C:\simsee\corridas\TDLA2012PronosticosViento\resultados\sim_costo\s'
  + IntToStr(kCron) + '\sim_costo_s' +  IntToStr(kCron) + '_SinP_' + IntToStr(kPaso) + '.txt';
  archi_ConP := 'C:\simsee\corridas\TDLA2012PronosticosViento\resultados\sim_costo\s'
  + IntToStr(kCron) + '\sim_costo_s' + IntToStr(kCron) + '_ConP_' + IntToStr(kPaso) + '.txt';
end;
    seguir     := fileExists(archi_SinP) and fileExists(archi_ConP);
    if seguir then
    begin
      cdp_ConP := get_cdp(archi_ConP);
      cdp_SinP := get_cdp(archi_SinP);
      Inc(cnt);
      diff := cdp_SinP - cdp_ConP;
      acum := acum + diff;
      writeln(f, cnt, #9, kCron, #9, kPaso, #9, cdp_SinP, #9,
        cdp_ConP, #9, diff, #9, acum);
      writeln( cnt, #9, kCron, #9, kPaso, #9, cdp_SinP, #9,
        cdp_ConP, #9, diff, #9, acum);
    end;

    Inc(kPaso);
    if kPaso > 366 then
    begin
      Inc(kCron);
      kPaso := 1;
      if kCron > 131 then
        seguir := False;
    end;
  end;

  writeln(f, 'Cnt: ', #9, cnt);
  writeln( 'Cnt: ', cnt);
  if (cnt > 0) then
  begin
    writeln(f, 'Prom: ', #9, acum / cnt);
    writeln( 'Prom: ', acum / cnt);
  end;
  closefile(f);
end;





Type
  TFinJuego = record
    Lluvias_Bonete,
    Lluvias_Palmar,
    Lluvias_Salto,
    PotEol_POT_EOL,
    Bonete_h,
    Palmar_h,
    SG_h: double;
    TVs_X_NMaquinasDespachadas,
    TVs_X_HorasHisteresisAP: integer;
    TVs_FechaCambioEstado_ini: string;
  end;

function Get_FinJuego(archi: string): TFinJuego;
var
  f:   textfile;
  r:   string;

  pal: string;
  res: TFinJuego;

function pp: string;
begin
  readln( f, r );
  pal:= nextpal_sep(r, '=' );
  result:= nextpal_sep(r, '=' );
end;

begin
  assignfile(f, archi);
  reset(f);
  with res do
  begin
  Lluvias_Bonete:= StrToFloat( pp );
  Lluvias_Palmar:= StrToFloat( pp );
  Lluvias_Salto:= StrToFloat( pp );
  PotEol_POT_EOL:= StrToFloat( pp );
  Bonete_h:= StrToFloat( pp );
  Palmar_h:= StrToFloat( pp );
  SG_h:= StrToFloat( pp );
  TVs_X_NMaquinasDespachadas:= StrToInt( pp );
  TVs_X_HorasHisteresisAP:= StrToInt( pp );
  TVs_FechaCambioEstado_ini:= pp;
  end;
  closefile(f);
  Result := res;
end;



procedure TForm1.Button3Click(Sender: TObject);
var
  cdp_SinP, cdp_ConP: double;
  diff, acum: double;

  kCron, kPaso: integer;
  seguir: boolean;
  archi_SinP, archi_ConP: string;

  cnt: integer;
  f:   textfile;

  rec_SinP, rec_ConP: TFinJuego;

begin

  kCron  := 31;
  kPaso  := 1;
  seguir := True;

  acum := 0;
  cnt  := 0;

  assignfile(f,
    'C:\simsee\corridas\TDLA2012PronosticosViento\Analisis\recolectados_fin_de_juego.xlt'
    );
  rewrite(f);

  writeln(f, 'kPaso', #9, 'kCron', #9, 'kDia',
  #9, 'Bsp',
  #9, 'Bcp',
  #9, 'Psp',
  #9, 'Pcp',
  #9, 'Ssp',
  #9, 'Scp',
  #9, 'PEOLsp',
  #9, 'PEOLcp',
  #9, 'hBONsp',
  #9, 'hBONcp',
  #9, 'hPALsp',
  #9, 'hPALcp',
  #9, 'hSGsp',
  #9, 'hSGcp',
  #9, 'TVXsp',
  #9, 'TVXcp',
  #9, 'TVHsp',
  #9, 'TVHcp',
  #9, 'TVFsp',
  #9, 'TVFcp'
    );

  while seguir do
  begin
if not cbMultiDir.Checked then
begin
    archi_SinP := 'C:\simsee\corridas\TDLA2012PronosticosViento\resultados\fin_juego_s'
      +
      IntToStr(kCron) + '_SinP_' + IntToStr(kPaso) + '.txt';
    archi_ConP := 'C:\simsee\corridas\TDLA2012PronosticosViento\resultados\fin_juego_s'
      +
      IntToStr(kCron) + '_ConP_' + IntToStr(kPaso) + '.txt';
end
else
begin
    archi_SinP := 'C:\simsee\corridas\TDLA2012PronosticosViento\resultados\fin_juego\s'+
      IntToStr(kCron) +'\fin_juego_s'
      +
      IntToStr(kCron) + '_SinP_' + IntToStr(kPaso) + '.txt';
    archi_ConP := 'C:\simsee\corridas\TDLA2012PronosticosViento\resultados\fin_juego\s'+
          IntToStr(kCron) +'\fin_juego_s'
      +
      IntToStr(kCron) + '_ConP_' + IntToStr(kPaso) + '.txt';
end;

    seguir     := fileExists(archi_SinP) and fileExists(archi_ConP);
    if seguir then
    begin
      rec_SinP:= Get_FinJuego(archi_SinP);
      rec_ConP:= Get_FinJuego(archi_ConP);
      Inc(cnt);

      writeln(f, cnt, #9, kCron, #9, kPaso,
      #9, rec_SinP.Lluvias_Bonete,
      #9, rec_ConP.Lluvias_Bonete,
      #9, rec_SinP.Lluvias_Palmar,
      #9, rec_ConP.Lluvias_Palmar,
      #9, rec_SinP.Lluvias_Salto,
      #9, rec_ConP.Lluvias_Salto,
      #9, rec_SinP.PotEol_POT_EOL,
      #9, rec_ConP.PotEol_POT_EOL,
      #9, rec_SinP.Bonete_h,
      #9, rec_ConP.Bonete_h,
      #9, rec_SinP.Palmar_h,
      #9, rec_ConP.Palmar_h,
      #9, rec_SinP.SG_h,
      #9, rec_ConP.SG_h,
      #9, rec_SinP.TVs_X_NMaquinasDespachadas,
      #9, rec_ConP.TVs_X_NMaquinasDespachadas,
      #9, rec_SinP.TVs_X_HorasHisteresisAP,
      #9, rec_ConP.TVs_X_HorasHisteresisAP,
      #9, rec_SinP.TVs_FechaCambioEstado_ini,
      #9, rec_ConP.TVs_FechaCambioEstado_ini
        );

    end;

    Inc(kPaso);
    if kPaso > 366 then
    begin
      Inc(kCron);
      kPaso := 1;
      if kCron > 131 then
        seguir := False;
    end;
  end;

  writeln(f, 'Cnt: ', #9, cnt);
  writeln( 'Cnt: ', cnt);
  closefile(f);
end;


function Get_CTAux(archi: string): double;
var
  f:   textfile;
  r:   string;
  pal: string;
  res: double;
begin
  assignfile(f, archi);
  reset(f);
  readln(f, r); // tasa
  readln(f, r); // CT_ve
  readln(f, r); // CT_pe5
  readln(f, r); // CTaux_ve
  pal := nextpal_tab(r);
  res := StrToFloat( pal );
  closefile(f);
  Result := res;
end;



procedure TForm1.Button4Click(Sender: TObject);
var
  CTAux_SinP, CTAux_ConP: double;
  diff, acum: double;

  kCron, kPaso: integer;
  seguir: boolean;
  archi_SinP, archi_ConP: string;

  cnt: integer;
  f:   textfile;

begin

  kCron  := 31;
  kPaso  := 1;
  seguir := True;

  acum := 0;
  cnt  := 0;

  assignfile(f,
    'C:\simsee\corridas\TDLA2012PronosticosViento\Analisis\recolectados_CTAux_multicronicas.xlt'
    );
  rewrite(f);
  writeln(f, 'kPaso', #9, 'kCron', #9, 'kDia', #9, 'CTAux_SinP', #9,
    'CTAux_ConP', #9, 'SinP-ConP', #9, 'acum(SinP-ConP)');

  while seguir do
  begin

if not cbMultiDir.Checked then
begin
    archi_SinP := 'C:\simsee\corridas\TDLA2012PronosticosViento\resultados\sim_costo_s'
      +
      IntToStr(kCron) + '_SinP_' + IntToStr(kPaso) + '.txt';
    archi_ConP := 'C:\simsee\corridas\TDLA2012PronosticosViento\resultados\sim_costo_s'
      +
      IntToStr(kCron) + '_ConP_' + IntToStr(kPaso) + '.txt';
end
else
begin
  archi_SinP := 'C:\simsee\corridas\TDLA2012PronosticosViento\resultados\sim_costo\s'
  + IntToStr(kCron) + '\sim_costo_s' +  IntToStr(kCron) + '_SinP_' + IntToStr(kPaso) + '.txt';
  archi_ConP := 'C:\simsee\corridas\TDLA2012PronosticosViento\resultados\sim_costo\s'
  + IntToStr(kCron) + '\sim_costo_s' + IntToStr(kCron) + '_ConP_' + IntToStr(kPaso) + '.txt';
end;
    seguir     := fileExists(archi_SinP) and fileExists(archi_ConP);
    if seguir then
    begin
      CTAux_ConP := get_CTAux(archi_ConP);
      CTAux_SinP := get_CTAux(archi_SinP);
      Inc(cnt);
      diff := CTAux_SinP - CTAux_ConP;
      acum := acum + diff;
      writeln(f, cnt, #9, kCron, #9, kPaso, #9, CTAux_SinP, #9,
        CTAux_ConP, #9, diff, #9, acum);
    end;

    Inc(kPaso);
    if kPaso > 366 then
    begin
      Inc(kCron);
      kPaso := 1;
      if kCron > 131 then
        seguir := False;
    end;
  end;

  writeln(f, 'Cnt: ', #9, cnt);
  writeln( 'Cnt: ', cnt);
  if (cnt > 0) then
  begin
    writeln(f, 'Prom: ', #9, acum / cnt);
    writeln( 'Prom: ', acum / cnt);
  end;
  closefile(f);
end;





end.

