unit uDiezminToHoraria;


interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  math, xmatdefs, dateutils, ufechas;

type

  { TFormDiezminToHoraria }

  TFormDiezminToHoraria = class(TForm)
    btElegirArchivo: TButton;
    btLeer: TButton;
    btGenHoraria: TButton;
    eArchivo: TEdit;
    OpenDialog1: TOpenDialog;
    procedure btElegirArchivoClick(Sender: TObject);
    procedure btGenHorariaClick(Sender: TObject);
    procedure btLeerClick(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
    datos: TDAOfNReal;
    dt0: TDateTime;

  end;

var
  FormDiezminToHoraria: TFormDiezminToHoraria;

implementation

{$R *.lfm}


{ TFormDiezminToHoraria }

function nextpal( var s: string; sep: string ): string;
var
  i: integer;
  res: string;
begin
  i:= pos( sep, s );
  if i > 0 then
  begin
    res:= copy( s, 1, i-1 );
    s:= copy( s, i+1, length( s ) - i );
  end
  else
  begin
    res:= s;
    s:= '';
  end;
  Result:= res;
end;


const
  mes3c:string = 'enefebmarabrmayjunjulagosepoctnovdic';

procedure TFormDiezminToHoraria.btLeerClick(Sender: TObject);
var
  f: textfile;
  rr, r, pal: string;
  i: integer;
  fecha: TFecha;
  anio, mes, dia, hora, minuto, segundos: word;
  v: NReal;
  rescod: integer;
  cnt: integer;
  cnt_huecos: integer;
  dt: TDateTime;

  minutosDesdePrimerMuestra: NReal;
  npasos: integer;

begin
  assignfile( f, eArchivo.Text );
  reset( f );
  cnt:= 0;
  cnt_huecos:= 0;
  setlength( datos, 6*24*365*2 );
  while not eof( f ) do
  begin
    readln( f, rr );
    r:= rr;
    pal:= nextpal( r, '-' );
    dia:= StrToInt( pal );
    pal:= nextpal( r, '-' );
    i:= pos( pal, mes3c );
    mes:= (( i-1) div 3 ) +1;
    pal:= nextpal( r, ' ' );
    anio:= 2000+StrToInt( pal );
    pal:= nextpal( r, ':' );
    hora:= StrToInt( pal );
    pal:= nextpal( r, ':' );
    minuto:= StrToInt( pal );
    pal:= nextpal( r, ',' );
    segundos:= StrToInt( pal );

    dt:= EncodeDateTime( anio, mes, dia, hora, minuto, segundos, 0 );
    if cnt = 0 then
      dt0:= dt // fecha de inicio.
    else
    begin
      // chequeo de coherencia
      minutosDesdePrimerMuestra:= (dt - dt0 )*24*60; // minutos entre fechas
      npasos:= trunc( minutosDesdePrimerMuestra / 10 + 0.1); // pasos de 10 minutos
      while cnt < npasos do
      begin
        datos[cnt]:= -1111111;
        writeln( 'complentando_huenco_en fecha', rr );
        inc( cnt_huecos );
        inc( cnt );
      end;
    end;

    val( trim( r ), v, rescod );

    if rescod = 0 then
    begin
      datos[cnt]:= v;
    end
    else
    begin
      datos[cnt]:= -1111111;
      writeln( 'error: ', rr );
      inc( cnt_huecos );
    end;
    inc( cnt );
  end;
  closefile( f );
  setlength( datos, cnt );
  writeln('dt_primer_medida: ', DateTimeToIsoStr( dt0 ) );
  writeln('dt_ultima_medida: ', DateTimeToIsoStr( dt ) );
  writeln('Cantidad de muestras: ', cnt );
  writeln('Cantidad de huecos: ', cnt_huecos );
end;

procedure TFormDiezminToHoraria.btElegirArchivoClick(Sender: TObject);
begin
  if OpenDialog1.Execute then
    eArchivo.Text:= OpenDialog1.FileName;
end;

procedure TFormDiezminToHoraria.btGenHorariaClick(Sender: TObject);
var
  primerDia: TDateTime;
  khora, kdia: integer;
  ndias: integer;
  sal: textfile;
  kPrimerMuestra, kPrimerMuestraDeLaHora: integer;
  acum: NReal;
  flg_huecos: boolean;
  kmuestra: integer;
  v: NReal;

begin
  primerDia:= ceil( dt0 - 1/(24*3600) );
  kPrimerMuestra:= trunc(( primerDia - dt0 )*24*6 +0.01 );

  ndias:= trunc( length( datos ) / (24*6) + 0.001 );
  assignfile( sal, 'horaria.xlt' );
  rewrite( sal );
  write( sal, 'día' );
  for khora:= 0 to 23 do
    write( sal, #9, khora );
  writeln( sal );

  for kdia:= 0 to ndias-1 do
  begin
    write( sal, DateTimeToIsoStr( primerDia + kdia ));
    for khora:= 0 to 23 do
    begin
      acum:= 0;
      flg_huecos:= false;
      kPrimerMuestraDeLaHora:= kPrimerMuestra + ( kdia * 24 + khora )* 6;
      for kMuestra:= 1 to 6 do
      begin
        v:= datos[ kPrimerMuestraDeLaHora + kMuestra ];
        if v < -111111 then
        begin
          flg_huecos:= true;
          break;
        end
        else
         acum:= acum + v;
      end;
      if not flg_huecos then
        acum:= acum / 6
      else
        acum:= -111111111;

      write( sal, #9, acum );
    end;
    writeln( sal );
  end;
  closefile( sal );
end;

end.

