unit uEditorProblemasOptSimDis;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  usalasdejuego, uConstantesSimSEE, uInicioYFinal, uNotificar, urosx, ucosa,
  uempaquetar, uCosaConNombre, uVarDefs, u_updownload, ucosaparticipedemercado;

type

  { TformEditorProblemasOptSimDis }

  TformEditorProblemasOptSimDis = class(TForm)
    BCancelar: TButton;
    BGuardar: TButton;
    BSelecSala: TButton;
    CBGuardarSimCosto: TCheckBox;
    CBGuardarSimRes: TCheckBox;
    cbEstabilizarInicio: TCheckBox;
    cbObligarDisponibilidad_1_Opt: TCheckBox;
    cbObligarDisponibilidad_1_Sim: TCheckBox;
    cbResincInicioCronica: TCheckBox;
    cbSortearOpt: TCheckBox;
    cbGuardarCF: TCheckBox;
    CoBTipoProblema: TComboBox;
    EArchivoSala: TEdit;
    Emaxresolvedores: TEdit;
    eMaxNITERSOpt: TEdit;
    eMaxNItersSim: TEdit;
    eNCronicasOpt: TEdit;
    ENCronSim: TEdit;
    ENId: TEdit;
    eSemillaAleatoriaOpt: TEdit;
    eSemillaAleatoriaSim: TEdit;
    eTasaDeActualizacion: TEdit;
    GBOpt: TGroupBox;
    GBSim: TGroupBox;
    GroupBox2: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    lblNCronicasOpt: TLabel;
    lMaxNItersOpt: TLabel;
    lMaxNItersSim: TLabel;
    LNCronSim: TLabel;
    lSemillaAleatoriaOpt: TLabel;
    lSemillaAleatoriaSim: TLabel;
    lTasaDeActualizacionOpt: TLabel;
    memoDescripcion: TMemo;
    ODSala: TOpenDialog;
    procedure BCancelarClick(Sender: TObject);
    procedure BGuardarClick(Sender: TObject);
    procedure BSelecSalaClick(Sender: TObject);
    procedure CoBTipoProblemaChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }

    sala: TSalaDeJuego;
    archiSala_: string;

    salaSeleccionada: boolean;
    nuevo_nidProblema: integer;

    function cargarSala(archiSala: string): boolean;
    procedure liberarSala;

    //La sala tiene que estar cargada
    procedure cargarParametrosSala;

    procedure borrarTEdits;

    //nid | usuario | clave | sala | dt_creacion | activa | avance |
    //nSecsToEnd | dt_actualizacion | tipo | estado | master | maxWks | descripcion
    procedure crearProblema(nid: integer; tipo, descripcion, nombreSala, maxWks: string);

    //| nidProblema | tasa | nCronicas | semilla | maxIter | disponibilidad
    //| sortear | establizarFrameIni | guardarCF
    procedure cargarParametrosOpt(nidProblema: integer;
      tasa, nCronicas, semilla, maxIter: string;
      disponibilidad, sortear, establizarFrameIni, guardarCF: boolean);

    //| nidProblema | nCronicas | semilla | maxIter | disponibilidad
    //| resincIniCron | guardarSimCosto | guardarSimRes
    procedure cargarParametrosSim(nidProblema: integer;
      nCronicas, semilla, maxIter: string;
      disponibilidad, resincIniCron, guardarSimCosto, guardarSimRes: boolean);

  end;

var
  formEditorProblemasOptSimDis: TformEditorProblemasOptSimDis;

implementation

{$R *.lfm}

{ TformEditorProblemasOptSimDis }

procedure TformEditorProblemasOptSimDis.BSelecSalaClick(Sender: TObject);
begin

  ODSala.Title := 'Seleccione Sala';
  ODSala.InitialDir := getDir_Corridas;
  ODSala.Filter := 'Archivos SimSEE|*.ese';
  if ODSala.Execute then
  begin
    archiSala_ := ODSala.FileName;
    EArchivoSala.Text := archiSala_;
    if cargarSala(archiSala_) then
    begin
      eTasaDeActualizacion.Text :=
        FloatToStrF(sala.globs.TasaDeActualizacion, ffGeneral, 6, 3);
      eNCronicasOpt.Text := IntToStr(sala.globs.NCronicasOpt);
      eSemillaAleatoriaOpt.Text := IntToStr(sala.globs.semilla_inicial_opt);
      eMaxNITERSOpt.Text := IntToStr(sala.globs.NMAX_ITERACIONESDELPASO_OPT);
      cbEstabilizarInicio.Checked := sala.estabilizarInicio;
      cbSortearOpt.Checked := sala.globs.SortearOpt;
      cbObligarDisponibilidad_1_Opt.Checked := sala.globs.ObligarDisponibilidad_1_Opt;

      ENCronSim.Text := IntToStr(sala.globs.NCronicasSim);
      eSemillaAleatoriaSim.Text := IntToStr(sala.globs.semilla_inicial_sim);
      eMaxNItersSim.Text := IntToStr(sala.globs.NMAX_ITERACIONESDELPASO_SIM);
      cbResincInicioCronica.Checked := sala.RandSeed_SincronizarAlInicioDeCadaCronica;
      cbObligarDisponibilidad_1_Sim.Checked := sala.globs.ObligarDisponibilidad_1_Sim;

      GBOpt.Enabled := True;
      GBSim.Enabled := True;
    end;

  end;
end;


procedure TformEditorProblemasOptSimDis.CoBTipoProblemaChange(Sender: TObject);
begin

end;

procedure TformEditorProblemasOptSimDis.FormCreate(Sender: TObject);
begin
  salaSeleccionada := False;

end;

procedure TformEditorProblemasOptSimDis.FormDestroy(Sender: TObject);
begin
  if salaSeleccionada then
    liberarSala;

end;

function TformEditorProblemasOptSimDis.cargarSala(archiSala: string): boolean;
begin
  try
    Result := True;
    uInicioYFinal.AlInicio;
    sala := TSalaDeJuego.cargarSala(archiSala, '__principal__', True);
    salaSeleccionada := True;
  except
    uNotificar.notificar('La sala no pudo ser cargada', True);
    Result := False;
    exit;
  end;

end;

procedure TformEditorProblemasOptSimDis.liberarSala;
begin
  sala.Free;
  AlFinal;
  salaSeleccionada := False;
end;

procedure TformEditorProblemasOptSimDis.cargarParametrosSala;
begin
  sala.globs.TasaDeActualizacion := StrToFloat(eTasaDeActualizacion.Text);
  sala.globs.NCronicasOpt := StrToInt(eNCronicasOpt.Text);
  sala.globs.semilla_inicial_opt := StrToInt(eSemillaAleatoriaOpt.Text);
  sala.globs.NMAX_ITERACIONESDELPASO_OPT := StrToInt(self.eMaxNITERSOpt.Text);
  sala.estabilizarInicio := cbEstabilizarInicio.Checked;
  sala.globs.SortearOpt := cbSortearOpt.Checked;
  sala.globs.ObligarDisponibilidad_1_Opt := cbObligarDisponibilidad_1_Opt.Checked;

  sala.globs.NCronicasSim := StrToInt(ENCronSim.Text);
  sala.globs.semilla_inicial_sim := StrToInt(eSemillaAleatoriaSim.Text);
  sala.globs.NMAX_ITERACIONESDELPASO_SIM := StrToInt(self.eMaxNItersSim.Text);
  sala.RandSeed_SincronizarAlInicioDeCadaCronica :=
    self.cbResincInicioCronica.Checked;
  sala.globs.ObligarDisponibilidad_1_Sim := cbObligarDisponibilidad_1_Sim.Checked;
end;

procedure TformEditorProblemasOptSimDis.borrarTEdits;
begin

  ENId.Text := '';
  EArchivoSala.Text := '';

  eTasaDeActualizacion.Text := '';
  eNCronicasOpt.Text := '';
  eSemillaAleatoriaOpt.Text := '';
  eMaxNITERSOpt.Text := '';

  cbEstabilizarInicio.Checked := False;
  cbSortearOpt.Checked := False;
  cbObligarDisponibilidad_1_Opt.Checked := False;

  ENCronSim.Text := '';
  eSemillaAleatoriaSim.Text := '';
  eMaxNItersSim.Text := '';

  cbResincInicioCronica.Checked := False;
  cbObligarDisponibilidad_1_Sim.Checked := False;

end;

procedure TformEditorProblemasOptSimDis.crearProblema(nid: integer;
  tipo, descripcion, nombreSala, maxWks: string);
var

  sql: string;
  str_nombres, str_valores: string;

begin

  AppendToInsertStr(str_nombres, str_valores, 'nid', IntToStr(nid), True);
  AppendToInsertStr(str_nombres, str_valores, 'dt_creacion', 'now()', False);
  AppendToInsertStr(str_nombres, str_valores, 'dt_actualizacion', 'now()', False);
  AppendToInsertStr(str_nombres, str_valores, 'tipo', tipo, True);
  AppendToInsertStr(str_nombres, str_valores, 'descripcion', descripcion, True);
  AppendToInsertStr(str_nombres, str_valores, 'sala', nombreSala, True);
  AppendToInsertStr(str_nombres, str_valores, 'maxWks', maxWks, True);

  sql := 'INSERT INTO clt_problemas ( ' + str_nombres + ' ) VALUES ( ' + str_valores + ' ) ';

  //writeln( sql );
  urosx.sql_exec(sql);

end;

procedure TformEditorProblemasOptSimDis.cargarParametrosOpt(nidProblema: integer;
  tasa, nCronicas, semilla, maxIter: string;
  disponibilidad, sortear, establizarFrameIni, guardarCF: boolean);
var

  sql: string;
  str_nombres, str_valores: string;

begin

  AppendToInsertStr(str_nombres, str_valores, 'nidProblema', IntToStr(nidProblema), True);
  AppendToInsertStr(str_nombres, str_valores, 'tasa', tasa, True);
  AppendToInsertStr(str_nombres, str_valores, 'nCronicas', nCronicas, True);
  AppendToInsertStr(str_nombres, str_valores, 'semilla', semilla, True);
  AppendToInsertStr(str_nombres, str_valores, 'maxIter', maxIter, True);
  AppendToInsertStr(str_nombres, str_valores, 'disponibilidad',
    BoolToStr(disponibilidad, '1', '0'), True);
  AppendToInsertStr(str_nombres, str_valores, 'sortear',
    BoolToStr(sortear, '1', '0'), True);
  AppendToInsertStr(str_nombres, str_valores, 'establizarFrameIni',
    BoolToStr(establizarFrameIni, '1', '0'), True);
  AppendToInsertStr(str_nombres, str_valores, 'guardarCF',
    BoolToStr(guardarCF, '1', '0'), True);

  sql := 'INSERT INTO clt_parametrosOpt ( ' + str_nombres + ' ) VALUES ( ' +
    str_valores + ' ) ';

  writeln(sql);
  urosx.sql_exec(sql);

end;

procedure TformEditorProblemasOptSimDis.cargarParametrosSim(nidProblema: integer;
  nCronicas, semilla, maxIter: string;
  disponibilidad, resincIniCron, guardarSimCosto, guardarSimRes: boolean);
var

  sql: string;
  str_nombres, str_valores: string;

begin

  AppendToInsertStr(str_nombres, str_valores, 'nidProblema', IntToStr(nidProblema), True);
  AppendToInsertStr(str_nombres, str_valores, 'nCronicas', nCronicas, True);
  AppendToInsertStr(str_nombres, str_valores, 'semilla', semilla, True);
  AppendToInsertStr(str_nombres, str_valores, 'maxIter', maxIter, True);
  AppendToInsertStr(str_nombres, str_valores, 'disponiblidad',
    BoolToStr(disponibilidad, '1', '0'), True);
  AppendToInsertStr(str_nombres, str_valores, 'resincIniCron',
    BoolToStr(resincIniCron, '1', '0'), True);
  AppendToInsertStr(str_nombres, str_valores, 'guardarSimCosto',
    BoolToStr(guardarSimCosto, '1', '0'), True);
  AppendToInsertStr(str_nombres, str_valores, 'guardarSimRes',
    BoolToStr(guardarSimRes, '1', '0'), True);

  sql := 'INSERT INTO clt_parametrosSim ( ' + str_nombres + ' ) VALUES ( ' +
    str_valores + ' ) ';

  //writeln( sql );
  urosx.sql_exec(sql);

end;

procedure TformEditorProblemasOptSimDis.BGuardarClick(Sender: TObject);
var
  f: TArchiTexto;
  zipname: string;
  nid_carpeta: integer;
  res: integer;
  tipoProblema: string;
begin

  if salaSeleccionada then
  begin
    nuevo_nidProblema := urosx.sql_nextnid('clt_problemas');
    cargarParametrosSala;
    f := TArchiTexto.CreateForWrite(archiSala_, False, 0);
    try
      begin
        f.wr('sala', TSalaDeJuego(sala));
        f.Free;
      end
    except
      uNotificar.notificar('La sala no pudo ser guardada', True);
      borrarTEdits;
      GBOpt.Enabled := False;
      GBSim.Enabled := False;
      f.Free;
      exit;
    end;
    zipname := uempaquetar.EmpaquetarSalaEnZip(archiSala_, nil);

    liberarSala;

    nid_carpeta := crear_carpeta('clt_carpetas', 'clt_archivos', 'clt_' +
      IntToStr(nuevo_nidProblema), 1,
      'Datos sala SimSEE.', True);

    unotificar.esperando_inicio('Subiendo archivo empaquetado.');
    res := upload_archi('clt_archivos', nid_carpeta, zipname);
    unotificar.esperando_fin;

    if res >= 0 then
    begin
      case CoBTipoProblema.ItemIndex of
        1:
        begin
          tipoProblema := 'OPT';
          cargarParametrosOpt(nuevo_nidProblema, eTasaDeActualizacion.Text,
            eNCronicasOpt.Text,
            eSemillaAleatoriaOpt.Text,
            eMaxNITERSOpt.Text, cbObligarDisponibilidad_1_Opt.Checked,
            cbSortearOpt.Checked,
            cbEstabilizarInicio.Checked, cbGuardarCF.Checked);
        end;
        2:
        begin
          tipoProblema := 'SIM';
          cargarParametrosSim(nuevo_nidProblema, ENCronSim.Text,
            eSemillaAleatoriaSim.Text,
            eMaxNItersSim.Text,
            cbObligarDisponibilidad_1_Sim.Checked,
            cbResincInicioCronica.Checked,
            CBGuardarSimCosto.Checked,
            CBGuardarSimRes.Checked);
        end;
        3:
        begin
          tipoProblema := 'OyS';
          cargarParametrosOpt(nuevo_nidProblema, eTasaDeActualizacion.Text,
            eNCronicasOpt.Text,
            eSemillaAleatoriaOpt.Text,
            eMaxNITERSOpt.Text, cbObligarDisponibilidad_1_Opt.Checked,
            cbSortearOpt.Checked,
            cbEstabilizarInicio.Checked, cbGuardarCF.Checked);

          cargarParametrosSim(nuevo_nidProblema, ENCronSim.Text,
            eSemillaAleatoriaSim.Text,
            eMaxNItersSim.Text,
            cbObligarDisponibilidad_1_Sim.Checked,
            cbResincInicioCronica.Checked,
            CBGuardarSimCosto.Checked,
            CBGuardarSimRes.Checked);

        end;
      end;

      crearProblema(nuevo_nidProblema, tipoProblema,
        memoDescripcion.Lines.DelimitedText,
        ExtractFileName(archiSala_), Emaxresolvedores.Text);

      unotificar.notificar(
        'El archivo fue subido exitosamente. Nid asignado: ' + IntToStr(res));
    end
    else
      unotificar.notificar(
        'Ojo, falló la subida del archivo. ' + u_updownload.UltimoError, True);
  end;

  self.Close;

end;

procedure TformEditorProblemasOptSimDis.BCancelarClick(Sender: TObject);
begin

  ModalResult := 0;
  self.Close;

end;

end.
