unit uFormGestorProblemasOptSimDis;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, ComCtrls,
  StdCtrls, uEditorProblemasOptSimDis,
  uListadoProblemasOptSimDis, uNotificar, urosx, uempaquetar;

type

  { TformGestorProblemasOptSimDis }

  TformGestorProblemasOptSimDis = class(TForm)
    BIngresar: TButton;
    BProblemaNuevo: TButton;
    BRefrescar: TButton;
    Button1: TButton;
    GroupBox1: TGroupBox;
    PCEditor: TPageControl;
    ScrollBox1: TScrollBox;
    TSIngreso: TTabSheet;
    TSListaProblemas: TTabSheet;
    procedure BIngresarClick(Sender: TObject);
    procedure BProblemaNuevoClick(Sender: TObject);
    procedure BRefrescarClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);

  private
    { private declarations }
  public
    { public declarations }
    lista_problemas: TListadoProblemasOptSimDis;

    //La sala tiene que estar cargada

  end;

var
  formGestorProblemasOptSimDis: TformGestorProblemasOptSimDis;
  nuevo_nidProblema: Integer;

implementation

{$R *.lfm}

{ TformGestorProblemasOptSimDis }

procedure TformGestorProblemasOptSimDis.BIngresarClick(Sender: TObject);
var
  str: string;
begin

//  urosx.proxy_host:= trim( eproxy_host.text );
//  urosx.proxy_port:= trim( eproxy_puerto.text );
//  urosx.proxy_user:= trim( eproxy_user.text );
//  urosx.proxy_pass:= trim( eproxy_pass.text );
//  urosx.usuario_email:= trim( eUsuarioSimSEE.text );
  try
    unotificar.esperando_inicio('... Intentando conexión con servidor IIE-FING ....');
    str:= sql_func( 'SELECT count(*) FROM clt_problemas WHERE 1' );
    unotificar.esperando_fin;

    if str <> '' then
      begin
        if str = '0' then
         begin
          self.BProblemaNuevo.Click;
         end
       else
         begin
          PCEditor.TabIndex:= 1;
          lista_problemas.flg_populate:=true;
         end;
      end
    else
      unotificar.notificar( 'No fue posible conectarse al servidor. Si usted está detrás de un PROXY debe configurarlo.', true );

  finally

  end;
end;

procedure TformGestorProblemasOptSimDis.BProblemaNuevoClick(Sender: TObject);
var
  nid_problema: integer;
  sql: string;

  formEP: TformEditorProblemasOptSimDis;
  res: Integer;
begin


  formEP := TformEditorProblemasOptSimDis.Create(self);

  res := formEP.ShowModal;
  if res > 0 then
  begin
    lista_problemas.flg_populate := True;
    lista_problemas.invalidate;
  end;

  formEP.Free;

end;

procedure TformGestorProblemasOptSimDis.BRefrescarClick(Sender: TObject);
begin

end;

procedure TformGestorProblemasOptSimDis.Button1Click(Sender: TObject);
var
  lst: TStringList;
begin
  lst := TStringList.Create;
  lst.Add('C:\simsee\simsee_src\src\buildRelease.sh');
  lst.Add('C:\simsee\simsee_src\src\buildRelease32.sh');
  writeln (uempaquetar.zipearListaDeArchivos(lst, 'zipPrueba'));

end;

procedure TformGestorProblemasOptSimDis.FormCreate(Sender: TObject);
begin

  PCEditor.TabIndex:= 0;
  lista_problemas := TListadoProblemasOptSimDis.Create( scrollbox1, 'lista_problemas' );
  lista_problemas.Parent:= scrollbox1;
  lista_problemas.flg_populate:= false;

end;

end.

