unit uListadoProblemasOptSimDis;

{$mode delphi}

interface

uses
  SysUtils, Classes, Controls,
  Forms,
  Graphics,
  urosx, uDataSetGenerico,
  StdCtrls, uvisordetabla,
  uempaquetar,
  uconstantesSimSEE, unotificar,
  u_updownload, uListadoProblemas, windows, uVisorProblemasOptSimDis;

type

  { TListadoProblemasOptSimDis }

  TListadoProblemasOptSimDis = class ( TListadoProblemas )
    public

      procedure Editar_onClick(nidRec: string; kFila: integer);override;
      procedure Borrar_OnClick(nidRec: string; kFila: integer);override;
      procedure SemaforoRojo_OnClick(nidRec: string; kFila: integer); override;
      procedure SemaforoVerde_OnClick(nidRec: string; kFila: integer); override;
      procedure reset_OnClick(nidRec: string; kFila: integer); override;
      procedure Lupa_OnClick(nidRec: string; kFila: integer); override;

      procedure Populate;override;

      function eliminarProblema( nidCarpeta: string ): boolean;

  end;

procedure CrearTablaProblemas;

implementation

procedure CrearTablaProblemas;
var
  sql: string;

begin

  /// FALTA AGREGAR EL SCRIPT

  //sql := 'CREATE TABLE `clt_problemas` ('...

urosx.sql_exec( sql );


end;

{ TListadoProblemasOptSimDis }

procedure TListadoProblemasOptSimDis.Editar_onClick(nidRec: string;
  kFila: integer);
var
  dirTemp: string;
begin

  dirTemp := getDir_Tmp+'clt_'+nidRec;
  if not DirectoryExists(dirTemp) then
      CreateDir(dirTemp);

  if bajarCarpeta('clt_carpetas','clt_archivos', StrToInt(nidRec), dirTemp) then
  else
    begin

    end;


end;

procedure TListadoProblemasOptSimDis.Borrar_OnClick(nidRec: string;
  kFila: integer);
begin

  self.eliminarProblema( nidRec );
  flg_populate:= true;
  Invalidate;

end;


procedure TListadoProblemasOptSimDis.SemaforoRojo_OnClick(nidRec: string;
  kFila: integer);
var
  sql: string;
begin
  sql := 'UPDATE clt_problemas SET activa = 1 WHERE nid = ' + nidRec + ' LIMIT 1 ';
  urosx.sql_exec(sql);
  flg_populate := True;
  invalidate;
end;

procedure TListadoProblemasOptSimDis.SemaforoVerde_OnClick(nidRec: string;
  kFila: integer);
var
  sql: string;
begin
  sql := 'UPDATE clt_problemas SET activa = 0 WHERE nid = ' + nidRec + ' LIMIT 1 ';
  urosx.sql_exec(sql);
  flg_populate := True;
  invalidate;
end;

procedure TListadoProblemasOptSimDis.reset_OnClick(nidRec: string;
  kFila: integer);
var
  sql: String;
begin

  sql := 'UPDATE clt_problemas SET activa=0, master=-1, estado=0 WHERE nid = ' + nidRec + ' LIMIT 1 ';
  urosx.sql_exec( sql );
  flg_populate := True;
  invalidate;

end;

procedure TListadoProblemasOptSimDis.Lupa_OnClick(nidRec: string; kFila: integer
  );
var
 form: TformVisorProblemasOptSimDis;
begin
 form := TformVisorProblemasOptSimDis.Create(self);
 form.nidProblema := nidRec;
 form.Show;
end;


procedure TListadoProblemasOptSimDis.Populate;
var
  k: Integer;
  snid: string;
  ds: TResultadoQuery;
  r: TDataRecord;
  activa: Integer;
  estado: Integer;
begin

  flg_populate:= false;
  ds:= TResultadoQuery.CreateQuery('SELECT nid, dt_creacion, sala, tipo, estado, descripcion, activa FROM clt_problemas ORDER BY nid DESC');
  if ds = nil then
    raise Exception.Create( urosx.ultimoError );

  ClearRedim( ds.nrows + 1, 8 );
  // fila encabezado
  wrTexto('', 0, 0, 'NID');
  wrTexto('', 0, 1, 'dt_creacion');
  wrTexto('', 0, 2, 'Sala');
  wrTexto('', 0, 3, 'tipo');
  wrTexto('', 0, 4, 'estado');
  wrTexto('', 0, 5, 'Descripcion');

  AlinearCelda(0, 0, CAH_Izquierda, CAV_Centro );
  AlinearCelda(0, 1, CAH_Izquierda, CAV_Centro );
  AlinearCelda(0, 2, CAH_Izquierda, CAV_Centro );
  AlinearCelda(0, 3, CAH_Izquierda, CAV_Centro );
  AlinearCelda(0, 4, CAH_Izquierda, CAV_Centro );
  AlinearCelda(0, 5, CAH_Izquierda, CAV_Centro );

  Self.SetBgColorFila(0, clNavy );
  Self.SetFontColorFila( 0, clYellow );

  Self.SetBgColorCelda(0, 0, clNavy );
  Self.SetBgColorCelda(0, 1, clNavy );

  k:= 1;
  r:= ds.first;
  while not ds.eof do
  begin
    snid:= r.GetByIdAsString(0);
    activa:= r.GetByNameAsInt( 'activa' );
    wrTexto('', k, 0, r.GetByNameAsString('nid'));
    wrTexto('', k, 1, r.GetByNameAsString('dt_creacion'));
    wrTexto('', k, 2, ExtractFileName(r.GetByNameAsString('sala')) );
    wrTexto('', k, 3, r.GetByNameAsString('tipo'));
    estado:=r.GetByNameAsInt('estado');
    //Estados del problema:
    // -2 : Problema cancelado
    // -1 : Problema abortado
    //  0 : Problema sin Master
    //  1 : Problema con Master
    //  2 : Problema en progreso
    //  3 : Problema finalizado
    case estado of
        -2: wrTexto('', k, 4, 'Cancelado');
        -1: wrTexto('', k, 4, 'Abortado');
        0 : wrTexto('', k, 4, 'sin master');
        1 : wrTexto('', k, 4, 'con master');
        2 : wrTexto('', k, 4, 'Procesando');
        3 : wrTexto('', k, 4, 'Finalizado');
    end;

    wrTexto('', k, 5, r.GetByNameAsString('descripcion'));

    AlinearCelda(k, 0, CAH_Izquierda, CAV_Centro );
    AlinearCelda(k, 1, CAH_Izquierda, CAV_Centro );
    AlinearCelda(k, 2, CAH_Izquierda, CAV_Centro );
    AlinearCelda(k, 3, CAH_Izquierda, CAV_Centro );
    AlinearCelda(k, 4, CAH_Izquierda, CAV_Centro );
    AlinearCelda(k, 5, CAH_Izquierda, CAV_Centro );

    // ahora la botonera en la última columna
    wrBotonera( snid, k, 6,
                [ iid_fdownload,
                  iid_Editar,
                  iid_Reset,
                  iid_Borrar],
                [ hintPorDefecto(iid_fdownload),
                  hintPorDefecto(iid_Editar),
                  hintPorDefecto(iid_Reset),
                  hintPorDefecto(iid_Borrar),
                  hintPorDefecto(iid_Lupa)]
                  );

    if ( activa = 0 ) then
        wrBotonera( snid, k, 7,[ iid_SemaforoRojo ],['Activar'])
    else
      wrBotonera( snid, k, 7,[ iid_SemaforoVerde ],['Desactivar']);

    wrBotonera( snid, k, 7, [iid_Lupa], [ hintPorDefecto(iid_Lupa)]);



    if (k mod 2) = 0 then
      if activa = 0 then
       SetBgColorFila(k, clFondoFilaPar_Inactiva )
      else
       SetBgColorFila(k, clFondoFilaPar_Activa )
    else
      if activa = 0 then
        SetBgColorFila(k, clFondoFilaImpar_Inactiva )
      else
        SetBgColorFila(k, clFondoFilaImpar_Activa );

    inc( k );
    r:= ds.next;
  end;

  reposicionar;
end;

function TListadoProblemasOptSimDis.eliminarProblema(nidCarpeta: string
  ): boolean;
var
  pathCarpeta: String;
  texto: String;
  sql: string;
begin

  result:= false;
  texto:= '¿Confirma que desea eliminar el Problema: ' + nidCarpeta + ' con todos sus archivos?';

  if confirmar( texto, ['Si', 'No' ] ) = 'Si' then
  begin

    clear_carpeta('clt_archivos', StrToInt(nidCarpeta));
    sql:= 'DELETE FROM clt_carpetas WHERE nid = ' + nidCarpeta;

    if not sql_exec( sql ) then
      raise Exception.Create( urosx.UltimoError );

    sql:= 'DELETE FROM clt_problemas WHERE nid = ' + nidCarpeta;
    if not sql_exec( sql ) then
      raise Exception.Create( urosx.UltimoError );

    result:= true;
  end

end;

end.
