unit upoloptgraf;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    OpenDialog1: TOpenDialog;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}


function nextpal( var r: string ): string;
var
  i: integer;
  res: string;
begin
  i:= pos( #9, r );
  if ( i = 0 ) then
  begin
    res:= trim(r);
    r:= '';
  end
  else
  begin
    res:= copy( r, 1, i-1 );
    delete( r, 1, i );
  end;
  result:= res;
end;

function nextfloat( var r: string ): double;
var
  res: string;
begin
  res:= nextpal( r );
  result:= StrToFloat( res );
end;

function interpolar(
  cota, cva: array of double;
  cvCtr: double;
  iIni, iFin: integer ): double;
var
  i: integer;
  buscando: boolean;
  cvIni: double;
  res: double;
  m: double;
begin
  if cvCtr > cva[ iIni ] then
  begin
    result:= cota[iIni ];
    exit;
  end;

  if cvCtr < cva[ iFin]  then
  begin
    result:= cota[iFin];
    exit;
  end;

  buscando:= true;
  i:= iIni;
  while buscando and ( i < iFin ) do
  begin
    if cva[i+1] <= cvCTR then
      buscando:= false
    else
      inc( i );
  end;
  if buscando then
    res:= cota[iFin]
  else
  begin
    m:= cva[ i+1] - cva[i];
    if abs(m) < 1e-5 then
      res:= cota[ i+1]
    else
      res:= cota[i]+ (cota[i+1]-cota[i])/m*(cvCTR- cva[i] );
  end;

  result:= res;
end;




procedure procesarArchivo(
  casostr: string;
  archi: string;
  AnioIni, AnioFin: integer;
  cvCTR: double );

var
  f: textfile;
  r: string;
  buscando: boolean;
  cota: array of double;
  ce: array of double;
  pal: string;
  k: Integer;

  cva: array of double;
  hCTR: array of array of double;
  dtstr: array of string;
  anio: integer;
  idato: integer;
  i: Integer;

  archisal: string;
  j: Integer;

begin
  assignfile( f, archi );
  reset(f );

  archisal:= archi;
  i:= pos( '.', archi );
  delete( archisal, i, length( archisal ) - i +1 );
  archisal:= archisal+'_CVCTR_'+FloatToStr(trunc(cvCTR*10))+'.xlt';
  setlength( cota, 50 );
  setlength( ce, 50 );
  setlength( cva, 50 );
  setlength( hCTR, 5 );
  for I := 0 to 4 do
    setlength( hCTR[i],  53 * 2 );
  setlength( dtstr, 53 *2 );

  buscando:= true;
  while buscando and not eof( f ) do
  begin
    readln( f, r );
    if pos( 'paso\estado', r ) <> 0 then
      buscando:= false;
  end;

  if buscando then
    raise Exception.Create('Ojo, no encontre inicio de datos' );

  pal:= nextpal( r );
  pal:= nextpal( r );

  for k:= 0 to high( cota ) do
  begin
    cota[k]:= nextfloat( r );
    ce[k]:= ( cota[k] - 5.05 ) *0.87 *9.8 *1000.0 / 3600.0;
  end;

  buscando:= true;

  idato:= 0;
  while not eof(f ) do
  begin
    readln( f, r );
    pal:= nextpal( r );
    pal:= nextpal( r );
    anio:= StrToInt( copy ( pal, 1, 4 ) );
    if (anio >= anioIni) and ( anio <= anioFin ) then
    begin
      dtstr[idato]:= pal;
      for k:= 0 to high( cva ) do
        cva[k]:= nextfloat( r ) / ce[k];
      for i:= 0 to 4 do
        hCTR[i][idato]:= interpolar( cota, cva, cvCtr, i*10, (i+1)*10-1 );
      inc( idato );
    end;
  end;
  closefile( f );

  assignfile( f, archisal );
  rewrite( f );

  write( f, 'fecha' );
  for j:= 0 to 4 do
    write( f, #9,'h',(j+1),'_'+casostr );
  writeln( f );

  for i:= 0 to idato-1 do
  begin
    write( f, dtstr[i] );
    for j:= 0 to 4 do
      write( f, #9, hCTR[j][i]: 12:2 );
    writeln( f );
  end;
  closefile( f );


   for I := 0 to 4 do
    setlength( hCTR[i],  0);

  setlength( cota, 0 );
  setlength( cva, 0 );
  setlength( hCTR, 0 );
  setlength( dtstr, 0 );

end;


procedure TForm1.Button1Click(Sender: TObject);
var
  bd: string;
begin
  if OpenDialog1.Execute then
    procesarArchivo( 'x', OpenDialog1.FileName, 2012, 2013, 200 );


  (*
  bd:= 'C:\Users\rchaer\Desktop\ADME\Estudios\influcvr\';

  procesarArchivo( '50_10', bd+'50_10_optBonete_31x10.xlt', 2009, 2010, 145.4 );
  procesarArchivo( '50_15', bd+'50_15_optBonete_31x10.xlt', 2009, 2010, 145.4 );
  procesarArchivo( '50_20', bd+'50_20_optBonete_31x10.xlt', 2009, 2010, 145.4 );
  procesarArchivo( '50_100', bd+'50_100_optBonete_31x10.xlt', 2009, 2010, 145.4 );

  procesarArchivo( '100_10', bd+'100_10_optBonete_31x10.xlt', 2009, 2010, 145.4*1.9 );
  procesarArchivo( '100_15', bd+'100_15_optBonete_31x10.xlt', 2009, 2010, 145.4*1.9 );
  procesarArchivo( '100_20', bd+'100_20_optBonete_31x10.xlt', 2009, 2010, 145.4*1.9 );
  procesarArchivo( '100_100', bd+'100_100_optBonete_31x10.xlt', 2009, 2010, 145.4*1.9 );
    *)
end;

end.
