unit uPosterizadorDeEstadosMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, uDTResultados, uAuxiliares, uExcelFile, xMatDefs, XLConst;

type
  TForm1 = class(TForm)
    LNArch: TLabel;
    ENArch: TEdit;
    BBuscar: TButton;
    BGenerarSalida: TButton;
    OpenDialog1: TOpenDialog;
    procedure BBuscarClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BGenerarSalidaClick(Sender: TObject);
  private
    datosOpt: DTResultadosOpt;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

function nroColToExcelStrCol(nroCol: Integer) : String;

implementation

uses uconstantesSimSEE;

{$R *.dfm}

procedure TForm1.BBuscarClick(Sender: TObject);
begin
  if OpenDialog1.Execute then
  begin
    ENArch.Text:= OpenDialog1.FileName;
    datosOpt:= DTResultadosOpt.Create(OpenDialog1.FileName);
    datosOpt.readDatosOpt;
  end;
end;

procedure TForm1.BGenerarSalidaClick(Sender: TObject);
const
  anchoCol = 80;
  altoFil = 17;
  multAncho = 6;    //6 Columnas
  multAlto = 10;    //* 10 Filas

var
  linea: String;
  f: TextFile;
  sal: TExcelFile;

  iNumEstado, iEstadoVar: Integer;
  nFilasHastaSalto: Integer;
  hojaDatos, hojag, hojaPoster, ARange: Variant;
  colIni, colFin: String;
  filaIni, filaFin: Integer;
  maxY, Yact: NReal;
  filaGraficos, colGraficos: Integer;

procedure writeEncabVar(var xls: TExcelFile; iDescVar: Integer);
var
  i: Integer;
begin
  xls.write('EstadoResto\Estado' + datosOpt.descVars[iDescVar].nombre);
  for i:= 0 to datosOpt.descVars[iDescVar].nDiscs -1 do
    xls.Write('e' + FloatToStrF(datosOpt.descVars[iDescVar].discretizaciones[i], ffFixed, 8, 1));
  xls.writeln('');
end;

begin
  AssignFile(f, ENArch.Text);
  reset(f);
  repeat
    Readln(f, linea);
  until linea = '';
  readln(f, linea);
  repeat
    Readln(f, linea);
  until NextInt(linea) = 1;
  NextPal(linea);
  CloseFile(f);
  nFilasHastaSalto:= datosOpt.descVars[1].nDiscs * datosOpt.descVars[2].nDiscs *
                     datosOpt.descVars[3].nDiscs;

  sal:= TExcelFile.Create('datos', true, true, true);
  hojaDatos:= sal.Hoja('datos');
  colIni:= nroColToExcelStrCol(2);
  colFin:= nroColToExcelStrCol(1 + datosOpt.descVars[0].nDiscs);
  maxY:= 0;

  iNumEstado:= 0;
  writeEncabVar(sal, 0);
  while iNumEstado < datosOpt.nEstrellasPorPuntoT do
  begin
    sal.Write((iNumEstado div datosOpt.descVars[0].nDiscs) + 1);
    for iEstadoVar:= 0 to datosOpt.descVars[0].nDiscs - 1 do
    begin
      sal.Write(NextPal(linea));
      inc(iNumEstado);
    end;
    sal.writeln('');

    if iNumEstado mod (nFilasHastaSalto * datosOpt.descVars[0].nDiscs) = 0 then
    begin
      sal.v.Workbooks[1].Sheets.Add(,,1,xlChart);
      hojag:= sal.v.Workbooks[1].Sheets[1];
      hojag.ChartType:= xlLineMarkers;
      hojag.Name:= 'g_' {+ datosOpt.descVars[3].nombre + IntToStr(datosOpt.iEstadoVar(3, iNumEstado - 1)) +
                   '_'} + datosOpt.descVars[4].nombre + IntToStr(datosOpt.iEstadoVar(4, iNumEstado - 1));

      filaIni:= sal.fila - nFilasHastaSalto - 1;
      filaFin:= sal.fila - 1;
      ARange:= hojaDatos.Range[colIni + IntToStr(filaIni) + ':' + colFin + IntToStr(filaFin)];

      hojag.SetSourceData( ARange, xlColumns );
      hojag.PlotArea.Interior.ColorIndex:= 2;

      Yact:= hojag.Axes(xlValue).MaximumScale;
      if maxY < Yact then
        maxY:= Yact;

      sal.writeln('');
      sal.writeln('');
      writeEncabVar(sal, 0);
    end;
  end;

  sal.agregoHoja('Poster');
  hojaPoster:= sal.Hoja('Poster');
  filaGraficos:= 4;
  colGraficos:= 4;
  for iEstadoVar:= 1 to sal.v.Workbooks[1].Charts.Count do
  begin
    hojag:= sal.v.Workbooks[1].Charts[iEstadoVar];
    hojag.Axes(xlValue).MaximumScale:= maxY;

{    hojag.Select;
    sal.v.Selection.Copy;
    hojaPoster.Paste;
    hojaPoster.ChartObjects('Grfico '+ IntToStr(iEstadoVar)).Activate;

    ARange:= sal.v.ActiveChart;
    ARange.Width:= anchoCol * multAncho;
    ARange.Height:= altoFil * multAlto;
    ARange.IncrementLeft(filaGraficos * anchoCol * multAncho);
    ARange.IncrementTop(colGraficos * altoFil * multAlto);}

    dec(colGraficos);
    if colGraficos = -1 then
    begin
      dec(filaGraficos);
      colGraficos:= 4;
    end;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  OpenDialog1.InitialDir:= uconstantesSimSEE.getDir_Run;
end;

function nroColToExcelStrCol(nroCol: Integer) : String;
const
  ExcelCols = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
var
  iLetra: Integer;
  res: String;
begin
  res:= '';

  while nroCol > Length(ExcelCols) do
  begin
    iLetra:= nroCol div Length(ExcelCols);
    res:= res + ExcelCols[iLetra];
    nroCol:= nroCol - iLetra * Length(ExcelCols)
  end;
  res:= res + ExcelCols[nroCol];

  result:= res;
end;

end.
