unit uEditarISONiveles;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, xMatDefs, StdCtrls, Grids, utilidades, ImgList;

type
  TEditarISONiveles = class(TForm)
    SGNiveles: TStringGrid;
    BGuardar: TButton;
    BCancelar: TButton;
    iconos: TImageList;
    BAgregarNivel: TButton;
    procedure BCancelarClick(Sender: TObject);
    procedure BGuardarClick(Sender: TObject);
    procedure SGNivelesDrawCell(Sender: TObject; ACol, ARow: Integer;
      Rect: TRect; State: TGridDrawState);
    procedure SGNivelesMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure SGNivelesMouseMove(Sender: TObject; Shift: TShiftState;
      X, Y: Integer);
    procedure SGNivelesMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure BAgregarNivelClick(Sender: TObject);
  private
    tiposCols: TDAOfTTipoColumna;

    niveles: TDAofNReal;
    etiquetasNiveles: TDAofString;

    procedure eliminarNivel(fila: Integer);
  public
    Constructor Create(Owner: TComponent; niveles: TDAofNReal;
      etiquetasNiveles: array of String); reintroduce;
    function getNiveles: TDAofNReal;
    function getEtiquetasNiveles: TDAofString;
  end;

var
  EditarISONiveles: TEditarISONiveles;

implementation

{$R *.dfm}

procedure TEditarISONiveles.BCancelarClick(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

procedure TEditarISONiveles.BGuardarClick(Sender: TObject);
var
  i: Integer;
begin
  i := -1;
  try
    SetLength(niveles, SGNiveles.RowCount - 1);
    SetLength(etiquetasNiveles, SGNiveles.RowCount - 1);

    i := 1;
    while i < SGNiveles.RowCount do
    begin
      if (SGNiveles.Cells[0, i] <> '') and (SGNiveles.Cells[1, i] <> '') then
      begin
        niveles[i - 1] := StrToFloat(SGNiveles.Cells[0, i]);
        etiquetasNiveles[i - 1] := SGNiveles.Cells[1, i];
        inc(i);
      end
      else
        raise ERangeError.Create(
          'Debe llenar los valores de todas las filas para continuar');
    end;
    ModalResult := mrOk;
  Except
    on e: EConvertError do
      ShowMessage('El valor introducido en la fila ' + IntToStr(i)
          + ' no es numerico.');
  end;
end;

procedure TEditarISONiveles.BAgregarNivelClick(Sender: TObject);
begin
  SGNiveles.RowCount := SGNiveles.RowCount + 1;
  utilidades.AutoSizeTable(self, SGNiveles, 600, 500, false);
  BAgregarNivel.Left := SGNiveles.Left + SGNiveles.Width - BAgregarNivel.Width;
end;

Constructor TEditarISONiveles.Create(Owner: TComponent; niveles: TDAofNReal;
  etiquetasNiveles: array of String);
var
  i: Integer;
begin
  inherited Create(Owner);
  SGNiveles.RowCount := Length(niveles) + 1;
  SGNiveles.Cells[0, 0] := 'Nivel';
  SGNiveles.Cells[1, 0] := 'Etiqueta';
  for i := 0 to high(niveles) do
  begin
    SGNiveles.Cells[0, i + 1] := FloatToStrF(niveles[i], ffFixed, 10, 2);
    SGNiveles.Cells[1, i + 1] := etiquetasNiveles[i];
  end;

  SetLength(tiposCols, 3);
  for i := 0 to 1 do
    tiposCols[i] := TC_TextoEditable;
  tiposCols[2] := TC_btEliminar;

  SGNiveles.DefaultColWidth := SGNiveles.Canvas.TextWidth('0000000000.00');
  // Numeros de 10 digitos y 2 posiciones decimales

  utilidades.AutoSizeTypedColsAndTable(SGNiveles, tiposCols, iconos, self, 600,
    500, false);
  BAgregarNivel.Left := SGNiveles.Left + SGNiveles.Width - BAgregarNivel.Width;
end;

function TEditarISONiveles.getNiveles: TDAofNReal;
begin
  result := niveles;
end;

function TEditarISONiveles.getEtiquetasNiveles: TDAofString;
begin
  result := etiquetasNiveles;
end;

procedure TEditarISONiveles.eliminarNivel(fila: Integer);
var
  textoAsPChar: PChar;
  i: Integer;
begin
  textoAsPChar := 'Confirma que desea eliminar el nivel seleccionado?';
  if (((SGNiveles.Cells[0, fila] = '') and (SGNiveles.Cells[1, fila] = '')) or
      (Application.MessageBox(textoAsPChar, 'Confirmar Eliminacin',
        MB_OKCANCEL + MB_ICONEXCLAMATION) = IDOK)) then
  begin
    for i := fila to SGNiveles.RowCount - 2 do
    begin
      SGNiveles.Cells[0, i] := SGNiveles.Cells[0, i + 1];
      SGNiveles.Cells[1, i] := SGNiveles.Cells[1, i + 1];
    end;
    SGNiveles.RowCount := SGNiveles.RowCount - 1;
    utilidades.AutoSizeTable(self, SGNiveles, 600, 500, false);
    BAgregarNivel.Left := SGNiveles.Left + SGNiveles.Width -
      BAgregarNivel.Width;
  end
end;

procedure TEditarISONiveles.SGNivelesDrawCell(Sender: TObject;
  ACol, ARow: Integer; Rect: TRect; State: TGridDrawState);
begin
  utilidades.ListadoDrawCell(Sender, ACol, ARow, Rect, State, tiposCols[ACol],
    nil, iconos);
end;

procedure TEditarISONiveles.SGNivelesMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  utilidades.ListadoMouseDown(Sender, Button, Shift, X, Y);
end;

procedure TEditarISONiveles.SGNivelesMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  utilidades.ListadoMouseMove(Sender, Shift, X, Y, tiposCols);
end;

procedure TEditarISONiveles.SGNivelesMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  res: TTipoColumna;
begin
  res := utilidades.ListadoMouseUp(Sender, Button, Shift, X, Y, tiposCols);
  case res of
    // TC_btEditar: editarFuente(filaListado, false);
    TC_btEliminar:
      eliminarNivel(filaListado);
    // TC_btClonar: editarFuente(filaListado, true);
  end;
end;

end.
