unit uProcesadorResultadosMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Menus, uProcesarOptVarEstado, uSeleccionarArchivo, uAcumuladorVars,
  uPromediarYAgrupar, uverdoc;

type
  TProcesadorResultadosMain = class(TForm)
    MainMenu1: TMainMenu;
    MArchivo: TMenuItem;
    MAyuda: TMenuItem;
    MSumadorVars: TMenuItem;
    MCostosHidraulicos: TMenuItem;
    MSeparador: TMenuItem;
    MSalir: TMenuItem;
    MAgruparAniosYPromediarCronicas: TMenuItem;
    procedure MSalirClick(Sender: TObject);
    procedure MCostosHidraulicosClick(Sender: TObject);
    procedure MSumadorVarsClick(Sender: TObject);
    procedure MAgruparAniosYPromediarCronicasClick(Sender: TObject);
    procedure MAyudaClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ProcesadorResultadosMain: TProcesadorResultadosMain;

implementation

{$R *.dfm}

procedure TProcesadorResultadosMain.MAgruparAniosYPromediarCronicasClick(
  Sender: TObject);
var
  fSelect: TSeleccionarArchivo;
  fVarEstado: TPromediarYAgrupar;
  nArch: String;
begin
  fSelect:= TSeleccionarArchivo.Create(self, TPromediarYAgrupar.filtrosDeArchivos);
  if fSelect.ShowModal = mrOk then
  begin
    nArch:= fSelect.getFileName;
    fSelect.Free;
    fVarEstado:= TPromediarYAgrupar.Create(self, nArch);
    fVarEstado.ShowModal;
    fVarEstado.Free;
  end
  else
  begin
    fSelect.Free;
  end;
end;

procedure TProcesadorResultadosMain.MAyudaClick(Sender: TObject);
begin
  verdoc( 'procesador-resultados-main', 'Ayuda del Procesador de Resultados');
end;

procedure TProcesadorResultadosMain.MCostosHidraulicosClick(Sender: TObject);
var
  fSelect: TSeleccionarArchivo;
  fVarEstado: TProcesarOptVarEstado;
  nArch: String;
begin
  fSelect:= TSeleccionarArchivo.Create(self, TProcesarOptVarEstado.filtrosDeArchivos);
  if fSelect.ShowModal = mrOk then
  begin
    nArch:= fSelect.getFileName;
    fSelect.Free;
    fVarEstado:= TProcesarOptVarEstado.Create(self, nArch);
    fVarEstado.ShowModal;
    fVarEstado.Free;
  end
  else
  begin
    fSelect.Free;
  end;
end;

procedure TProcesadorResultadosMain.MSalirClick(Sender: TObject);
begin
  self.Close;
end;

procedure TProcesadorResultadosMain.MSumadorVarsClick(Sender: TObject);
var
  fSelect: TSeleccionarArchivo;
  fVarEstado: TAcumuladorVars;
  nArch: String;
begin
  fSelect:= TSeleccionarArchivo.Create(self, TAcumuladorVars.filtrosDeArchivos);
  if fSelect.ShowModal = mrOk then
  begin
    nArch:= fSelect.getFileName;
    fSelect.Free;
    fVarEstado:= TAcumuladorVars.Create(self, nArch);
    fVarEstado.ShowModal;
    fVarEstado.Free;
  end
  else
  begin
    fSelect.Free;
  end;
end;

end.
