unit uSeleccionarArchivo;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, uConstantesSimSEE, ExtCtrls;

type
  TSeleccionarArchivo = class(TForm)
    OpenDialog1: TOpenDialog;
    Timer1: TTimer;
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    mres: Integer;
    filtros: String;
  public
    Constructor Create(Owner : TComponent; filtrosArchivos : String); reintroduce;

    function getFileName : String;
  end;

var
  SeleccionarArchivo: TSeleccionarArchivo;

implementation

{$R *.dfm}

Constructor TSeleccionarArchivo.Create(Owner : TComponent; filtrosArchivos : String);
begin
  inherited Create(Owner);
  filtros:= filtrosArchivos;
end;

procedure TSeleccionarArchivo.FormCreate(Sender: TObject);
begin
  self.Top:= Screen.Height +1;//Fuera de la pantalla
  self.Left:= Screen.Width +1;
  OpenDialog1.InitialDir:= uConstantesSimSEE.getDir_Run;
  OpenDialog1.Filter:= filtros;
end;

procedure TSeleccionarArchivo.FormShow(Sender: TObject);
begin
  if OpenDialog1.Execute then
    mres:= mrOk
  else
    mres:= mrCancel;
  Timer1.Enabled:= true;
end;

function TSeleccionarArchivo.getFileName : String;
begin
  if ModalResult = mrOk then
    result:= OpenDialog1.FileName
  else
    raise Exception.Create('No selecciono ningun archivo!');
end;

procedure TSeleccionarArchivo.Timer1Timer(Sender: TObject);
begin
  Timer1.Enabled:= false;
  ModalResult:= mres;
end;

end.
