unit uTestEvent;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  syncobjs;

type
  TWorker = class( TThread )
    evento: TEvent;
    nombre: string;

    constructor Create( xnombre: string );
    procedure Execute; override;
    procedure Free;
  end;


  { TForm1 }

  TForm1 = class(TForm)
    btSetEvent: TButton;
    cbRunning: TCheckBox;
    procedure Button1Click(Sender: TObject);
    procedure btSetEventClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormDblClick(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }

    evento: TEvent;
    w1, w2: TWorker;
  end;


var
  Form1: TForm1;
  mpid: integer;

implementation

{$R *.lfm}

{ TForm1 }


constructor TWorker.Create( xnombre: string );
begin
  inherited Create( true );
  FreeOnTerminate:= true;
  nombre:= xnombre;
  Suspended:= false;
end;

procedure TWorker.Free;
begin
  inherited Free;
end;


procedure TWorker.Execute;
begin
   evento:= TEvent.Create(nil, true, false, 'ElEvento'+IntToStr( mPid ) );
   while Form1.cbRunning.checked do
   begin
     evento.WaitFor( INFINITE );
     writeln( 'Hola desde .. ', nombre );
     evento.ResetEvent;
   end;
end;


procedure TForm1.Button1Click(Sender: TObject);
begin

end;

procedure TForm1.btSetEventClick(Sender: TObject);
begin
  evento.SetEvent;
end;

procedure TForm1.FormClose(Sender: TObject; var CloseAction: TCloseAction);
begin
   cbRunning.Checked:= false;
   evento.ResetEvent;
   w1.Terminate;
   w2.Terminate;
   evento.Free;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
   mpid:= getProcessId;
   evento:= TEvent.Create(nil, true, false, 'ElEvento'+IntToStr( mpid ) );
   w1:= TWorker.Create( 'Worker_1' );
   w2:= TWorker.Create( 'Worker_2' );
end;


procedure TForm1.FormDblClick(Sender: TObject);
begin

end;

end.

