unit uVisorPolOPT;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, Forms,
  Dialogs, StdCtrls, xMatDefs, uauxiliares,
  uestados,
  MatReal, isocurvas;

type

  { TForm3 }

  TForm3 = class(TForm)
    BPlotIsoCurvas: TButton;
    BProbarGraficador: TButton;
    OpenDialog1: TOpenDialog;
    ePrimerPaso: TEdit;
    Label1: TLabel;
    eUltimoPaso: TEdit;
    Label2: TLabel;
    procedure BPlotIsoCurvasClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
     CF: TAdminEstados;
  end;

var
  Form3: TForm3;

implementation
uses utrazosxy;

{$R *.lfm}

var
	trx: TfrmDLLForm;


procedure PlotIsoCurvas(
  Titulo: string;
  xlabel: string;
  ylabel: string;
  M: TMatR; vx, vy: TVectR;
  niveles: array of NReal;
  etiquetas: array of string );
var
  IsoScanner: TIsoScannerMatricial;
  px, py: NReal;
  pol: TPoligonalXY;
  res: boolean;
  ramaDirecta: boolean;
  plabel_x, plabel_y: NReal;
  knivel: integer;
  lblxy: TLabelXY;
  color: TColor;
begin
  trx:=TfrmDllForm.Create(form3);

	trx.CrearDiagramaXY(
		titulo, // Nombres
		512, // MaxNPuntos
		true, // ciruclar
		'x', // nombre_sx
		'', // nombre_sy1: pchar;
		clRed, //	color_sy1: TColor;
		vx.e(1), vx.e(vx.n), //	x1, x2,
		vy.e(1), vy.e(vy.n), //y1, y2
    vx.n-1,vy.n-1    // NDivX, NDivY
	);

	trx.show;
	trx.dbj_gridx ;
	trx.dbj_gridy;
	trx.dbj_borde;
	trx.titulo( titulo  );
	trx.etiquetas_x( vx.e(1), vx.e(vx.n) );
	trx.etiquetas_y( vy.e(1), vy.e(vy.n) );
	trx.xlabel( xlabel );
	trx.ylabel( ylabel );

  for knivel:= 0 to high( niveles ) do
  begin
    IsoScanner:= TIsoScannerMatricial.create( m, vx, vy, niveles[ knivel ] );
    color:= paleta1[ knivel+1 ];
    pol:= TPoligonalxy.Create( trx.tr1, 'p', false, color );
    ramaDirecta:= true;
    plabel_y:= 100000;

    repeat
       res:=IsoScanner.GetPunto(px, py );  {pedimos un punto a iso90}
       if IsoScanner.Estado = Reversa then
          ramaDirecta:= not ramaDirecta;

       if res then   {Si el punto es valido lo dibuja}
       begin
          if py < plabel_y then   {elige el punto ms bajo}
          begin
              plabel_x:= px;
              plabel_y:= py;          {para poner la etiqueta}
          end;
          if ramaDirecta then
            pol.nuevoPunto( px, py)
          else
            pol.nuevoPuntoAlInicio( px, py );
        end;

       if IsoScanner.Estado = Semiactivo then   {termino con una curva}
       begin

          pol.Replot;
          pol:= TPoligonalxy.Create( trx.tr1, 'p', false, color );
          ramaDirecta:= true;
          // labelXY(0,plabel.x,plabel.y,luxs); {etiqueta la curva}
          lblxy:= TLabelXY.Create( trx.tr1, 'l', plabel_x, plabel_y, etiquetas[knivel], color, 10 );
          plabel_y:=10000;
       end;
    until IsoScanner.Estado = fin;       {hasta terminar}
    trx.tr1.RePlot;
    IsoScanner.Free;
  end;
end;

procedure TForm3.Button1Click(Sender: TObject);
var
	k, ks2: integer;
//	hv: integer;
begin
	trx:=TfrmDllForm.Create(form3);

	trx.CrearDiagramaXY(
		'Diagrama1', // Nombres
		512, // MaxNPuntos
		true, // ciruclar
		'x', // nombre_sx
		'y', // nombre_sy1: pchar;
		clRed, //	color_sy1: TColor;
		0, 1000, //	x1, x2,
		0, 1000, //y1, y2
								10,8    // NDivX, NDivY
	);

	trx.show;
	ks2:=  trx.CrearSerieXY(	'S2', 512, true, clBlue );

	trx.xlabel( 'hola');
	trx.dbj_gridx ;
	trx.dbj_gridy;
	trx.dbj_borde;
	trx.titulo( 'El PRIMER TITULO');
	trx.etiquetas_x( 0, 1000 );
	trx.etiquetas_y( 0, 1000 );
	trx.xlabel( 'ejex');
	trx.ylabel( 'ejey');

	for k:= 0 to 50 do
	begin
		trx.tr1.PlotNuevo_x(  k*10 );
		trx.tr1.PlotNuevo_y( 1, 100 * (1+cos( 2*pi*k/100 )));
		trx.tr1.PlotNuevo_y( ks2, 800 * (1+sin( 2*pi*k/100 )));
		application.ProcessMessages;
		sleep( 100 );
	end;
end;

procedure TForm3.BPlotIsoCurvasClick(Sender: TObject);
var
  NContinuas, NDiscretas: integer;
  NEstrellasPorFrame: integer;
  NPuntosT: integer;

  I: Integer;

  x, y: TVectR;
  cv: array of TMatR;
  kPrimerPaso, kUltimoPaso, nPasos: integer;
  ixPrincipal, nPuntosPrincipal: integer;
  nMatrices: integer;

  kPaso: integer;
  fechaPasoStr: string;
  imat, ipaso: Integer;
  val: NReal;
  ce: array of NReal;

 dCdx_Inc, dCdx_Dec: NReal;
 resCod: integer;

begin
  if OpenDialog1.Execute then
  begin
    CF:= TAdminEstados.CreateLoadFromArchi( OpenDialog1.FileName );

    x:= nil;
    y:= nil;
    cv:= nil;
    setlength( cv , 0 );

    try
      NContinuas:= CF.nVarsContinuas;
      NDiscretas:= CF.nVarsDiscretas;
      NEstrellasPorFrame:= CF.nEstrellasPorPuntoT;
      NPuntosT:= CF.nPuntosT;

      kPrimerPaso:= strToInt(ePrimerPaso.Text);
      kUltimoPaso:= strToInt(eUltimoPaso.Text);
      nPasos:= kUltimoPaso-kPrimerPaso+1;

      ixPrincipal:= 0; // esto es la primer variable continua es la mia
      nPuntosPrincipal:= CF.xr_def[ixPrincipal].NPuntos;
      nMatrices:= NEstrellasPorFrame div nPuntosPrincipal;
      setlength( cv, nMatrices );
      x:= TVectR.Create_Init( nPasos );
      y:= TVectR.Create_Init( nPuntosPrincipal );
      setlength( ce , nPuntosPrincipal );
      for I := 0 to nPuntosPrincipal - 1 do
        ce[i]:= 1000*9.8*0.86*( CF.xr_def[ixPrincipal].traduccion.x[i] - 5.05 ) / 3600.0;

      for I := 1 to y.n do
        y.pv[i]:= CF.xr_def[ixPrincipal].traduccion.x[i-1];

      for i:= 1 to x.n do
        x.pv[i]:= kPrimerPaso+i-1;

      for i := 0 to nMatrices - 1 do
          cv[i]:= TMatR.Create_Init( x.n, y.n );

      for kPaso:= 1 to CF.nPuntosT do
      begin
        fechaPasoStr:= CF.fechaIni.AsISOStr;
        iPaso:= kPaso- kPrimerPaso +1;
        if (iPaso >=1  ) and ( iPaso <= x.n ) then
        begin
          CF.setEstrellaCERO;
          for imat := 0 to high( cv ) do
             for I := 1 to y.n do
             begin
                CF.devxr_estrella_(ixPrincipal, kPaso,
                  dCdx_Inc, dCdx_Dec, resCod );
                val:= -dCdx_Dec;
                cv[imat].pon_e( iPaso, i, val/ ce[i-1] );
                CF.IncEstrella;
             end;
        end;
      end;

    for I := 0 to high( cv )  do
     PlotIsoCurvas('EstadoH: '+IntToStr( i+1 ),
      'semana', 'cota Bonete',
      cv[i], x, y,
      [250,  400,   1200,2000,    85,     139,   113,    107, 185],
      ['F1', 'F2', 'F3', 'F4', '5y6ta', 'CTR', 'PTI', 'SB', 'TGAA'] );

    finally
      CF.Free;
      CF:= nil;
      for i := 0 to high( cv ) do
        cv[i].Free;
      setlength( cv, 0 );

      if x <> nil then
        x.Free;
      if y <> nil then
        y.Free;


    end;
  end;
(*
  pol1:= TPoligonal.Create( trx.tr1, 'pol1', true, clRed );
  pol1.nuevoPunto(10, 10);
  pol1.nuevoPunto(30, 30);
  pol1.nuevoPunto(30, 40);
  pol1.nuevoPunto(45, 40);
  pol1.Replot;
  *)
end;




end.
