unit uVisorPolOpt_;
interface

uses
  Classes, SysUtils, FileUtil, SynHighlighterPas, Forms, Controls, Graphics,
  Dialogs, StdCtrls, ExtCtrls, xmatdefs, matreal, uauxiliares, isocurvas;

type

  { TForm1 }

  TForm1 = class(TForm)
    BPlotIsoCurvas: TButton;
    BProbarGraficador: TButton;
    ePrimerPaso: TEdit;
    eUltimoPaso: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    OpenDialog1: TOpenDialog;
    procedure BPlotIsoCurvasClick(Sender: TObject);
    procedure BProbarGraficadorClick(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end;

var
  Form1: TForm1;

implementation

uses utrazosxy;

{$R *.lfm}

var
  trx: TfrmDLLForm;

procedure PlotIsoCurvas(Titulo: string; xlabel: string; ylabel: string;
  M: TMatR; vx, vy: TVectR; niveles: array of NReal; etiquetas: array of string);
var
  IsoScanner: TIsoScannerMatricial;
  px, py: NReal;
  pol: TPoligonalXY;
  res: boolean;
  ramaDirecta: boolean;
  plabel_x, plabel_y: NReal;
  knivel: integer;
  lblxy: TLabelXY;
  color: TColor;
begin
  trx := TfrmDllForm.Create(form1);

  trx.CrearDiagramaXY(
    titulo, // Nombres
    512, // MaxNPuntos
    True, // ciruclar
    'x', // nombre_sx
    '', // nombre_sy1: pchar;
    clRed, //  color_sy1: TColor;
    vx.e(1), vx.e(vx.n), //  x1, x2,
    vy.e(1), vy.e(vy.n), //y1, y2
    vx.n - 1, vy.n - 1    // NDivX, NDivY
    );

  trx.Show;
  trx.dbj_gridx;
  trx.dbj_gridy;
  trx.dbj_borde;
  trx.titulo(titulo);
  trx.etiquetas_x(vx.e(1), vx.e(vx.n));
  trx.etiquetas_y(vy.e(1), vy.e(vy.n));
  trx.xlabel(xlabel);
  trx.ylabel(ylabel);

  for knivel := 0 to high(niveles) do
  begin
    IsoScanner := TIsoScannerMatricial.Create(m, vx, vy, niveles[knivel]);
    color := paleta1[knivel + 1];
    pol := TPoligonalxy.Create(trx.tr1, 'p', False, color);
    ramaDirecta := True;
    plabel_y := 100000;

    repeat
      res := IsoScanner.GetPunto(px, py);  {pedimos un punto a iso90}
      if IsoScanner.Estado = Reversa then
        ramaDirecta := not ramaDirecta;

      if res then   {Si el punto es valido lo dibuja}
      begin
        if py < plabel_y then   {elige el punto más bajo}
        begin
          plabel_x := px;
          plabel_y := py;          {para poner la etiqueta}
        end;
        if ramaDirecta then
          pol.nuevoPunto(px, py)
        else
          pol.nuevoPuntoAlInicio(px, py);
      end;

      if IsoScanner.Estado = Semiactivo then   {termino con una curva}
      begin

        pol.Replot;
        pol := TPoligonalxy.Create(trx.tr1, 'p', False, color);
        ramaDirecta := True;
        // labelXY(0,plabel.x,plabel.y,luxs); {etiqueta la curva}
        lblxy := TLabelXY.Create(trx.tr1, 'l', plabel_x, plabel_y,
          etiquetas[knivel], color, 10);
        plabel_y := 10000;
      end;
    until IsoScanner.Estado = fin;       {hasta terminar}
    trx.tr1.RePlot;
    IsoScanner.Free;
  end;
end;

{ TForm1 }

procedure TForm1.BProbarGraficadorClick(Sender: TObject);
var
  k, ks2: integer;
  //  hv: integer;
begin
  trx := TfrmDllForm.Create(Panel1);

  trx.CrearDiagramaXY(
    'Diagrama1', // Nombres
    512, // MaxNPuntos
    True, // ciruclar
    'x', // nombre_sx
    'y', // nombre_sy1: pchar;
    clRed, //  color_sy1: TColor;
    0, 1000, //  x1, x2,
    0, 1000, //y1, y2
    10, 8    // NDivX, NDivY
    );

  trx.Show;
  ks2 := trx.CrearSerieXY('S2', 512, True, clBlue);

  trx.xlabel('hola');
  trx.dbj_gridx;
  trx.dbj_gridy;
  trx.dbj_borde;
  trx.titulo('El PRIMER TITULO');
  trx.etiquetas_x(0, 1000);
  trx.etiquetas_y(0, 1000);
  trx.xlabel('ejex');
  trx.ylabel('ejey');

  for k := 0 to 50 do
  begin
    trx.tr1.PlotNuevo_x(k * 10);
    trx.tr1.PlotNuevo_y(1, 100 * (1 + cos(2 * pi * k / 100)));
    trx.tr1.PlotNuevo_y(ks2, 800 * (1 + sin(2 * pi * k / 100)));
    application.ProcessMessages;
    sleep(100);
  end;
end;





type
  TFichaVarR = class
    Nombre, unidades: string;
    Nombre_xt, unidades_xt: string;
    xmin, xmax: NReal;
    xmin_xt, xmax_xt: NReal;
    NPuntos, NPuntos_xt: integer;
    x, xt: array of NReal;
    constructor CreateRead(var f: textfile);
    procedure Free;
  end;

constructor TFichaVarR.CreateRead(var f: textfile);
var
  r: string;
  k: integer;
  tiene_xt: boolean;

begin
  inherited Create;

  readln(f, r);
  Nombre := NextStrParam(r, 'Nombre:');
  r := trim(r);
  if r <> '' then
  begin
    tiene_xt := True;
    Nombre_xt := NextPal(r);
  end;

  readln(f, r);
  unidades := NextStrParam(r, 'unidades:');
  if tiene_xt then
    unidades_xt := NextPal(r);

  readln(f, r);
  xmin := NextFloatParam(r, 'xmin:');
  if tiene_xt then
    xmin_xt := NextFloat(r);

  readln(f, r);
  xmax := NextFloatParam(r, 'xmax:');
  if tiene_xt then
    xmax_xt := NextFloat(r);

  readln(f, r);
  NPuntos := NextIntParam(r, 'NPuntos:');
  if tiene_xt then
    NPuntos_xt := NextInt(r);

  setlength(x, NPuntos);
  if tiene_xt then
    setlength(xt, NPuntos_xt);
  ;

  readln(f, r);
  nextpal(r); // quintamos el x[..]:
  for k := 0 to NPuntos - 1 do
    x[k] := nextFloat(r);

  if tiene_xt then
  begin
    readln(f, r);
    nextpal(r); // quintamos el x[..]:
    for k := 0 to NPuntos_xt - 1 do
      xt[k] := nextFloat(r);
  end;
end;

procedure TFichaVarR.Free;
begin
  setlength(x, 0);
  inherited Free;
end;

procedure TForm1.BPlotIsoCurvasClick(Sender: TObject);
var
  //  pol1: TPoligonalxy;

  f: textFile;
  //  archi: string;
  r: string;
  qAct: NReal;
  NContinuas, NDiscretas: integer;
  NEstrellasPorFrame: integer;
  NPuntosT: integer;

  varsR: array of TFichaVarR;
  I: integer;

  x, y: TVectR;
  cv: array of TMatR;
  kPrimerPaso, kUltimoPaso, nPasos: integer;
  ixPrincipal, nPuntosPrincipal: integer;
  nMatrices: integer;

  kPaso: integer;
  fechaPasoStr: string;
  imat, ipaso: integer;
  val: NReal;
  ce: array of NReal;
begin
  if OpenDialog1.Execute then
  begin
    assignfile(f, OpenDialog1.FileName);
    reset(f);

    x := nil;
    y := nil;
    cv := nil;
    setlength(varsR, 0);
    setlength(cv, 0);

    try
      qAct := ReadlnFloatParam(f, 'fActPaso:');
      NContinuas := ReadlnIntParam(f, 'NContinuas:');
      NDiscretas := ReadlnIntParam(f, 'NDiscretas:');
      NEstrellasPorFrame := ReadlnIntParam(f, 'nEstrellas/PuntoT:');
      NPuntosT := ReadlnIntParam(f, 'nPuntosT:');
      setLength(varsR, NContinuas);
      readln(f, r); // descripción variables continuas
      for I := 0 to NContinuas - 1 do
        varsR[I] := TFichaVarR.CreateRead(f);
      // aqui me están faltando leer las discretas
      readln(f, r); // renglón en blanco antes de la matriz


      kPrimerPaso := StrToInt(ePrimerPaso.Text);
      kUltimoPaso := StrToInt(eUltimoPaso.Text);
      nPasos := kUltimoPaso - kPrimerPaso + 1;

      ixPrincipal := 0; // esto es la primer variable continua es la mia
      nPuntosPrincipal := varsR[ixPrincipal].NPuntos;
      nMatrices := NEstrellasPorFrame div nPuntosPrincipal;
      setlength(cv, nMatrices);
      x := TVectR.Create_Init(nPasos);
      y := TVectR.Create_Init(nPuntosPrincipal);
      setlength(ce, nPuntosPrincipal);
      for I := 0 to nPuntosPrincipal - 1 do
        ce[i] := 1000 * 9.8 * 0.86 * (varsR[ixPrincipal].xt[i] - 5.05) / 3600.0;

      readln(f, r); // encabezados

      nextpal(r);
      nextpal(r); // salteamos dos columnas
      for I := 1 to y.n do
        y.pv[i] := nextFloat(r);

      for i := 1 to x.n do
        x.pv[i] := kPrimerPaso + i - 1;

      for i := 0 to nMatrices - 1 do
        cv[i] := TMatR.Create_Init(x.n, y.n);

      while not EOF(f) do
      begin
        readln(f, r);
        kPaso := nextInt(r);
        fechaPasoStr := nextPal(r);
        iPaso := kPaso - kPrimerPaso + 1;
        if (iPaso >= 1) and (iPaso <= x.n) then
        begin
          for imat := 0 to high(cv) do
            for I := 1 to y.n do
            begin
              val := nextFloat(r);
              cv[imat].pon_e(iPaso, i, val / ce[i - 1]);
            end;
        end;
      end;

      for I := 0 to high(cv) do
        PlotIsoCurvas('EstadoH: ' + IntToStr(i + 1),
          'semana', 'cota Bonete',
          cv[i], x, y,
          [250, 400, 1200, 2000, 85, 139, 113, 107, 185],
          ['F1', 'F2', 'F3', 'F4', '5y6ta', 'CTR', 'PTI', 'SB', 'TGAA']);

    finally
      closefile(f);
      for I := 0 to high(varsR) do
        varsR[I].Free;
      setlength(varsR, 0);

      for i := 0 to high(cv) do
        cv[i].Free;
      setlength(cv, 0);

      if x <> nil then
        x.Free;
      if y <> nil then
        y.Free;

    end;
  end;
(*
  pol1:= TPoligonal.Create( trx.tr1, 'pol1', true, clRed );
  pol1.nuevoPunto(10, 10);
  pol1.nuevoPunto(30, 30);
  pol1.nuevoPunto(30, 40);
  pol1.nuevoPunto(45, 40);
  pol1.Replot;
  *)
end;


end.
