unit useries_explorer;

{$mode delphi}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, ExtCtrls,
  StdCtrls, PairSplitter, ColorBox, ComCtrls,
  xmatdefs, useriestemporales, umodelosintcegh, ugraficador,
  matreal;

type

  { TFormSeriesExplorer }

  TFormSeriesExplorer = class(TForm)
    btCargarSeries: TButton;
    btRedibujar: TButton;
    btRellear: TButton;
    cbMostrar: TCheckBox;
    ColorDialog1: TColorDialog;
    ComboBox_Series: TComboBox;
    ecolorlinea: TEdit;
    eGrosorLinea: TLabeledEdit;
    gbInformacion: TGroupBox;
    gbControles: TGroupBox;
    exmin: TLabeledEdit;
    exmax: TLabeledEdit;
    eymin: TLabeledEdit;
    eymax: TLabeledEdit;
    GroupBox1: TGroupBox;
    eTamanioMarcador: TLabeledEdit;
    e_UmbralFiltro: TLabeledEdit;
    OpenDialog1: TOpenDialog;
    PaintBox1: TPaintBox;
    radiGroupEje: TRadioGroup;
    ScrollBar1: TScrollBar;
    Splitter1: TSplitter;
    Splitter2: TSplitter;
    udGrosorLinea: TUpDown;
    UpDown1: TUpDown;
    procedure btCargarSeriesClick(Sender: TObject);
    procedure btRedibujarClick(Sender: TObject);
    procedure btRellearClick(Sender: TObject);
    procedure ComboBox_SeriesChange(Sender: TObject);
    procedure ecolorlineaClick(Sender: TObject);
    procedure eGrosorLineaChange(Sender: TObject);
    procedure eTamanioMarcadorChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure gbControlesClick(Sender: TObject);
    procedure PaintBox1Click(Sender: TObject);
    procedure PaintBox1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure PaintBox1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure PaintBox1Paint(Sender: TObject);
    procedure radiGroupEjeClick(Sender: TObject);
    procedure radiGroupEjeKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure rbEjePrincipalChange(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
    series: TSeriesDeDatos;
    g: TGrafico;
    sxdts: TVectR;
    kDesde, kHasta: integer;

    flg_mouse_down: boolean;
    flg_resize: boolean;
    mouse_up_x, mouse_up_y, mouse_down_x, mouse_down_y: integer;
    xDesde, xHasta, yDesde, yHasta: NReal;
    kSerieSeleccionada: integer;
    serieSeleccionada: TSerieGrafico;
  end;

var
  FormSeriesExplorer: TFormSeriesExplorer;

implementation

{$R *.lfm}

{ TFormSeriesExplorer }

procedure TFormSeriesExplorer.FormCreate(Sender: TObject);
begin
  series := nil;
  g := nil;
  sxdts := nil;
  flg_mouse_down:= false;
end;

procedure TFormSeriesExplorer.gbControlesClick(Sender: TObject);
begin

end;

procedure TFormSeriesExplorer.PaintBox1Click(Sender: TObject);
begin

end;

procedure TFormSeriesExplorer.PaintBox1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  mouse_down_x:= x;
  mouse_down_y:= y;
  writeln( 'mouse_down x: ', mouse_down_x,', ', mouse_down_y );
  flg_mouse_down:= true;
end;

procedure TFormSeriesExplorer.PaintBox1MouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);

begin
  mouse_up_x:= x;
  mouse_up_y:= y;
  writeln( 'mouse_up x: ', mouse_up_x,', ', mouse_up_y );

  if flg_mouse_down and ( mouse_up_x > mouse_down_x ) and ( mouse_up_y > mouse_down_y ) then
  begin
    if g <> nil then
    begin
      flg_resize:= true;
      xDesde:= g.w2x( mouse_down_x);
      xHasta:= g.w2x( mouse_up_x );
      yDesde:= g.h2y( mouse_up_y );
      yhasta:= g.h2y( mouse_down_y );
      kDesde:= trunc( sxdts.inv_interpol( xDesde ) + 0.5 );
      kHasta:= trunc( sxdts.inv_interpol( xHasta ) + 0.5 );
      PaintBox1.Invalidate;
    end;
  end;
  flg_mouse_down:= false;

end;

procedure TFormSeriesExplorer.PaintBox1Paint(Sender: TObject);
var
  k: integer;
  sx, sy: TSerieGrafico;
  rescod: integer;

begin
  if series <> nil then
  begin
    if flg_resize then
    begin
      g.eje_x.Forzar_vmin( xDesde );
      g.eje_x.Forzar_vmax( xHasta );
      g.eje_y.Forzar_vmin( yDesde );
      g.eje_y.Forzar_vmax( yHasta );
    end
    else
    begin
      val( exmin.text, xDesde, rescod );
      if rescod = 0 then
          g.eje_x.Forzar_vmin( xDesde )
      else
         g.eje_x.Librar_vmin;

      val( exmax.text, xHasta, rescod );
      if rescod = 0 then
          g.eje_x.Forzar_vmax( xHasta )
      else
         g.eje_x.Librar_vmax;

      val( eymin.text, yDesde, rescod );
      if rescod = 0 then
          g.eje_y.Forzar_vmin( yDesde )
      else
         g.eje_y.Librar_vmin;

      val( eymax.text, yHasta, rescod );
      if rescod = 0 then
          g.eje_y.Forzar_vmax( yHasta )
      else
         g.eje_y.Librar_vmax;
    end;
    g.Draw( PaintBox1.Canvas, PaintBox1.Width, PaintBox1.Height );
  end;
end;

procedure TFormSeriesExplorer.radiGroupEjeClick(Sender: TObject);
begin

    if serieSeleccionada <> nil then
    begin
     serieSeleccionada.eje:= radiGroupEje.ItemIndex;
     PaintBox1.Invalidate;
    end;
end;

procedure TFormSeriesExplorer.radiGroupEjeKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
end;

procedure TFormSeriesExplorer.rbEjePrincipalChange(Sender: TObject);
begin

end;

procedure TFormSeriesExplorer.btCargarSeriesClick(Sender: TObject);
var
  sx, sy: TSerieGrafico;
  k: integer;
  gg: TGrafico;
begin
  if OpenDialog1.Execute then
  begin
    if g <> nil then
    begin
      g.Free;
      g:= nil;
    end;

    if series <> nil then
      series.Free;
    if sxdts <> nil then
      sxdts.Free;

    series := TSeriesDeDatos.CreateFromArchi(OpenDialog1.FileName);

    ComboBox_Series.Items.Clear;
    ComboBox_Series.Items:= series.nombresSeries;

    sxdts := TVectR.Create_init(series.NPuntos);
    for k := 1 to sxdts.n do
      sxdts.pon_e(k, series.dtMuestra(k));


    kDesde:= 1;
    kHasta:= sxdts.n;

    gg := TGrafico.Create('explorador_de_series', TG_DispersionXY, 1);
    sx := TSerieGrafico.Create('dt', sxdts.toTDAOfNReal(1, sxdts.n), nil, gg, '', True);
    gg.AddSerie(sx);
    for k := 1 to series.NSeries do
    begin
      sy := TSerieGrafico.Create(
         series.nombresSeries[k-1],
         series.series[k-1].toTDAOfNReal( kDesde, kHasta ), sx, gg);
      gg.AddSerie(sy);
    end;

    flg_resize:= false;
    g:= gg;
    PaintBox1.Invalidate;
  end;
end;

procedure TFormSeriesExplorer.btRedibujarClick(Sender: TObject);
begin
  PaintBox1.Invalidate;
end;

procedure TFormSeriesExplorer.btRellearClick(Sender: TObject);
var
  y: TVectR;
begin
  y:= TVectR.Create_FromDAofR( serieSeleccionada.valores );
  y.RellenarHuecos( StrToFloat( e_UmbralFiltro.Text ));
  y.CopyTo( serieSeleccionada.valores );
  y.WriteXLTSimple_archi('rellenado.xlt');
  invalidate;
  y.Free;
end;

procedure TFormSeriesExplorer.ComboBox_SeriesChange(Sender: TObject);
begin
  kSerieSeleccionada:= ComboBox_Series.ItemIndex;
  if g <> nil then
  begin
    serieSeleccionada:= g.series_y[kSerieSeleccionada];
    radiGroupEje.ItemIndex:= serieSeleccionada.eje;
    ecolorlinea.Color:= serieSeleccionada.colorLinea;
    eTamanioMarcador.Text:= IntToStr( serieSeleccionada.RadioMarcador );
    eGrosorLinea.Text:= IntToStr( serieSeleccionada.AnchoLinea );
  end;
end;

procedure TFormSeriesExplorer.ecolorlineaClick(Sender: TObject);
begin
  if ColorDialog1.Execute then
  begin
    serieSeleccionada.colorLinea:= ColorDialog1.Color;
    ecolorlinea.Color:=ColorDialog1.Color;
    PaintBox1.Invalidate;
  end;
end;

procedure TFormSeriesExplorer.eGrosorLineaChange(Sender: TObject);
var
  radio, rescod: integer;
begin
  val( eGrosorLinea.Text, radio, rescod );
  if rescod = 0 then
  begin
     serieSeleccionada.AnchoLinea:= radio;
     PaintBox1.Invalidate;
  end;
end;

procedure TFormSeriesExplorer.eTamanioMarcadorChange(Sender: TObject);
var
  radio, rescod: integer;
begin
  val( eTamanioMarcador.Text, radio, rescod );
  if rescod = 0 then
  begin
     serieSeleccionada.RadioMarcador:= radio;
     PaintBox1.Invalidate;
  end;

end;

end.
(**********
 g.eje_x.Forzar_vmin(0);
 g.eje_x.Forzar_vmax( 24*4);
 g.eje_x.Forzar_ndivs( 4*4 );

 g.eje_x.FloatFormat_NDigitos:=12;
 g.eje_x.FloatFormat_NDecimales:=0;
 g.eje_y.FloatFormat_NDigitos:= 12;
 g.eje_y.FloatFormat_NDecimales:= 0;

  g.eje_x.titulo:= 'hora ( 0 Verano, 24 Otoño, 48 Invierno, 72 Primavera ) ';
  if pos( 'KTM_', nombreSerie  ) <> 0 then
  begin
    g.eje_y.Forzar_vmin( 0 );
    g.eje_y.Forzar_vmax( 1 );
    g.eje_y.Forzar_ndivs( 10 );
    g.eje_y.titulo:= 'índice de claridad [p.u.]';
    g.eje_y.FloatFormat_NDecimales:= 2;
  end
  else if pos( 'TMP_', nombreSerie ) <> 0 then
  begin
    g.eje_y.Forzar_vmin( 0 );
    g.eje_y.Forzar_vmax( 35 );
    g.eje_y.Forzar_ndivs( 7 );
    g.eje_y.titulo:= 'Temperatura [°C]';
  end
  else
  begin  // V_
    g.eje_y.Forzar_vmin( -12 );
    g.eje_y.Forzar_vmax( 12 );
    g.eje_y.Forzar_ndivs( 24 );
    g.eje_y.titulo:= '[m/s]';
  end;

  c1:= TCajaGraficoXY.Create( 24-0.9, g.eje_y.v_min_forzado, 24-0.1,  g.eje_y.v_max_forzado, '' );
  c2:= TCajaGraficoXY.Create( 48-0.9, g.eje_y.v_min_forzado, 48-0.1,  g.eje_y.v_max_forzado, '' );
  c3:= TCajaGraficoXY.Create( 72-0.9, g.eje_y.v_min_forzado, 72-0.1,  g.eje_y.v_max_forzado, '' );

  c1.colorArea:= clLtGray;  c1.colorLinea:= clWhite;  g.AddCajaXY( c1 );
  c2.colorArea:= clLtGray;  c2.colorLinea:= clWhite;  g.AddCajaXY( c2 );
  c3.colorArea:= clLtGray;  c3.colorLinea:= clWhite;  g.AddCajaXY( c3 );

  c1:= TCajaGraficoXY.Create(
       8, g.eje_y.v_max_forzado - 0.1*(  g.eje_y.v_max_forzado -  g.eje_y.v_min_forzado ),
       20, g.eje_y.v_max_forzado - 0.2*(  g.eje_y.v_max_forzado -  g.eje_y.v_min_forzado ),
       'Verano' );
  c1.colorLinea:= clNone;
  c1.colorArea:= clNone;
  g.AddCajaXY( c1 );

  c1:= TCajaGraficoXY.Create(
       24+8, g.eje_y.v_max_forzado - 0.1*(  g.eje_y.v_max_forzado -  g.eje_y.v_min_forzado ),
       24+20, g.eje_y.v_max_forzado - 0.2*(  g.eje_y.v_max_forzado -  g.eje_y.v_min_forzado ),
       'Otoño' );
  c1.colorLinea:= clNone;
  c1.colorArea:= clNone;
  g.AddCajaXY( c1 );

  c1:= TCajaGraficoXY.Create(
       48+8, g.eje_y.v_max_forzado - 0.1*(  g.eje_y.v_max_forzado -  g.eje_y.v_min_forzado ),
       48+20, g.eje_y.v_max_forzado - 0.2*(  g.eje_y.v_max_forzado -  g.eje_y.v_min_forzado ),
       'Invierno' );
  c1.colorLinea:= clNone;
  c1.colorArea:= clNone;
  g.AddCajaXY( c1 );

  c1:= TCajaGraficoXY.Create(
       72+8, g.eje_y.v_max_forzado - 0.1*(  g.eje_y.v_max_forzado -  g.eje_y.v_min_forzado ),
       72+20, g.eje_y.v_max_forzado - 0.2*(  g.eje_y.v_max_forzado -  g.eje_y.v_min_forzado ),
       'Primavera' );
  c1.colorLinea:= clNone;
  c1.colorArea:= clNone;
  g.AddCajaXY( c1 );


  g.Titulo:='Perfil diario por estación '+ NombreSerie;
  ***************)
