unit udscanner_eliminarbom;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, udirectoryscanner;

type
  { TDirectoryScanner_EliminarBOM }

  TDirectoryScanner_EliminarBOM = class(TDirectoryScanner)
    procedure scan(const carpeta_raiz: string); override;
    procedure procesar_archivo(const carpeta, nombre_archivo: string); override;
  end;


implementation


{ TDirectoryScanner_EliminarBOM }

procedure TDirectoryScanner_EliminarBOM.scan(const carpeta_raiz: string);
begin
  procesar_carpeta(carpeta_raiz, '*.txt');
  procesar_carpeta(carpeta_raiz, '*.pas');
  procesar_carpeta(carpeta_raiz, '*.pp');
  procesar_carpeta(carpeta_raiz, '*.dfm');
  procesar_carpeta(carpeta_raiz, '*.lfm');
  procesar_carpeta(carpeta_raiz, '*.lpi');
  procesar_carpeta(carpeta_raiz, '*.lpr');
end;

procedure TDirectoryScanner_EliminarBOM.procesar_archivo(
  const carpeta, nombre_archivo: string);
var
  f: file of byte;
  a, b, c: byte;
  k: integer;
  s: string;

begin
  s := archi(carpeta, nombre_archivo);
  assignfile(f, s);
  filemode := 2; // read
  reset(f);
  for k := 0 to 2 do
  begin
    Read(f, a);
    if a = 239 then
    begin
      Read(f, b);
      if b = 187 then
      begin
        Read(f, c);
        if (c = 191) then
        begin
          reset(f);
          Write(f, 32);
          Write(f, 32);
          Write(f, 32);
          writeln('corregido: ', s);
        end;
      end;
    end
    else
    if (a and $80) <> 0 then
    begin
      writeln('sospechozo: ', s);
      readln;
    end;
  end;
  closefile(f);
end;


end.

